import { setTouchEnabled, setlevelData } from './GoldData';
/**
 * Created by rockyl on 2020-01-09.
 */

import GameView from "./GameView";
import { injectProps } from "../props";
import { setScore, setCurLevel } from "./goldData";
import { getJsonAsset } from "./JsonTools";



export class GameWrapper extends engine.Container {
	// private _status;
	private _gameView: GameView;

	constructor() {
		super();

		engine.globalEvent.addEventListener('seabed-game-start', this.start, this);
		engine.globalEvent.addEventListener('seabed-game-revive', this.revive, this);
		engine.globalEvent.addEventListener('seabed-game-startNextLevel', this.startNextLevel, this);

		engine.globalEvent.addEventListener('seabed-game-themeChange', this.themeChange, this);
		
		//创建实例
		let gameView = this._gameView = new GameView();
		this.addChild(gameView);

		//this.start(null);
		// setTimeout(() => {
		// 	engine.globalEvent.dispatchEvent('seabed-game-startNextLevel',{level:2});
		// }, 300);
	}
	start(event: engine.Event) {
		setlevelData();
		this.initData();
		this._gameView.start(event.data.color);
		['coin','boom','fail','success'].forEach(element => {
			getJsonAsset(element);
		});
	}
	startNextLevel(event: engine.Event){
		setScore(0);
		setCurLevel(parseInt(event.data.level));
		this._gameView.startNextLevel();
	}

	initData(){
		setScore(0);
		setCurLevel(1);
	}

	//复活
	revive(){
		this._gameView.revive();
	}
	themeChange(event: engine.Event){
		this._gameView.themeChange(event.data.resData);
	}
}
