/**
 * Created by rockyl on 2018/8/16.
 */

import { props } from "../props";
import { getIndexFromRC, getRandomArray, getTexture, getTextureByName } from "./utils";
import ObjectPool = engine.ObjectPool;
import { Tool } from "./Tools";
import { getScore, getCurLevel, getlevelMax } from "./goldData";


export default class GameData extends engine.Container {

    private _scoreCount:engine.Label;
    private _scorelabel:engine.Label;
    private _levelLabel:engine.Label;
    private _parentNode;

    private starList = [];
    private _progressMask;
    private _color;
	constructor(parentNode,color) {
        super();
        this._parentNode = parentNode;
        this._color = color;
        this.init();
  }
  init(){
      //分数
      let scoreCount = this._scoreCount = Tool.getLabel('',36,"#ffffff",true)
      scoreCount.y = 48;
      this.addChild(scoreCount);

      let scorelabel = this._scorelabel = Tool.getLabel('分',22,"#ffffff")

      scorelabel.y = 56;
      this.addChild(scorelabel);

      let progress = new engine.Sprite(getTextureByName('进度'));
      progress.x = 212;
      progress.y = 8;
      this.addChild(progress);

      let progressMask =  this._progressMask = new engine.Rect()
      progressMask.fillColor = 0x000000
      progressMask.width = 245;
      progressMask.height = 100;
      progressMask.x = 213;
      progressMask.y = 5;
      //0.35 0.75 1
      progressMask.scaleX = 0;
      this.addChild(progressMask);

      progress.mask = progressMask;

      let star1 = new engine.Sprite(getTextureByName('点亮'));
      star1.x = 270;
      star1.y = 6;
      star1.visible = false;
      this.addChild(star1);
      this.starList.push(star1);

      let star2 = new engine.Sprite(getTextureByName('点亮'));
      star2.x = 365;
      star2.y = 6;
      star2.visible = false;
      this.addChild(star2);
      this.starList.push(star2);

      let star3 = new engine.Sprite(getTextureByName('点亮'));
      star3.x = 435;
      star3.y = 50;
      star3.visible = false;
      this.addChild(star3);
      this.starList.push(star3);

      this.scorePosUpdate();

      //当前关卡数
      let levelLabel = this._levelLabel = Tool.getLabel('',28,this._color||"#28c1ec",false)
      levelLabel.y = 98;
      this.addChild(levelLabel);
      this.levelUpdate();

      this.updateProgressMask();
  }

  scorePosUpdate(){
    this._scoreCount.text = getScore()
    this._scoreCount.x = (this._parentNode.width - this._scoreCount.width - this._scorelabel.width - 5)/2
    this._scorelabel.x = this._scoreCount.x + this._scoreCount.width + 5;
    this.updateProgressMask();
  }
  levelUpdate(color?){

    this._levelLabel.text = `第${getCurLevel()}/3关`
    this._levelLabel.x = (this._parentNode.width-this._levelLabel.width)/2;
  }

  updateProgressMask(){
    let ratio = getScore()/getlevelMax()
    this._progressMask.scaleX = ratio;
    //0.35 0.75 1
    if(ratio >= 0.35){
      this.starList[0].visible = true;
    }
    if(ratio >= 0.75){
      this.starList[1].visible = true;
    }
    if(ratio >= 1){
      this.starList[2].visible = true;
    }
  }
  resetMask(){
    this.starList.forEach(element => {
      element.visible = false;
    });
  }
}