(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
    typeof define === 'function' && define.amd ? define(['tslib'], factory) :
    (global = global || self, global['seabed-game'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

    var LabelType;
    (function (LabelType) {
        LabelType["boom"] = "boom";
        LabelType["candy"] = "candy";
        LabelType["coin"] = "coin";
        LabelType["gift"] = "gift";
        LabelType["egg"] = "egg";
    })(LabelType || (LabelType = {}));
    var LabelType$1 = LabelType;
    //# sourceMappingURL=LabelType.js.map

    var props = {};
    function prepareProps() {
        var metaProps = getProps();
        engine.injectProp(props, metaProps);
    }
    function injectProps(p) {
        engine.injectProp(props, p);
    }
    //# sourceMappingURL=props.js.map

    var levels;
    var setlevelData = function () {
        levels = {
            '1': { max: props.level_1[0], items: [[LabelType$1.boom, props.level_1[1]], [LabelType$1.coin, props.level_1[2]]], time: props.level_1[3] },
            '2': { max: props.level_2[0], items: [[LabelType$1.boom, props.level_2[1]], [LabelType$1.coin, props.level_2[2]]], time: props.level_2[3] },
            '3': { max: props.level_3[0], items: [[LabelType$1.boom, props.level_3[1]], [LabelType$1.coin, props.level_3[2]]], time: props.level_3[3] },
        };
    };
    var touchEnabled = false;
    var getTouchEnabled = function () {
        return touchEnabled;
    };
    var setTouchEnabled = function (b) {
        touchEnabled = b;
    };
    //# sourceMappingURL=GoldData.js.map

    function getTexture(uuid) {
        return engine.Texture.from(getAssetByUUID(uuid).uuid);
    }
    function getTextureByName(name) {
        return getTexture(engine.getAssetByName(name).uuid);
    }
    //# sourceMappingURL=utils.js.map

    var Tool = (function () {
        function Tool() {
        }
        Tool.getLabel = function (txt, size, color, bold, align, x, y) {
            if (color === void 0) { color = "#ffffff"; }
            if (bold === void 0) { bold = false; }
            if (align === void 0) { align = engine.TEXT_ALIGN.LEFT; }
            if (x === void 0) { x = 0; }
            if (y === void 0) { y = 0; }
            var label = new engine.Label();
            label.fillColor = color;
            label.bold = bold;
            label.size = size;
            label.textAlign = align;
            label.x = x;
            label.y = y;
            label.text = txt;
            return label;
        };
        return Tool;
    }());
    //# sourceMappingURL=Tools.js.map

    var curScore;
    function getScore() {
        return curScore;
    }
    function addScore(addCount) {
        curScore += addCount;
        return curScore;
    }
    function setScore(scoreCount) {
        curScore = scoreCount;
    }
    var curLevel;
    function getCurLevel() {
        return curLevel;
    }
    function setCurLevel(level) {
        curLevel = level;
        return curLevel;
    }
    var levels$1;
    var setlevelData$1 = function () {
        levels$1 = {
            '1': { max: props.level_1[0], items: [[LabelType$1.boom, props.level_1[1]], [LabelType$1.coin, props.level_1[2]]], time: props.level_1[3] },
            '2': { max: props.level_2[0], items: [[LabelType$1.boom, props.level_2[1]], [LabelType$1.coin, props.level_2[2]]], time: props.level_2[3] },
            '3': { max: props.level_3[0], items: [[LabelType$1.boom, props.level_3[1]], [LabelType$1.coin, props.level_3[2]]], time: props.level_3[3] },
        };
    };
    var getLevelData = function () {
        if (!levels$1) {
            setlevelData$1();
        }
        return levels$1[getCurLevel()];
    };
    var getCurrentItems = function () {
        if (!levels$1) {
            setlevelData$1();
        }
        return getLevelData().items;
    };
    var getlevelTime = function () {
        if (!levels$1) {
            setlevelData$1();
        }
        return getLevelData().time;
    };
    var getlevelMax = function () {
        if (!levels$1) {
            setlevelData$1();
        }
        return getLevelData().max;
    };
    //# sourceMappingURL=goldData.js.map

    var GameData = (function (_super) {
        tslib.__extends(GameData, _super);
        function GameData(parentNode, color) {
            var _this = _super.call(this) || this;
            _this.starList = [];
            _this._parentNode = parentNode;
            _this._color = color;
            _this.init();
            return _this;
        }
        GameData.prototype.init = function () {
            var scoreCount = this._scoreCount = Tool.getLabel('', 36, "#ffffff", true);
            scoreCount.y = 48;
            this.addChild(scoreCount);
            var scorelabel = this._scorelabel = Tool.getLabel('分', 22, "#ffffff");
            scorelabel.y = 56;
            this.addChild(scorelabel);
            var progress = new engine.Sprite(getTextureByName('进度'));
            progress.x = 212;
            progress.y = 8;
            this.addChild(progress);
            var progressMask = this._progressMask = new engine.Rect();
            progressMask.fillColor = 0x000000;
            progressMask.width = 245;
            progressMask.height = 100;
            progressMask.x = 213;
            progressMask.y = 5;
            progressMask.scaleX = 0;
            this.addChild(progressMask);
            progress.mask = progressMask;
            var star1 = new engine.Sprite(getTextureByName('点亮'));
            star1.x = 270;
            star1.y = 6;
            star1.visible = false;
            this.addChild(star1);
            this.starList.push(star1);
            var star2 = new engine.Sprite(getTextureByName('点亮'));
            star2.x = 365;
            star2.y = 6;
            star2.visible = false;
            this.addChild(star2);
            this.starList.push(star2);
            var star3 = new engine.Sprite(getTextureByName('点亮'));
            star3.x = 435;
            star3.y = 50;
            star3.visible = false;
            this.addChild(star3);
            this.starList.push(star3);
            this.scorePosUpdate();
            var levelLabel = this._levelLabel = Tool.getLabel('', 28, this._color || "#28c1ec", false);
            levelLabel.y = 98;
            this.addChild(levelLabel);
            this.levelUpdate();
            this.updateProgressMask();
        };
        GameData.prototype.scorePosUpdate = function () {
            this._scoreCount.text = getScore();
            this._scoreCount.x = (this._parentNode.width - this._scoreCount.width - this._scorelabel.width - 5) / 2;
            this._scorelabel.x = this._scoreCount.x + this._scoreCount.width + 5;
            this.updateProgressMask();
        };
        GameData.prototype.levelUpdate = function (color) {
            this._levelLabel.text = "\u7B2C" + getCurLevel() + "/3\u5173";
            this._levelLabel.x = (this._parentNode.width - this._levelLabel.width) / 2;
        };
        GameData.prototype.updateProgressMask = function () {
            var ratio = getScore() / getlevelMax();
            this._progressMask.scaleX = ratio;
            if (ratio >= 0.35) {
                this.starList[0].visible = true;
            }
            if (ratio >= 0.75) {
                this.starList[1].visible = true;
            }
            if (ratio >= 1) {
                this.starList[2].visible = true;
            }
        };
        GameData.prototype.resetMask = function () {
            this.starList.forEach(function (element) {
                element.visible = false;
            });
        };
        return GameData;
    }(engine.Container));
    //# sourceMappingURL=gameData.js.map

    var BaseItem = (function (_super) {
        tslib.__extends(BaseItem, _super);
        function BaseItem(mc, type) {
            var _this = _super.call(this) || this;
            _this.type = type;
            _this._mc = mc;
            var bubble = getTextureByName('bubble');
            var bubblePic = new engine.Sprite(bubble);
            bubblePic.anchorTexture.set(0.5, 0.5);
            _this._mc.anchorTexture.set(0.5, 0.5);
            _this._mc.x = bubblePic.x / 4;
            _this._mc.y = bubblePic.y / 4;
            _this.addChild(bubblePic);
            _this.addChild(_this._mc);
            return _this;
        }
        Object.defineProperty(BaseItem.prototype, "mc", {
            get: function () { return this._mc; },
            enumerable: true,
            configurable: true
        });
        return BaseItem;
    }(engine.Sprite));
    //# sourceMappingURL=BaseItem.js.map

    var EgretRender = (function () {
        function EgretRender(root, engine) {
            this._root = root;
            this._engine = engine;
        }
        EgretRender.prototype.addBody = function (body, display, x, y) {
            if (display) {
                body['display'] = display;
                this._root.addChildAt(display, 0);
                display.x = x;
                display.y = y;
            }
            return body;
        };
        EgretRender.prototype.remove = function (body) {
            this.removeBody(body);
            this.removeDisplay(body);
        };
        EgretRender.prototype.removeBody = function (body) {
            Matter.World.remove(this._engine.world, body);
        };
        EgretRender.prototype.removeDisplay = function (body) {
            var display = body['display'];
            if (display && display.parent)
                display.parent.removeChild(display);
        };
        EgretRender.prototype.run = function () {
            var bodies = Matter.Composite.allBodies(this._engine.world);
            for (var i = 0; i < bodies.length; i++) {
                var body = bodies[i];
                var display = body['display'];
                if (!display)
                    continue;
                var x1 = Math.round(display.x);
                var x2 = Math.round(body.position.x);
                var y1 = Math.round(display.y);
                var y2 = Math.round(body.position.y);
                var distanceX = Math.abs(x1 - x2);
                var distanceY = Math.abs(y1 - y2);
                var precision = 1;
                if (distanceX > precision || distanceY > precision) {
                    if (display instanceof BaseItem)
                        display.mc.resume();
                }
                else {
                    if (display instanceof BaseItem)
                        display.mc.pause();
                }
                display.x = body.position.x;
                display.y = body.position.y;
                display.rotation = this.getRotation(body.angle);
            }
        };
        EgretRender.prototype.rectangle = function (x, y, width, height, display, options) {
            var body = this.rectangleToRender(x, y, width, height, display, options);
            this.addBodyToWorld(body);
            return body;
        };
        EgretRender.prototype.circle = function (x, y, radius, display, options) {
            var body = this.circleToRender(x, y, radius, display, options);
            this.addBodyToWorld(body);
            return body;
        };
        EgretRender.prototype.addBodyToWorld = function (body) {
            Matter.World.add(this._engine.world, body);
            return body;
        };
        EgretRender.prototype.rectangleToRender = function (x, y, width, height, display, options) {
            var body = Matter.Bodies.rectangle(x, y, width, height, options);
            this.addBody(body, display, x, y);
            return body;
        };
        EgretRender.prototype.circleToRender = function (x, y, radius, display, options) {
            var body = Matter.Bodies.circle(x, y, radius, options);
            this.addBody(body, display, x, y);
            return body;
        };
        EgretRender.prototype.getRotation = function (angle) {
            return angle / Math.PI / 2 * 360;
        };
        return EgretRender;
    }());
    //# sourceMappingURL=EgretRender.js.map

    var wall = 1;
    var basket = 2;
    var award = 4;
    var bubble = 8;
    var bubbleStandby = 16;
    var bubbleGroup = -1;
    var bubbleStandbyGroup = -2;
    var wallMask = award + bubble + bubbleStandby;
    var basketMask = award + bubble + bubbleStandby;
    var awardMask = wall + basket + bubble;
    var bubbleMask = wall + basket + award;
    var bubbleStandbyMask = wall + basket;
    //# sourceMappingURL=collisionConfig.js.map

    var vibrate = (function (view, count, strength) {
        if (count === void 0) { count = 2; }
        if (strength === void 0) { strength = 10; }
        return new Promise(function (r) {
            var pos = [
                { x: strength, y: 0 },
                { x: 0, y: -strength },
                { x: -strength, y: 0 },
                { x: 0, y: strength },
                { x: 0, y: 0 },
            ];
            var list = [];
            for (var i = 0; i < count; i++) {
                list = list.concat(pos);
            }
            var x0 = view.x;
            var y0 = view.y;
            var counter = list.length;
            var _loop_1 = function (i) {
                var element = list[i];
                setTimeout(function () {
                    view.x = element.x + x0;
                    view.y = element.y + y0;
                    counter--;
                    if (counter == 0) {
                        view.x = x0;
                        view.y = y0;
                        r();
                    }
                }, 1000 / 60 * i);
            };
            for (var i = 0; i < list.length; i++) {
                _loop_1(i);
            }
        });
    });
    //# sourceMappingURL=vibrate.js.map

    var MovieClip = (function (_super) {
        tslib.__extends(MovieClip, _super);
        function MovieClip(_a) {
            var spritesheet = _a.spritesheet, frames = _a.frames, scale = _a.scale, position = _a.position, _b = _a.keys, keys = _b === void 0 ? null : _b, _c = _a.autoplay, autoplay = _c === void 0 ? true : _c, _d = _a.loop, loop = _d === void 0 ? true : _d, anchor = _a.anchor, _e = _a.frameInterval, frameInterval = _e === void 0 ? 1 : _e, _f = _a.callBack, callBack = _f === void 0 ? null : _f;
            var _this = _super.call(this) || this;
            _this.frames = frames;
            _this.frameInterval = frameInterval;
            _this.keys = keys;
            _this.autoplay = autoplay;
            _this.loop = loop;
            _this.anchorXtmp = anchor;
            _this.anchorYtmp = anchor;
            _this._callBack = callBack;
            if (Array.isArray(anchor)) {
                _this.anchorXtmp = anchor[0];
                _this.anchorYtmp = anchor[1];
            }
            _this.x = position[0];
            _this.y = position[1];
            _this.spritesheet = spritesheet;
            if (_this.autoplay) {
                _this.play();
            }
            _this.scaleX = _this.scaleY = scale;
            return _this;
        }
        MovieClip.prototype.pause = function () {
            this.removeEventListener(engine.Event.ENTER_FRAME, this.onTick, this);
        };
        MovieClip.prototype.resume = function () {
            this.addEventListener(engine.Event.ENTER_FRAME, this.onTick, this);
        };
        MovieClip.prototype.play = function (start) {
            if (start === void 0) { start = 0; }
            this.goto(start);
            this.currentFrame = 0;
            this.counter = 0;
            this.addEventListener(engine.Event.ENTER_FRAME, this.onTick, this);
        };
        MovieClip.prototype.goto = function (frame) {
            this.texture = this.textures[frame];
        };
        MovieClip.prototype.onTick = function () {
            this.counter++;
            if (this.counter == this.frameInterval) {
                this.counter = 0;
                this.currentFrame++;
                this.goto(this.currentFrame);
                if (this.currentFrame == this.frames.length - 1) {
                    if (this.loop) {
                        this.currentFrame = 0;
                    }
                    else {
                        this.stop();
                        if (this._callBack) {
                            this._callBack();
                            this._callBack = null;
                        }
                    }
                }
            }
            return false;
        };
        MovieClip.prototype.stop = function () {
            this.currentFrame = 0;
            this.removeEventListener(engine.Event.ENTER_FRAME, this.onTick, this);
        };
        Object.defineProperty(MovieClip.prototype, "spritesheet", {
            set: function (value) {
                this.textures = this.frames.map(function (frame) { return value[frame]; });
                this.anchorTexture.set(this.anchorXtmp, this.anchorYtmp);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(MovieClip.prototype, "textureItemWidth", {
            get: function () { return this.textures[0].width; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(MovieClip.prototype, "textureItemHeight", {
            get: function () { return this.textures[0].height; },
            enumerable: true,
            configurable: true
        });
        return MovieClip;
    }(engine.Image));
    //# sourceMappingURL=MovieClip.js.map

    var wait = function (duration) { return tslib.__awaiter(void 0, void 0, void 0, function () {
        return tslib.__generator(this, function (_a) {
            return [2, new Promise(function (resolve) { return setTimeout(resolve, duration); })];
        });
    }); };
    //# sourceMappingURL=wait.js.map

    var josnData = {};
    function getJsonAsset(name) {
        var config = engine.getAssetByName(name + '_json');
        var tmpJosnData = engine.globalLoader.get(config.uuid);
        if (tmpJosnData) {
            josnData[name] = convert(tmpJosnData);
        }
    }
    function convert(data) {
        var frames = data.frames;
        var jsonName = data.file.split('.')[0];
        var obj = {};
        for (var key in frames) {
            var f = frames[key];
            obj[jsonName + key + ".png"] = {
                "x": f.x,
                "y": f.y,
                "w": f.w,
                "h": f.h,
                "ox": f.offX,
                "oy": f.offY,
                "sw": f.sourceW,
                "sh": f.sourceH,
                "ro": false,
            };
        }
        return obj || null;
    }
    function getJosnData(jsonName) {
        return josnData[jsonName] || null;
    }
    //# sourceMappingURL=JsonTools.js.map

    function createTextureSheet(baseTexture, altaData) {
        var frames = altaData;
        var frameKeys = Object.keys(frames);
        var frameIndex = 0;
        var textures = {};
        while (frameIndex < frameKeys.length) {
            var i = frameKeys[frameIndex];
            var data = frames[i];
            var frame = null;
            var trim = null;
            var orig = new engine.Rectangle(0, 0, Math.floor(data.sw), Math.floor(data.sh));
            if (data.ro) {
                frame = new engine.Rectangle(Math.floor(data.x), Math.floor(data.y), Math.floor(data.h), Math.floor(data.w));
            }
            else {
                frame = new engine.Rectangle(Math.floor(data.x), Math.floor(data.y), Math.floor(data.w), Math.floor(data.h));
            }
            if (data.ox || data.oy) {
                trim = new engine.Rectangle(Math.floor(data.ox), Math.floor(data.oy), Math.floor(data.w), Math.floor(data.h));
            }
            var texture = new engine.Texture(baseTexture, frame, orig, trim, data.ro ? 2 : 0);
            engine.Texture.addToCache(texture, i);
            textures[i] = texture;
            frameIndex++;
        }
        return textures;
    }
    //# sourceMappingURL=createTextureSheet.js.map

    function playMovieClip(parent, key, frames, frameInterval) {
        if (frameInterval === void 0) { frameInterval = 5; }
        return tslib.__awaiter(this, void 0, void 0, function () {
            var _this = this;
            return tslib.__generator(this, function (_a) {
                return [2, new Promise(function (r) { return tslib.__awaiter(_this, void 0, void 0, function () {
                        var josnData, texture;
                        var _this = this;
                        return tslib.__generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    josnData = getJosnData(key);
                                    if (!josnData) {
                                        getJsonAsset(key);
                                        josnData = getJosnData(key);
                                    }
                                    texture = createTextureSheet(getTextureByName(key).baseTexture, josnData);
                                    if (!texture) return [3, 2];
                                    return [4, createMc(parent, texture, frames, frameInterval)];
                                case 1:
                                    _a.sent();
                                    r(1);
                                    return [3, 3];
                                case 2:
                                    wait(300).then(function () { return tslib.__awaiter(_this, void 0, void 0, function () {
                                        var josnData;
                                        return tslib.__generator(this, function (_a) {
                                            switch (_a.label) {
                                                case 0:
                                                    josnData = getJosnData(key);
                                                    if (!josnData) {
                                                        getJsonAsset(key);
                                                        josnData = getJosnData(key);
                                                    }
                                                    texture = createTextureSheet(getTextureByName(key).baseTexture, josnData);
                                                    if (!texture) return [3, 2];
                                                    return [4, createMc(parent, texture, frames, frameInterval)];
                                                case 1:
                                                    _a.sent();
                                                    r(1);
                                                    return [3, 3];
                                                case 2:
                                                    r(0);
                                                    _a.label = 3;
                                                case 3: return [2];
                                            }
                                        });
                                    }); });
                                    _a.label = 3;
                                case 3: return [2];
                            }
                        });
                    }); })];
            });
        });
    }
    function createMc(parent, spritesheet, frames, frameInterval) {
        if (frameInterval === void 0) { frameInterval = 5; }
        return new Promise(function (r) {
            var movieclip = new MovieClip({
                spritesheet: spritesheet,
                frameInterval: frameInterval,
                frames: frames,
                position: [0, 150],
                scale: 1,
                anchor: [0, 0],
                loop: false,
                callBack: function () {
                    setTimeout(function () {
                        parent.removeChild(movieclip);
                        r(1);
                    }, 100);
                }
            });
            parent.addChild(movieclip);
        });
    }
    var playBoom = function (parent) {
        return playMovieClip(parent, 'fail', ['fail1.png', 'fail2.png', 'fail3.png', 'fail4.png', 'fail5.png', 'fail6.png', 'fail7.png', 'fail8.png'], 5);
    };
    var playSuccess = function (parent) {
        return playMovieClip(parent, 'success', ['success1.png', 'success2.png', 'success3.png', 'success4.png', 'success5.png', 'success6.png', 'success7.png', 'success8.png', 'success9.png'], 5);
    };
    //# sourceMappingURL=playMovieClip.js.map

    var createCoin = function (scale) {
        var josnData = getJosnData('coin');
        if (!josnData) {
            getJsonAsset('coin');
            josnData = getJosnData('coin');
        }
        var texture = createTextureSheet(getTextureByName('coin').baseTexture, josnData);
        var animation = createMovieClip(texture, 0.6);
        var baseItem = new BaseItem(animation, LabelType$1.coin);
        baseItem.scaleX = baseItem.scaleY = scale;
        return baseItem;
    };
    var createMovieClip = function (spritesheet, scale) {
        if (scale === void 0) { scale = 1; }
        var list = ['coin1.png', 'coin2.png', 'coin3.png', 'coin4.png', 'coin5.png', 'coin6.png', 'coin7.png', 'coin8.png'];
        var movieclip = new MovieClip({
            spritesheet: spritesheet,
            frameInterval: 6,
            frames: list,
            position: [0, 0],
            scale: scale,
            anchor: [.5, .5]
        });
        return movieclip;
    };
    //# sourceMappingURL=createCoin.js.map

    var createBoom = function (scale) {
        var josnData = getJosnData('boom');
        if (!josnData) {
            getJsonAsset('boom');
            josnData = getJosnData('boom');
        }
        var boomTexture = createTextureSheet(getTextureByName('boom').baseTexture, josnData);
        var animation = createMovieClip$1(boomTexture);
        var baseItem = new BaseItem(animation, LabelType$1.boom);
        baseItem.scaleX = baseItem.scaleY = scale;
        return baseItem;
    };
    var createMovieClip$1 = function (spritesheet, scale) {
        if (scale === void 0) { scale = 1; }
        var list = ['boom1.png', 'boom2.png', 'boom3.png', 'boom4.png', 'boom5.png', 'boom6.png', 'boom7.png', 'boom8.png', 'boom9.png', 'boom10.png'];
        var movieclip = new MovieClip({
            spritesheet: spritesheet,
            frameInterval: 5,
            frames: list,
            position: [0, 0],
            scale: scale,
            anchor: [.5, .5]
        });
        return movieclip;
    };
    //# sourceMappingURL=createBoom.js.map

    var createGift = function (scale) {
        var josnData = getJosnData('gift');
        if (!josnData) {
            getJsonAsset('gift');
            josnData = getJosnData('gift');
        }
        var texture = createTextureSheet(getTextureByName('gift').baseTexture, josnData);
        var animation = createMovieClip$2(texture, 0.6);
        var baseItem = new BaseItem(animation, LabelType$1.gift);
        baseItem.scaleX = baseItem.scaleY = scale;
        return baseItem;
    };
    var createMovieClip$2 = function (spritesheet, scale) {
        if (scale === void 0) { scale = 1; }
        var list = ['gift1.png', 'gift2.png', 'gift3.png', 'gift4.png', 'gift5.png', 'gift6.png', 'gift7.png', 'gift8.png', 'gift9.png', 'gift10.png'];
        var movieclip = new MovieClip({
            spritesheet: spritesheet,
            frameInterval: 5,
            frames: list,
            position: [0, 0],
            scale: scale,
            anchor: [.5, .5]
        });
        return movieclip;
    };
    //# sourceMappingURL=createGift.js.map

    var createCandy = function (scale) {
        var josnData = getJosnData('candy');
        if (!josnData) {
            getJsonAsset('candy');
            josnData = getJosnData('candy');
        }
        var boomTexture = createTextureSheet(getTextureByName('candy').baseTexture, josnData);
        var animation = createMovieClip$3(boomTexture);
        var baseItem = new BaseItem(animation, LabelType$1.candy);
        baseItem.scaleX = baseItem.scaleY = scale;
        return baseItem;
    };
    var createMovieClip$3 = function (spritesheet, scale) {
        if (scale === void 0) { scale = 1; }
        var list = ['candy1.png', 'candy2.png', 'candy3.png', 'candy4.png', 'candy5.png', 'candy6.png', 'candy7.png', 'candy8.png'];
        var movieclip = new MovieClip({
            spritesheet: spritesheet,
            frameInterval: 6,
            frames: list,
            position: [0, 0],
            scale: scale,
            anchor: [.5, .5]
        });
        return movieclip;
    };
    //# sourceMappingURL=createCandy.js.map

    var createEgg = function (scale) {
        var josnData = getJosnData('egg');
        if (!josnData) {
            getJsonAsset('gift');
            josnData = getJosnData('egg');
        }
        var texture = createTextureSheet(getTextureByName('egg').baseTexture, josnData);
        var animation = createMovieClip$4(texture, 0.6);
        var baseItem = new BaseItem(animation, LabelType$1.egg);
        baseItem.scaleX = baseItem.scaleY = scale;
        return baseItem;
    };
    var createMovieClip$4 = function (spritesheet, scale) {
        if (scale === void 0) { scale = 1; }
        var list = ['egg1.png', 'egg2.png', 'egg3.png', 'egg4.png', 'egg5.png', 'egg6.png', 'egg7.png', 'egg8.png', 'egg9.png'];
        var movieclip = new MovieClip({
            spritesheet: spritesheet,
            frameInterval: 5,
            frames: list,
            position: [0, 0],
            scale: scale,
            anchor: [.5, .5]
        });
        return movieclip;
    };
    //# sourceMappingURL=createEgg.js.map

    var createItem = function (scale, type) {
        var funcs = {
            'boom': createBoom,
            'gift': createGift,
            'candy': createCandy,
            'egg': createEgg,
            'coin': createCoin
        };
        var func = funcs[type];
        return func(scale);
    };
    //# sourceMappingURL=createItem.js.map

    var createBubble = function (_this, type, x, y, force, density) {
        if (force === void 0) { force = { x: 0, y: 0 }; }
        if (density === void 0) { density = 0.001; }
        var scale;
        var size = random(85, 100);
        var maxsize = 100;
        scale = size / maxsize;
        var baseItem = createItem(scale, type);
        var angle;
        angle = 0;
        _this._egretRender.circle(x, y, (size - 17) / 2, baseItem, {
            frictionAir: 0,
            collisionFilter: { group: award, category: award, mask: awardMask },
            angle: angle,
            label: baseItem.type,
            friction: 0,
            force: force,
            density: density
        });
    };
    var random = function (start, end) {
        var n = end - start;
        return Math.random() * n + start;
    };
    var createItems = (function (_this) {
        var score = getScore();
        var items = getCurrentItems();
        var list = [];
        for (var _i = 0, items_1 = items; _i < items_1.length; _i++) {
            var item = items_1[_i];
            var type = item[0];
            var nums = item[1];
            if (type == LabelType$1.coin)
                nums = nums - score;
            for (var i = 0; i < nums; i++) {
                list.push(type);
            }
        }
        var count = 0;
        var coinsFall = setInterval(function () {
            if (count <= list.length - 1) {
                var type = list[count];
                createBubble(_this, type, 375 + Math.random() * 200 - 100, 400 + 200 + 200);
                count++;
            }
        }, 100);
    });
    //# sourceMappingURL=createItems.js.map

    var clear = function (that) {
        TextList.forEach(function (i) {
            engine.Tween.removeTweens(that.gameHint[i]);
            that.gameHint[i].alpha = 0;
        });
    };
    var playgreat = function (image) {
        engine.Tween.get(image).set({ x: 750, alpha: 1, scaleX: .9, scaleY: .9, rotation: 20 }).to({ x: 540.5, scaleX: 1, scaleY: 1, rotation: 0 }, 200, engine.Ease.getBackOut(2)).wait(500).to({ alpha: 0 }, 200);
    };
    var playcool = function (image) {
        engine.Tween.get(image).set({ x: 750, alpha: 1, scaleX: .9, scaleY: .9, rotation: 60 }).to({ x: 526.09, scaleX: 1, scaleY: 1, rotation: 0 }, 200, engine.Ease.getBackOut(7)).wait(500).to({ alpha: 0 }, 200);
    };
    var playperfect = function (image) {
        engine.Tween.get(image).set({ scaleX: 0, scaleY: 0, alpha: 1, }).to({ scaleX: 1, scaleY: 1 }, 200, engine.Ease.getBackOut(10)).wait(500).to({ alpha: 0 }, 200);
    };
    var playawesome = function (image) {
        engine.Tween.get(image).set({ scaleX: 0, scaleY: 0, alpha: 1, rotation: -20 }).to({ scaleX: 1, scaleY: 1, rotation: 0 }, 200, engine.Ease.getBackOut(20)).wait(500).to({ alpha: 0 }, 200);
    };
    var playunbelievable = function (image) {
        engine.Tween.get(image).set({ scaleX: 0, scaleY: 0, alpha: 1, rotation: -60 }).to({ scaleX: 1, scaleY: 1, rotation: 0 }, 200, engine.Ease.getBackOut(40)).wait(500).to({ alpha: 0 }, 200);
    };
    var funcs = [playgreat, playcool, playperfect, playawesome, playunbelievable];
    var cdtimer;
    var count = 0;
    var playTextAni = function (that) { return tslib.__awaiter(void 0, void 0, void 0, function () {
        var image;
        return tslib.__generator(this, function (_a) {
            clear(that);
            count++;
            if (count >= TextList.length)
                count = TextList.length;
            console.log(count);
            image = that.gameHint[TextList[count - 1]];
            image.visible = true;
            funcs[count - 1](image);
            if (cdtimer > 0)
                clearTimeout(cdtimer);
            cdtimer = setTimeout(function () {
                count = 0;
                console.log('clear');
            }, 5000);
            return [2];
        });
    }); };
    var TextList = ['great', 'cool', 'perfect', 'awesome', 'unbelievable'];
    //# sourceMappingURL=playTextAni.js.map

    function check(_this) {
        var egretRenderContainer = _this.egretRenderContainer;
        var center = 375;
        var paddingX = 50;
        var ypos = 570;
        var h = 40;
        var bodies = Matter.Composite.allBodies(_this._engine.world);
        var isAward = function (i) { return i.collisionFilter.group == award; };
        bodies.forEach(function (i) {
            if (!isAward(i))
                return;
            if (i['timer']) {
                var t0 = Date.now() - i['timer'];
                if (t0 > 3000) {
                    delete i['timer'];
                }
            }
            var _a = i.position, x = _a.x, y = _a.y;
            var xResult = x > (center - paddingX) && x < (center + paddingX);
            var yResult = y > ypos && y < (ypos + h);
            if (xResult && yResult && i.velocity.y > 0 && !i['timer']) {
                i['timer'] = Date.now();
                if (i.label == LabelType$1.boom) {
                    _this._egretRender.remove(i);
                    vibrate(_this, 2);
                    playBoom(egretRenderContainer);
                    _this.onBoom();
                }
                else if (i.label == LabelType$1.egg) {
                    _this._egretRender.remove(i);
                }
                else if (i.label == LabelType$1.candy) {
                    _this._egretRender.remove(i);
                }
                else if (i.label == LabelType$1.gift) {
                    _this._egretRender.remove(i);
                }
                else {
                    playSuccess(_this.egretRenderContainer);
                    _this._egretRender.remove(i);
                    _this.addScore();
                    playTextAni(_this);
                }
            }
        });
    }
    //# sourceMappingURL=check.js.map

    var createBox = function (_this) {
        var path1 = Matter.Vertices.fromPath('385 370 630 380 670 728 620 1080 370 1100 109 1090 57 728 108 370 0 370 0 1624 750 1624 750 0', null);
        var body = Matter.Bodies.fromVertices(400, 880, [path1], { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } }, true);
        Matter.World.add(_this._engine.world, body);
        var path2 = Matter.Vertices.fromPath('108 370 385 370 385 300', null);
        var body2 = Matter.Bodies.fromVertices(296, 365, [path2], { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } }, true);
        Matter.World.add(_this._engine.world, body2);
        var basketpath1 = Matter.Vertices.fromPath('290 560 324 600 326 600 313 565', null);
        var basketbody1 = Matter.Bodies.fromVertices(305, 575, [basketpath1], { isStatic: true, friction: 0, collisionFilter: { group: basket, category: basket, mask: basketMask } }, true);
        Matter.World.add(_this._engine.world, basketbody1);
        var basketpath2 = Matter.Vertices.fromPath('465 563 443 605 441 605 456 560', null);
        var basketbody2 = Matter.Bodies.fromVertices(453, 570, [basketpath2], { isStatic: true, friction: 0, collisionFilter: { group: basket, category: basket, mask: basketMask } }, true);
        Matter.World.add(_this._engine.world, basketbody2);
        var basketLeft = Matter.Bodies.circle(285, 560, 12, { isStatic: true, friction: 0, collisionFilter: { group: basket, category: basket, mask: basketMask } });
        Matter.World.add(_this._engine.world, basketLeft);
        var basketRight = Matter.Bodies.circle(461, 560, 12, { isStatic: true, friction: 0, collisionFilter: { group: basket, category: basket, mask: basketMask } });
        Matter.World.add(_this._engine.world, basketRight);
        var w = 100;
        var h = 50;
        var rect = _this._egretRender.rectangle(180, 1080, w, h, null, { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } });
        var rect2 = _this._egretRender.rectangle(560, 1080, w, h, null, { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } });
        var w2 = 300;
        var h2 = 10;
        var rect3 = _this._egretRender.rectangle(375, 1100, w2, h2, null, { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } });
    };
    //# sourceMappingURL=createBox.js.map

    var createBubblePic = function (r) {
        var bubbleTexture = getTextureByName('bubble');
        var bubblePic = new engine.Sprite(bubbleTexture);
        bubblePic.scaleX = bubblePic.scaleY = r * 2 / 100;
        return bubblePic;
    };
    //# sourceMappingURL=createBubblePic.js.map

    var timerLeft;
    var timerRight;
    var startStandbyBubblesLeft = function (egretRender) {
        timerLeft = setInterval(function () {
            var scale = 0.2;
            var p1 = { x: 180, y: 1050 };
            var r = random$1(8, 10);
            var bubblePic = createBubblePic(r);
            var body = egretRender.circle(p1.x, p1.y, r, bubblePic, {
                restitution: 0,
                frictionAir: 0,
                force: { x: random$1(-0.005, 0.005) * scale, y: -0.02 * scale },
                collisionFilter: { group: bubbleStandbyGroup, category: bubbleStandby, mask: bubbleStandbyMask }
            });
            setTimeout(function () {
                egretRender.remove(body);
            }, 1000);
        }, 700);
    };
    var startStandbyBubblesRight = function (egretRender) {
        timerRight = setInterval(function () {
            var scale = 0.2;
            var p2 = { x: 560, y: 1050 };
            var r2 = random$1(8, 10);
            var bubblePic2 = createBubblePic(r2);
            var body2 = egretRender.circle(p2.x, p2.y, r2, bubblePic2, {
                restitution: 0,
                frictionAir: 0,
                force: { x: random$1(-0.005, 0.005) * scale, y: -0.02 * scale },
                collisionFilter: { group: bubbleStandbyGroup, category: bubbleStandby, mask: bubbleStandbyMask }
            });
            setTimeout(function () {
                egretRender.remove(body2);
            }, 1000);
        }, 700);
    };
    var stopStandbyBubblesLeft = function () {
        clearInterval(timerLeft);
    };
    var stopStandbyBubblesRight = function () {
        clearInterval(timerRight);
    };
    var random$1 = function (start, end) {
        var n = end - start;
        return Math.random() * n + start;
    };
    //# sourceMappingURL=standbyBubbles.js.map

    var createBtns = (function (that) {
        var createShape = function () {
            var shape = new engine.Shape();
            shape.beginFill(0, .6);
            shape.drawCircle(0, 0, that._leftBtn.width / 2);
            shape.endFill();
            return shape;
        };
        [that._leftBtn, that._rightBtn].forEach(function (btn) {
            btn.addEventListener(engine.MouseEvent.MOUSE_DOWN, function (e) {
                var btn = e.target;
                engine.Tween.removeTweens(btn);
                engine.Tween.get(btn)
                    .to({ scaleY: 0.9 }, 200);
            }, that);
        });
        [that._leftBtn, that._rightBtn].forEach(function (btn) {
            btn.addEventListener(engine.MouseEvent.MOUSE_UP, function (e) {
                var btn = e.target;
                engine.Tween.removeTweens(btn);
                engine.Tween.get(btn)
                    .to({ scaleX: 1, scaleY: 1 }, 200);
            }, that);
        });
        [that._leftBtn, that._rightBtn].forEach(function (btn) {
            btn.addEventListener(engine.MouseEvent.MOUSE_OUT, function (e) {
                var btn = e.target;
                engine.Tween.removeTweens(btn);
                engine.Tween.get(btn)
                    .to({ scaleX: 1, scaleY: 1 }, 200);
            }, that);
        });
        var shapeLeft = createShape();
        shapeLeft.x = that._leftBtn.width / 2;
        shapeLeft.y = that._leftBtn.height / 2;
        that._leftBtn.addChild(shapeLeft);
        var shapeR = createShape();
        shapeR.x = that._rightBtn.width / 2;
        shapeR.y = that._rightBtn.height / 2;
        that._rightBtn.addChild(shapeR);
        shapeLeft.alpha = shapeR.alpha = 0;
    });
    //# sourceMappingURL=createBtns.js.map

    var GameView = (function (_super) {
        tslib.__extends(GameView, _super);
        function GameView() {
            var _this = _super.call(this) || this;
            _this.gameHint = {};
            _this.addForce = false;
            _this.stageX = 0;
            _this.stageY = 0;
            _this._frameCount = 0;
            return _this;
        }
        GameView.prototype.start = function (color) {
            return tslib.__awaiter(this, void 0, void 0, function () {
                var a, gameNode, contPng, leftBtn, rightBtn, light, basket_bottom, tmpRect, basket_top, glass, gameData, countDown, countDownLabel;
                return tslib.__generator(this, function (_a) {
                    a = new engine.Shape();
                    this.addChild(a);
                    engine.globalLoader.loadImage('//yun.duiba.com.cn/aurora/assets/66ab48ff49a741f0c93335d4eb0c9e50b7ab6e1e.png', 'bg_dot')
                        .then(function (img) {
                        a.beginBitmapFill(img, null);
                        a.drawRect(0, 0, 750, 1624);
                        a.endFill();
                    });
                    gameNode = this._gameNode = new engine.Sprite(getTextureByName('机子'));
                    gameNode.y = 260;
                    this.addChild(gameNode);
                    contPng = new engine.Image(getTextureByName('contPng'));
                    contPng.x = (750 - contPng.width) / 2;
                    contPng.y = 215;
                    this.addChild(contPng);
                    leftBtn = this._leftBtn = new engine.Sprite(getTextureByName('左按钮'));
                    leftBtn.anchorY = leftBtn.height - 50;
                    leftBtn.x = 83;
                    leftBtn.y = 920;
                    gameNode.addChild(leftBtn);
                    rightBtn = this._rightBtn = new engine.Sprite(getTextureByName('右按钮'));
                    rightBtn.anchorY = rightBtn.height - 50;
                    rightBtn.x = 400;
                    rightBtn.y = 920;
                    gameNode.addChild(rightBtn);
                    light = this._light = new engine.Sprite(getTextureByName('灯'));
                    light.x = 12;
                    light.y = 44;
                    gameNode.addChild(light);
                    basket_bottom = this._basket_bottom = new engine.Sprite(getTextureByName('basket_bottom'));
                    basket_bottom.x = (contPng.width - basket_bottom.width) / 2;
                    basket_bottom.y = 85;
                    contPng.addChild(basket_bottom);
                    tmpRect = new engine.Rect();
                    tmpRect.x = 230;
                    tmpRect.y = 372;
                    tmpRect.width = 300;
                    tmpRect.height = 300;
                    this.addChild(tmpRect);
                    basket_bottom.mask = tmpRect;
                    basket_top = this._basket_top = new engine.Sprite(getTextureByName('basket_top'));
                    basket_top.x = 287;
                    basket_top.y = 485;
                    this.addChild(basket_top);
                    glass = this._basket_top = new engine.Sprite(getTextureByName('玻璃'));
                    glass.x = (750 - glass.width) / 2;
                    glass.y = 340;
                    this.addChild(glass);
                    gameData = this._gameData = new GameData(contPng, color);
                    contPng.addChild(gameData);
                    countDown = this._countDown = new engine.Sprite(getTextureByName('倒计时'));
                    countDown.x = 5;
                    countDown.y = 180;
                    this.addChild(countDown);
                    this._curLevelTime = getlevelTime();
                    countDownLabel = this._countDownLabel = Tool.getLabel(this._curLevelTime, 48, "#ffffff");
                    countDownLabel.x = (countDown.width - countDownLabel.width) / 2;
                    countDownLabel.y = (countDown.height - countDownLabel.height) / 2 - 5;
                    countDown.addChild(countDownLabel);
                    this.initGameHint();
                    this.startHandle();
                    this.levelHint();
                    return [2];
                });
            });
        };
        GameView.prototype.levelHint = function () {
            var lvBg = this._lvbg = new engine.Rect();
            lvBg.fillColor = 0x000000;
            lvBg.alpha = 0.7;
            lvBg.width = 750;
            lvBg.height = 1624;
            lvBg.x = lvBg.y = 0;
            lvBg.visible = false;
            this.addChild(lvBg);
            var lv_common = this._lv_common = new engine.Sprite(getTextureByName('lv_common'));
            lv_common.x = (750 - lv_common.width) / 2;
            lv_common.y = 500;
            lv_common.visible = false;
            this.addChild(lv_common);
            var lv1 = this._lv = new engine.Sprite(getTextureByName('lv1'));
            lv1.anchorTexture.set(0.5, 0.5);
            lv1.x = lv_common.width / 2;
            lv1.y = 80;
            lv_common.addChild(lv1);
            var lv1_label = this._lv_label = Tool.getLabel("5", 38, "#28c1ec", true, engine.TEXT_ALIGN.CENTER);
            lv1_label.width = 100;
            lv1_label.x = 205;
            lv1_label.y = 205;
            lv1_label.fillColor = 0xffffff;
            lv_common.addChild(lv1_label);
        };
        GameView.prototype.initGameHint = function () {
            var awesome = new engine.Sprite(getTextureByName('awesome'));
            awesome.anchorTexture.set(0.5, 0.5);
            awesome.x = 520;
            awesome.y = 490;
            awesome.alpha = 0;
            this.addChild(awesome);
            this.gameHint['awesome'] = awesome;
            var cool = new engine.Sprite(getTextureByName('cool'));
            cool.anchorTexture.set(0.5, 0.5);
            cool.x = 520;
            cool.y = 490;
            cool.alpha = 0;
            this.addChild(cool);
            this.gameHint['cool'] = cool;
            var good = new engine.Sprite(getTextureByName('good'));
            good.anchorTexture.set(0.5, 0.5);
            good.x = 520;
            good.y = 490;
            good.alpha = 0;
            this.addChild(good);
            this.gameHint['good'] = good;
            var great = new engine.Sprite(getTextureByName('great'));
            great.anchorTexture.set(0.5, 0.5);
            great.x = 520;
            great.y = 490;
            great.alpha = 0;
            this.addChild(great);
            this.gameHint['great'] = great;
            var perfect = new engine.Sprite(getTextureByName('perfect'));
            perfect.anchorTexture.set(0.5, 0.5);
            perfect.x = 530;
            perfect.y = 490;
            perfect.alpha = 0;
            this.addChild(perfect);
            this.gameHint['perfect'] = perfect;
            var unbelievable = new engine.Sprite(getTextureByName('unbelievable'));
            unbelievable.anchorTexture.set(0.5, 0.5);
            unbelievable.x = 480;
            unbelievable.y = 460;
            unbelievable.alpha = 0;
            this.addChild(unbelievable);
            this.gameHint['unbelievable'] = unbelievable;
        };
        GameView.prototype.startNextLevel = function () {
            this.clearAwardBody();
            this.playLevelAni();
            setTouchEnabled(true);
            createItems(this);
            this._gameData.scorePosUpdate();
            this._gameData.resetMask();
            this._gameData.levelUpdate();
            this._curLevelTime = getlevelTime();
            this._countDownLabel.text = this._curLevelTime;
            this._countDownLabel.x = (this._countDown.width - this._countDownLabel.width) / 2;
            this.runEngine();
        };
        GameView.prototype.themeChange = function (data) {
            this._countDown.texture = engine.Texture.fromImage(data.gameCountdownImage);
            this._leftBtn.texture = engine.Texture.fromImage(data.leftButtonImage);
            this._leftBtn.anchorY = this._leftBtn.height - 50;
            this._leftBtn.x = 83;
            this._leftBtn.y = 920;
            this._rightBtn.texture = engine.Texture.fromImage(data.rightButtonImage);
            this._rightBtn.anchorY = this._rightBtn.height - 50;
            this._rightBtn.x = 400;
            this._rightBtn.y = 920;
        };
        GameView.prototype.revive = function () {
            setTouchEnabled(true);
            this.runEngine();
        };
        GameView.prototype.startHandle = function () {
            var engineMatter = Matter.Engine.create();
            this._engine = engineMatter;
            this._engine.world.gravity.y = 0.2;
            this.egretRenderContainer = new engine.Sprite();
            this.addChild(this.egretRenderContainer);
            this._egretRender = new EgretRender(this.egretRenderContainer, this._engine);
            var options = {
                width: 750,
                height: 1624,
                wireframes: !1,
            };
            var render = Matter.Render.create({
                element: document.getElementById('debugCanvas'),
                engine: engineMatter,
                options: options
            });
            Matter.Render.run(render);
            this.runGame();
        };
        GameView.prototype.runGame = function () {
            var _this = this;
            createBox(this);
            Matter.Events.on(this._engine, 'beforeUpdate', function () {
                if (!_this.addForce)
                    return;
                _this.addForce = false;
                var isleft = _this.stageX < 375;
                var start = isleft ? { x: 180, y: 1050 } : { x: 560, y: 1050 };
                var scale = 2.2;
                for (var i = 0; i < 15; i++) {
                    setTimeout(function () {
                        var r = _this.random(10, 14);
                        var bubblePic;
                        bubblePic = createBubblePic(r);
                        var basex = 0.02;
                        var xoffset = 0.007;
                        var fx = isleft ? _this.random(-basex, basex) : _this.random(-basex, basex);
                        var padding = 50;
                        var startx = _this.random(start.x - padding, start.x + padding);
                        if (fx < -xoffset || fx > xoffset)
                            bubblePic = null;
                        var body = _this._egretRender.circle(startx, start.y, r, bubblePic, {
                            density: 0.001 * 3,
                            restitution: 1,
                            force: { x: fx * scale, y: -0.02 * scale },
                            collisionFilter: { group: bubbleGroup, category: bubble, mask: bubbleMask }
                        });
                        setTimeout(function () {
                            _this._egretRender.remove(body);
                        }, 1000);
                    }, Math.random() * 200);
                }
                var _loop_1 = function (j) {
                    var start_1 = isleft ? { x: 180 + 50, y: 1050 + 30 } : { x: 560 - 50, y: 1050 + 30 };
                    var r = _this.random(10, 14);
                    var body = _this._egretRender.circle(start_1.x, start_1.y, r, null, {
                        density: 0.001 * 3,
                        restitution: 1,
                        force: { x: (isleft ? 1 : -1) * 0.02 * 1.7, y: 0 },
                        collisionFilter: { group: bubbleGroup, category: bubble, mask: bubbleMask }
                    });
                    setTimeout(function () {
                        _this._egretRender.remove(body);
                    }, 1000);
                };
                for (var j = 0; j < 1; j++) {
                    _loop_1();
                }
            });
            this._leftBtn.addEventListener(engine.MouseEvent.CLICK, function (e) {
                if (!getTouchEnabled())
                    return;
                _this.addForce = true;
                _this.stageX = e.stageX;
                stopStandbyBubblesLeft();
                clearTimeout(_this._startStandbyBubblesLeft);
                _this._startStandbyBubblesLeft = setTimeout(function () {
                    startStandbyBubblesLeft(_this._egretRender);
                }, 1000);
            }, this);
            this._rightBtn.addEventListener(engine.MouseEvent.CLICK, function (e) {
                if (!getTouchEnabled())
                    return;
                _this.addForce = true;
                _this.stageX = e.stageX;
                stopStandbyBubblesRight();
                clearTimeout(_this._startStandbyBubblesRight);
                _this._startStandbyBubblesRight = setTimeout(function () {
                    startStandbyBubblesRight(_this._egretRender);
                }, 1000);
            }, this);
            createBtns(this);
            startStandbyBubblesLeft(this._egretRender);
            startStandbyBubblesRight(this._egretRender);
        };
        GameView.prototype.enterFrame = function () {
            var now = Date.now();
            var deltaTime = this.lastTime ? now - this.lastTime : 16.7;
            this.lastTime = now;
            this._frameCount += deltaTime;
            if (this._frameCount >= 1000) {
                this._frameCount = 0;
                this.updateCountDown();
            }
            if (deltaTime > 20)
                deltaTime = 20;
            Matter.Engine.update(this._engine, deltaTime);
            this._egretRender.run();
            check(this);
            return false;
        };
        GameView.prototype.random = function (start, end) {
            var n = end - start;
            return Math.random() * n + start;
        };
        GameView.prototype.runEngine = function () {
            engine.gameStage.addEventListener(engine.Event.ENTER_FRAME, this.enterFrame, this);
        };
        GameView.prototype.updateCountDown = function () {
            this._curLevelTime--;
            this._countDownLabel.text = this._curLevelTime;
            this._countDownLabel.x = (this._countDown.width - this._countDownLabel.width) / 2;
            if (this._curLevelTime <= 0) {
                this.end();
                console.log('时间结束');
            }
        };
        GameView.prototype.onBoom = function () {
            this.end();
        };
        GameView.prototype.addScore = function () {
            addScore(1);
            if (getScore() >= getlevelMax()) {
                setTouchEnabled(false);
                engine.gameStage.removeEventListener(engine.Event.ENTER_FRAME, this.enterFrame, this);
                engine.globalEvent.dispatchEvent('seabed-game-success', { level: getCurLevel(), score: getScore() });
            }
            this._gameData.scorePosUpdate();
        };
        GameView.prototype.playLevelAni = function () {
            var _this = this;
            var lv = getCurLevel();
            this._lv.texture = getTextureByName("lv" + lv);
            this._lv_label.text = getlevelMax() + '';
            this._lvbg.visible = true;
            this._lv_common.visible = true;
            engine.Tween.get(this._lv_common).set({ y: 500 - 1624 }).to({ y: 500 }, 700, engine.Ease.backOut)
                .wait(1000).to({ y: 1624 + 500 }, 500, engine.Ease.backIn)
                .call(function () {
                _this._lvbg.visible = false;
            });
        };
        GameView.prototype.clearAwardBody = function () {
            var _this = this;
            var bodies = Matter.Composite.allBodies(this._engine.world);
            var isAward = function (i) { return i.collisionFilter.group == award; };
            bodies.forEach(function (i) {
                if (isAward(i))
                    _this._egretRender.remove(i);
            });
        };
        GameView.prototype.end = function () {
            engine.gameStage.removeEventListener(engine.Event.ENTER_FRAME, this.enterFrame, this);
            engine.globalEvent.dispatchEvent('seabed-game-fail', { level: getCurLevel(), score: getScore(), time: this._curLevelTime });
            setTouchEnabled(false);
        };
        return GameView;
    }(engine.Container));
    //# sourceMappingURL=GameView.js.map

    var GameWrapper = (function (_super) {
        tslib.__extends(GameWrapper, _super);
        function GameWrapper() {
            var _this = _super.call(this) || this;
            engine.globalEvent.addEventListener('seabed-game-start', _this.start, _this);
            engine.globalEvent.addEventListener('seabed-game-revive', _this.revive, _this);
            engine.globalEvent.addEventListener('seabed-game-startNextLevel', _this.startNextLevel, _this);
            engine.globalEvent.addEventListener('seabed-game-themeChange', _this.themeChange, _this);
            var gameView = _this._gameView = new GameView();
            _this.addChild(gameView);
            return _this;
        }
        GameWrapper.prototype.start = function (event) {
            setlevelData();
            this.initData();
            this._gameView.start(event.data.color);
            ['coin', 'boom', 'fail', 'success'].forEach(function (element) {
                getJsonAsset(element);
            });
        };
        GameWrapper.prototype.startNextLevel = function (event) {
            setScore(0);
            setCurLevel(parseInt(event.data.level));
            this._gameView.startNextLevel();
        };
        GameWrapper.prototype.initData = function () {
            setScore(0);
            setCurLevel(1);
        };
        GameWrapper.prototype.revive = function () {
            this._gameView.revive();
        };
        GameWrapper.prototype.themeChange = function (event) {
            this._gameView.themeChange(event.data.resData);
        };
        return GameWrapper;
    }(engine.Container));

    function index (props) {
        prepareProps();
        injectProps(props);
        var instance = new GameWrapper();
        return instance;
    }
    //# sourceMappingURL=index.js.map

    return index;

})));

//# sourceMappingURL=main.js.map