/**
 * Created by renjianfeng on 2020-03-13.
 */

const customId = 'seabed-game';

(async function () {
	let customModule = await fetch(`../meta.json`);
	customModule = await customModule.json();
	console.log(customModule);

	await loadAssets(customModule.assets);
	launchWithCustomModule(customModule);
})();

function launchWithCustomModule(customModule) {
	//engine.registerCustomCodeModule(customModule);
	engine.registerCustomModule(customId, window[customId]);

	const { props: propsOption, assets } = customModule;
	let props = engine.computeProps(customModuleProps, propsOption);
	const customModuleIns = {
		id: customId,
		props,
		assets,
	};

	engine.registerCustomModules([customModuleIns]);
	engine.launchWithConfig({
		options: {
			entrySceneView: 'entry',
		},
		assets: [],
		views: [{
			name: 'entry',
			type: 'node',
			properties: {
				x: 0,
				y: 0,
			}
		}],
		customs: [],
	}, null, function () {
		setTimeout(() => {
			engine.addCustomModule(customId, engine.gameStage.sceneContainer.getChildAt(0));
		}, 100);
		setTimeout(() => {
			engine.globalEvent.dispatchEvent('seabed-game-start',{color:"0x000000"});
		}, 150);

	});
	engine.globalEvent.addEventListener('seabed-game-time-update', (e) => {
		// console.log(e.type, e.data);
	});
	engine.globalEvent.addEventListener('seabed-game-game-fail', (e) => {
		console.log(e.type, e.data);
	});
	engine.globalEvent.addEventListener('seabed-game-game-success', (e) => {
		console.log(e.type, e.data);
	});
}

function getAssetByUUID(uuid) {
	return engine.resolveCustomAsset(customId, uuid);
}

function getProps() {
	return engine.getProps(customId);
}
