(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['rounds-pic'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	var qietu = (function (parent, url, MAX_COL, MAX_ROW) {
	    var W = props.W;
	    var H = props.H;
	    var GAP = props.GAP;
	    var spr = [];
	    var pos = [];
	    var _loop_1 = function (row) {
	        var _loop_2 = function (col) {
	            var child = new engine.Sprite();
	            child.scaleX = 1 / MAX_COL;
	            child.scaleY = 1 / MAX_ROW;
	            parent.addChild(child);
	            child.x = col * (W / MAX_COL + GAP);
	            child.y = row * (H / MAX_ROW + GAP);
	            pos.push([child.x, child.y]);
	            spr.push(child);
	            child.addEventListener(engine.Event.COMPLETE, function () {
	                var uvs = new Float32Array([
	                    col / MAX_COL,
	                    row / MAX_ROW,
	                    (col + 1) / MAX_COL,
	                    row / MAX_ROW,
	                    (col + 1) / MAX_COL,
	                    (row + 1) / MAX_ROW,
	                    col / MAX_COL,
	                    (row + 1) / MAX_ROW,
	                ]);
	                child.uvs = uvs;
	            });
	            child.texture = engine.Texture.fromImage(url);
	        };
	        for (var col = 0; col < MAX_COL; col++) {
	            _loop_2(col);
	        }
	    };
	    for (var row = 0; row < MAX_ROW; row++) {
	        _loop_1(row);
	    }
	    console.log(spr);
	    return [spr, pos];
	});
	//# sourceMappingURL=qietu.js.map

	function getIndexFromRC(row, col, maxCol) {
	    var index;
	    index = row * maxCol + col;
	    return index;
	}
	function getRandomArray(array) {
	    array.sort(function () {
	        return 0.5 - Math.random();
	    });
	}

	var MAX_COL;
	var MAX_ROW;
	var W;
	var H;
	var GAP;
	var GAME_TIME;
	var w;
	var h;
	var picUrl;
	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this._timeCounter = 0;
	        _this._result = [];
	        _this.listenStageOn = 1;
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.start = function () {
	        var _this = this;
	        picUrl = props.picUrl;
	        MAX_COL = props.MAX_COL;
	        MAX_ROW = props.MAX_ROW;
	        GAME_TIME = props.GAME_TIME;
	        W = props.W;
	        H = props.H;
	        GAP = props.GAP;
	        w = W / MAX_COL;
	        h = H / MAX_ROW;
	        console.log('on start');
	        engine.globalEvent.dispatchEvent('pictures-time-update', {
	            second: this.getSecond(),
	        });
	        if (this._result.length !== 0) {
	            this._result = [];
	        }
	        this._result = qietu(this.picturesWrapper, picUrl, MAX_COL, MAX_ROW);
	        this.pictures = this._result[0];
	        if (this.rightList !== null) {
	            this.rightList = [];
	        }
	        this.rightList = this.pictures.concat([]);
	        var posList = this._result[1];
	        getRandomArray(this.pictures);
	        var i = 0;
	        var len;
	        len = this.pictures.length;
	        for (; i < len; i++) {
	            this.dragPic = this.pictures[i];
	            this.pictures[i].addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onDown, this);
	            var _a = posList[i], x = _a[0], y = _a[1];
	            this.dragPic.x = x;
	            this.dragPic.y = y;
	        }
	        this._timer = setInterval(function () {
	            _this.onTimer();
	        }, 10);
	        this.date = new Date().getTime();
	    };
	    GameView.prototype.onTimer = function () {
	        var date = new Date().getTime();
	        var gap = ((date - this.date) / 1000);
	        this.date = date;
	        GAME_TIME -= gap;
	        if (GAME_TIME < 0) {
	            GAME_TIME = 0;
	        }
	        GAME_TIME = this.afterPointTwo(GAME_TIME);
	        GAME_TIME = GAME_TIME.toFixed(2);
	        if (GAME_TIME < 10) {
	            GAME_TIME = '0' + GAME_TIME;
	        }
	        engine.globalEvent.dispatchEvent('pictures-time-update', {
	            second: this.getSecond(),
	        });
	        if (this.getSecond() == 0) {
	            this.stop();
	            engine.globalEvent.dispatchEvent('pictures-game-fail', {
	                reason: 1
	            });
	            this.stage.removeEventListener(engine.MouseEvent.MOUSE_UP, this.stageOnUp, this);
	        }
	    };
	    GameView.prototype.afterPointTwo = function (n) {
	        var floatN = parseFloat(n);
	        if (isNaN(floatN)) {
	            return;
	        }
	        floatN = Math.round(floatN * 100) / 100;
	        return floatN;
	    };
	    GameView.prototype.getSecond = function () {
	        return GAME_TIME;
	    };
	    GameView.prototype.stop = function () {
	        GAME_TIME = props.GAME_TIME;
	        clearInterval(this._timer);
	        var len = this.pictures.length;
	        for (var i = 0; i < len; i++) {
	            this.pictures[i].removeAllEventListener();
	        }
	    };
	    GameView.prototype.createRects = function () { };
	    GameView.prototype.setup = function () {
	        console.log('onSteup', props);
	        var parent = new engine.Sprite();
	        this.picturesWrapper = parent;
	        this.addChild(parent);
	    };
	    GameView.prototype.onDown = function (e) {
	        var stageLeft = (750 - props.W) / 2;
	        var stageTop = (this.stage.height - props.H) / 2;
	        this.dragPic = e.target;
	        this.picturesWrapper.addChild(this.dragPic);
	        this.localPicX = e.localX / MAX_COL;
	        this.localPicY = e.localY / MAX_ROW;
	        this.distanceX = this.dragPic.x;
	        this.distanceY = this.dragPic.y;
	        this.indexJ = Math.floor((this.distanceX) / (w + GAP));
	        this.indexI = Math.floor((this.distanceY) / (h + GAP));
	        this.index = (this.indexI) * MAX_COL + this.indexJ;
	        this.centerX = Math.floor((e.clientX - stageLeft) / w) * w + w / 2;
	        this.centerY = Math.floor((e.clientY - stageTop) / h) * h + h / 2;
	        this.stage.addEventListener(engine.MouseEvent.MOUSE_MOVE, this.onMove, this);
	        this.stage.addEventListener(engine.MouseEvent.MOUSE_UP, this.stageOnUp, this);
	    };
	    GameView.prototype.stageOnUp = function (e) {
	        var stageLeft = (750 - props.W) / 2;
	        var stageTop = (this.stage.height - props.H) / 2;
	        this.stage.removeEventListener(engine.MouseEvent.MOUSE_MOVE, this.onMove, this);
	        this.stage.removeEventListener(engine.MouseEvent.MOUSE_UP, this.stageOnUp, this);
	        if (this.centerY < stageTop || this.centerX < stageLeft) {
	            this.dragPic.x = this.distanceX;
	            this.dragPic.y = this.distanceY;
	        }
	        var curJ = Math.floor(this.centerX / (w + GAP));
	        var curI = Math.floor(this.centerY / (h + GAP));
	        if (0 <= curJ && curJ < (MAX_COL) && 0 <= curI && curI < (MAX_ROW)) {
	            var index = getIndexFromRC(curI, curJ, MAX_COL);
	            var dropPic = this.pictures[index];
	            var dropPicX = dropPic.x + stageLeft;
	            var dropPicy = dropPic.y + stageTop;
	            dropPic.x = this.distanceX;
	            dropPic.y = this.distanceY;
	            this.dragPic.x = dropPicX - stageLeft;
	            this.dragPic.y = dropPicy - stageTop;
	            var dropPicIndex = this.pictures.indexOf(dropPic);
	            var dragPicIndex = this.pictures.indexOf(this.dragPic);
	            this.pictures[dropPicIndex] = this.dragPic;
	            this.pictures[dragPicIndex] = dropPic;
	            if (dragPicIndex === dropPicIndex) {
	                this.dragPic.x = this.distanceX;
	                this.dragPic.y = this.distanceY;
	            }
	            var result = true;
	            for (var j = 0; j < this.rightList.length; j++) {
	                if (this.rightList[j] != this.pictures[j]) {
	                    result = false;
	                    break;
	                }
	            }
	            if (result) {
	                this.onSuccess();
	            }
	        }
	        else {
	            this.dragPic.x = this.distanceX;
	            this.dragPic.y = this.distanceY;
	        }
	    };
	    GameView.prototype.onSuccess = function () {
	        console.log('拼图成功!');
	        engine.globalEvent.dispatchEvent('pictures-game-success', { time: GAME_TIME });
	        this.stop();
	        props.GAME_TIME *= 0.9;
	        ++props.MAX_ROW;
	        ++props.MAX_COL;
	    };
	    GameView.prototype.onMove = function (e) {
	        this.dragPic.x = e.stageX - this.localPicX - (750 - props.W) / 2;
	        this.dragPic.y = e.stageY - this.localPicY - (this.stage.height - props.H) / 2;
	        this.centerX = this.dragPic.x + w / 2;
	        this.centerY = this.dragPic.y + h / 2;
	    };
	    return GameView;
	}(engine.Container));
	//# sourceMappingURL=GameView.js.map

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('pictures-start', _this.start, _this);
	        engine.globalEvent.addEventListener('pictures-stop', _this.stop, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        return _this;
	    }
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	        this._gameView.start();
	    };
	    GameWrapper.prototype.stop = function (event) {
	        this._gameView.stop();
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map