import createBg from "./createBg";
import createImg from "./createImg";
import { createSvga } from "../utils";

export default class GuideView extends engine.Sprite {
    guideBg: engine.Sprite;
    guideEle: engine.Sprite;
    svga: svga.Svga;

    constructor() {
        super();
        this.initUI();
        this.visible = false;
    }

    initUI() {
        this.addChild(createBg(.6))
        this.guideBg = createImg('guideBg')
        this.addChild(this.guideBg)
        this.guideEle = createImg('guideEle')
        this.addChild(this.guideEle)
        this.guideBg.x = 403;
        this.guideBg.y = 565;
        this.guideEle.x = 361;

        this.guideEle.y = 877;
        this.guideEle.anchorX=14;
        this.guideEle.anchorY=88;
        this.guideEle.mouseEnabled = this.guideEle.mouseChildren = true;

        let svga = createSvga("guideTips");
        this.svga = svga
        this.addChild(svga);
        svga.gotoAndStop(1);
        svga.mouseEnabled = svga.mouseChildren = false;
    }

    checkHit(x, y, w, h) {
        const rect = new engine.Rectangle(403, 565, 252, 297);
        if (x > rect.x && y > rect.y && (x + w) < (rect.x + rect.width) && (y + h) < (rect.y + rect.height)) {
            return true
        }
        return false;
    }

    async startGuide() {
        return new Promise((r) => {
            this.visible = true;
            this.svga.gotoAndStop(1);
            this.svga.play(false, true)
            this.guideEle.scaleX = 1;
            this.guideEle.scaleY = 1;

            let offset = [0, 0]
            const guideOver = () => {
                this.guideEle.removeEventListener(engine.MouseEvent.MOUSE_DOWN, ondown, this)
                this.guideEle.anchorX=14;
                this.guideEle.anchorY=44;
                engine.Tween.get(this.guideEle).to({scaleX:0,scaleY:0},300).call(()=>{
                    this.visible = false;
                    r();
                });
            }

            const onUp = (e: engine.MouseEvent) => {
                this.stage.removeEventListener(engine.MouseEvent.MOUSE_MOVE, onMove, this)
                if (this.checkHit(this.guideEle.x, this.guideEle.y, this.guideEle.width, this.guideEle.height)) {
                    guideOver();
                } else {
                    this.svga.visible = true;
                    this.guideEle.x = 361;
                    this.guideEle.y = 877;
                    engine.Tween.get(this.guideEle).set({scaleX:0,scaleY:0}).to({scaleX:1,scaleY:1},300)
                }
            }

            const onMove = (e: engine.MouseEvent) => {
                this.guideEle.x = e.stageX - offset[0];
                this.guideEle.y = e.stageY - offset[1];
            }

            const ondown = (e: engine.MouseEvent) => {
                offset = [e.localX, e.localY]
                this.svga.visible = false;
                this.stage.once(engine.MouseEvent.MOUSE_UP, onUp, this)
                this.stage.addEventListener(engine.MouseEvent.MOUSE_MOVE, onMove, this)
            }

            this.guideEle.addEventListener(engine.MouseEvent.MOUSE_DOWN, ondown, this)

        })
    }
}