import { getTextureByName, playSound } from "../utils";
import { GarbageTypes } from "../datas/GarbageTypes";
import GameView from "../GameView";
import { props } from "../../props";

export default class WrongTips extends engine.Sprite {
    img: engine.Image;
    constructor() {
        super();

        this.img = new engine.Image();
        this.img.texture = getTextureByName('wrongTips')//wrongTips
        this.addChild(this.img);
        this.img.anchorX = 88 / 2;
        this.img.anchorY = 85 / 2;
        this.visible = false;
    }

    play(rect: engine.Rectangle) {
        this.visible = true;

        if (props.sound) {
            playSound("wrongTipsMp3");
        }

        const dur = 70;
        const stren = 20;
        engine.Tween.get(this.img).set({ x: 0, y: 0, scaleX: 1, scaleY: 1, alpha: 1 })
            .to({ x: stren }, dur)
            .to({ x: 0 }, dur)
            .to({ x: -stren }, dur)
            .to({ x: 0 }, dur)
            .wait(200)
            .to({ alpha: 0 }, 300)


        this.x = rect.x + 180;
        this.y = rect.y;
    }
}

export const getTargetRect = (targetType, gameview: GameView) => {
    switch (targetType) {
        case GarbageTypes.dryWaste:
            return gameview.dryWaste
            break;
        case GarbageTypes.wetWaste:
            return gameview.wetWaste
            break;
        case GarbageTypes.harmfulWaste:
            return gameview.harmfulWaste
            break;
        case GarbageTypes.recoverableWaste:
            return gameview.recoverableWaste
            break;

        default:
            break;
    }
}