import { getTextureByName, playSound } from "../utils";
import { props } from "../../props";

export default class RightTips extends engine.Sprite {
    img: engine.Image;
    txt: engine.TextField;
    private SCORE = props.onceScore || 2;
    constructor() {
        super();

        this.img = new engine.Image();
        this.img.texture = getTextureByName('rightTips')
        this.addChild(this.img);
        this.img.anchorX = 88 / 2;
        this.img.anchorY = 85 / 2;
        this.visible = false;

        this.txt = new engine.TextField();
        this.addChild(this.txt)
        this.txt.text = '+' + this.SCORE
        this.txt.size = 60;
        this.txt.fillColor = '#437726'
        // this.txt.bold = true
        engine.playSound
    }

    play(rect: engine.Rectangle) {
        
        if (props.sound) {
            playSound("rightTipsSound");
        }
        this.visible = true;

        this.txt.x = 100;
        engine.Tween.get(this.txt).set({ y: 60, alpha: 1 })
            .to({ y: -50 }, 500)
            .to({ alpha: 0 })

        const DUR = 70;
        engine.Tween.get(this.img).set({ x: 0, y: 0, scaleX: 0, scaleY: 0, alpha: 1 })
            .to({ scaleX: 1, scaleY: 1 }, 200, engine.Ease.getBackOut(1))
            .wait(200)
            .to({ alpha: 0 }, 300)


        this.x = rect.x + 180;
        this.y = rect.y;
    }
}