import createBg from "./createBg";
import createImg from "./createImg";
import { props } from "../../props";
import { playSound } from "../utils";

export default class CountDownGroup extends engine.Sprite {
    num1: engine.Sprite;
    num2: engine.Sprite;
    num3: engine.Sprite;
    go: engine.Sprite;
    constructor() {
        super();

        this.addChild(createBg(.6))

        this.num1 = createImg('num1')
        this.num2 = createImg('num2')
        this.num3 = createImg('num3')
        this.go = createImg('go')
        this.go.anchorX = 240
        this.go.anchorY = 171.5
        this.num1.anchorX = 125.5
        this.num1.anchorY = 189
        this.num2.anchorX = 149.5
        this.num2.anchorY = 191.5
        this.num3.anchorX = 148.5
        this.num3.anchorY = 191.5
        this.go.x = 750 / 2 - 240
        this.go.y = 525 - 171.5
        this.num1.x = 750 / 2 - 125.5
        this.num1.y = 529 - 189
        this.num2.x = 750 / 2 - 149.5
        this.num2.y = 526 - 191.5
        this.num3.x = 750 / 2 - 148.5
        this.num3.y = 525 - 191.5
        this.addChild(this.num1)
        this.addChild(this.num2)
        this.addChild(this.num3)
        this.addChild(this.go)

        this.visible = false;
        this.reset();
    }

    private reset() {
        this.go.alpha = this.num1.alpha = this.num2.alpha = this.num3.alpha = 0;
        this.go.scaleX = this.num1.scaleX = this.num2.scaleX = this.num3.scaleX = 3;
        this.go.scaleY = this.num1.scaleY = this.num2.scaleY = this.num3.scaleY = 3;
    }

    async startCountDown() {
        return new Promise((r) => {
            this.reset();
            this.visible = true;

            this.num3.alpha = 1;
            let n3 = engine.Tween.get(this.num3);

            if (props.sound) {
                playSound("numCountDown");
            }

            n3.to({ scaleX: 0.8, scaleY: 0.8 }, 200).to({ scaleX: 1, scaleY: 1 }, 100).wait(500).to({ scaleX: 0, scaleY: 0 }, 200).call(() => {
                this.num2.alpha = 1;
                let n2 = engine.Tween.get(this.num2);
                if (props.sound) {
                    playSound("numCountDown");
                }
                n2.to({ scaleX: 0.8, scaleY: 0.8 }, 200).to({ scaleX: 1, scaleY: 1 }, 100).wait(500).to({ scaleX: 0, scaleY: 0 }, 200).call(() => {
                    this.num1.alpha = 1;
                    let n1 = engine.Tween.get(this.num1);
                    if (props.sound) {
                        playSound("numCountDown");
                    }
                    n1.to({ scaleX: 0.8, scaleY: 0.8 }, 200).to({ scaleX: 1, scaleY: 1 }, 100).wait(500).to({ scaleX: 0, scaleY: 0 }, 200).call(() => {
                        this.go.alpha = 1;
                        let go = engine.Tween.get(this.go);
                        if (props.sound) {
                            if (props.sound)  playSound("goMp3");
                        }
                        go.to({ scaleX: 0.8, scaleY: 0.8 }, 200).to({ scaleX: 1, scaleY: 1 }, 100).wait(500).call(() => {
                            this.visible = false;
                            
                            r()
                        })
                    })
                })
            })


        })

    }
}