/**
 * Created by rockyl on 2020-01-09.
 */

import GameView from "./GameView";
import { injectProps } from "../props";


export class GameWrapper extends engine.Container {
	
	updateSound(event: engine.Event) {
		injectProps(event.data);
	}

	// private _status;
	private _gameView: GameView;
	constructor() {
		super();

		engine.globalEvent.addEventListener('recycling-start', this.start, this);
		engine.globalEvent.addEventListener('recycling-sound-update', this.updateSound, this);
		engine.globalEvent.addEventListener('recycling-stop', this.stop, this);

		//创建实例
		let gameView = this._gameView = new GameView();
		this.addChild(gameView);

	}

	start(event: engine.Event) {
		injectProps(event.data);

		this._gameView.start();
	}
	stop(event: engine.Event) {
		
		this._gameView.stop();
	}
}
