/**
 * Created by rockyl on 2018/8/16.
 */

import { getTextureByName, playSound } from "../../../recycling/src/game/utils";
import { props } from "../props";
import Conveyor from "./Conveyor";
import Conveyors from "./Conveyors";
import uiConfig from "./uiConfig";
import getGuideInfo, { setGuide } from "./utils/getGuideInfo";
import CountDownGroup from "./views/CountDownGroup";
import GuideView from "./views/guideView";
import WrongTips from "./views/WrongTips";
import RightTips from "./views/RightTips";

export default class GameView extends engine.Container {
  private _timer;
  private _timeCounter = 0;
  uiMap: any;
  wetWaste: engine.Rectangle;
  harmfulWaste: engine.Rectangle;
  dryWaste: engine.Rectangle;
  recoverableWaste: engine.Rectangle;
  countdown: CountDownGroup;
  guide: GuideView;
  conveyors: Conveyors;
  wrongTips: WrongTips;
  rightTips: RightTips;

  constructor() {
    super();
    this.once(engine.Event.ADDED_TO_STAGE, this.setup, this);
  }

  configUI() {

    const uiMap: any = {};
    this.uiMap = uiMap;
    const config = uiConfig();
    for (const item of config) {
      const { id, texture, pos, anchor } = item;
      const sp = new engine.Sprite(getTextureByName(texture));
      this.addChild(sp);
      uiMap[id] = sp;
      if (anchor) {
        sp.anchorX = anchor[0];
        sp.anchorY = anchor[1];
      }
      if (pos) {
        sp.x = pos[0];
        sp.y = pos[1];
        if (anchor) {
          sp.x = pos[0] - sp.anchorX;
          sp.y = pos[1] - sp.anchorY;
        }
      }
    }

    this.configConveyors();

    this.createRects();

    this.countdown = new CountDownGroup();
    this.addChild(this.countdown)

    this.guide = new GuideView();
    this.addChild(this.guide);

    this.wrongTips = new WrongTips();
    this.rightTips = new RightTips()
    this.addChild(this.wrongTips)
    this.addChild(this.rightTips)

  }

  private createRects() {
    this.wetWaste = this.createRect(104, 565, 252, 297, 0xffffff);
    this.harmfulWaste = this.createRect(104, 232, 252, 297, 0xff0000);
    this.dryWaste = this.createRect(403, 232, 252, 297, 0x000000);
    this.recoverableWaste = this.createRect(403, 565, 252, 297, 0x0000ff);
  }

  createRect(x, y, w, h, c) {
    const rect = new engine.Rectangle(x, y, w, h);

    const sp = new engine.Sprite();
    this.addChild(sp);
    sp.x = x;
    sp.y = y;

    const g = new engine.Graphics;
    g.alpha = 0.0;
    g.beginFill(c);
    g.drawRect(0, 0, w, h);
    g.endFill();
    sp.addChild(g);

    return rect;
  }

  private configConveyors() {
    const conveyor0 = new Conveyor();
    const conveyor1 = new Conveyor();
    this.addChild(conveyor0);
    this.addChild(conveyor1);
    conveyor0.x = 0;
    conveyor1.x = 764;
    this.conveyors = new Conveyors(this);
    this.conveyors.initData(conveyor0, conveyor1)
  }

  playAni() {
    let idlerWheels = ['idler0', 'idler1', 'idler2', 'idler3', 'idler4', 'idler5', 'idler6'];
    idlerWheels = idlerWheels.map(i => this.uiMap[i]);
    idlerWheels.forEach(i => {
      engine.Tween.get(i, { loop: true }).to({ rotation: -360 }, 1000);
    })
  }

  stopAni() {
    let idlerWheels = ['idler0', 'idler1', 'idler2', 'idler3', 'idler4', 'idler5', 'idler6'];
    idlerWheels = idlerWheels.map(i => this.uiMap[i]);
    idlerWheels.forEach(i => {
      engine.Tween.removeTweens(i);
    })
  }

  async start() {
    console.log('on start')
    this._timeCounter = 0;

    if (!getGuideInfo()) {
      await this.guide.startGuide();
      setGuide();
    }

    this.conveyors.clear()

    await this.countdown.startCountDown();

    this.startGame();

    engine.globalEvent.dispatchEvent('recycling-time-update', {
      second: this.getSecond(),
    });

    this._timer = setInterval(() => {
      this.onTimer();
    }, 1000);
  }

  private startGame() {
    this.playAni();
    this.conveyors.startConveyors();
  }

  private stopGame() {
    this.stopAni();
  }

  getSecond() {

    return props.time - this._timeCounter
  }

  onTimer() {
    this._timeCounter++;
    engine.globalEvent.dispatchEvent('recycling-time-update', {
      second: this.getSecond(),
    });

    if (this.getSecond() == 0) {
      this.stop();
      this.conveyors.timeout();
      if (props.sound) playSound("gameOverMp3")
    }
  }

  stop() {
    clearInterval(this._timer);
    this.stopGame();
  }

  setup() {
    console.log('onSteup', props);
    this.configUI();
  }

  onDown(e: engine.MouseEvent) {

  }

  stageOnUp(e) {


  }

  private onSuccess() {


  }

  onMove(e: engine.MouseEvent) {

  }

}
