import { getTextureByName } from "./utils";

export default class Conveyor extends engine.Sprite {

    idx0: engine.Sprite;
    idx1: engine.Sprite;
    idx2: engine.Sprite;
    idx3: engine.Sprite;
    idx4: engine.Sprite;
    constructor() {
        super();

        this.y = 904.21;

        const sp = new engine.Sprite(getTextureByName('conveyor'));
        this.addChild(sp);

        this.idx0 = this.createItem(75, 50);
        this.idx1 = this.createItem(225, 50);
        this.idx2 = this.createItem(375, 50);
        this.idx3 = this.createItem(525, 50);
        this.idx4 = this.createItem(675, 50);
    }

    clear() {
        this.clearItem(this.idx0)
        this.clearItem(this.idx1)
        this.clearItem(this.idx2)
        this.clearItem(this.idx3)
        this.clearItem(this.idx4)
    }
    private clearItem(idx: engine.Sprite) {
        if (idx.children.length > 0)
            idx.removeChildAt(0)
    }

    private createItem(x, y) {
        const sp = new engine.Sprite();
        this.addChild(sp);
        sp.x = x;
        sp.y = y;

        // const g = new engine.Graphics;
        // g.beginFill(0xff0000);
        // g.drawRect(0,0,100,100);
        // g.endFill();
        // sp.addChild(g);

        return sp
    }
}