(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global.recycling = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	function playSound(name) {
	    engine.playSound(engine.getAssetByName(name).uuid, { keep: true });
	}
	function createSvga(name, anchorName) {
	    var inst = new svga.Svga();
	    inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	    return inst;
	}
	//# sourceMappingURL=utils.js.map

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	var Conveyor = (function (_super) {
	    tslib.__extends(Conveyor, _super);
	    function Conveyor() {
	        var _this = _super.call(this) || this;
	        _this.y = 904.21;
	        var sp = new engine.Sprite(getTextureByName('conveyor'));
	        _this.addChild(sp);
	        _this.idx0 = _this.createItem(75, 50);
	        _this.idx1 = _this.createItem(225, 50);
	        _this.idx2 = _this.createItem(375, 50);
	        _this.idx3 = _this.createItem(525, 50);
	        _this.idx4 = _this.createItem(675, 50);
	        return _this;
	    }
	    Conveyor.prototype.clear = function () {
	        this.clearItem(this.idx0);
	        this.clearItem(this.idx1);
	        this.clearItem(this.idx2);
	        this.clearItem(this.idx3);
	        this.clearItem(this.idx4);
	    };
	    Conveyor.prototype.clearItem = function (idx) {
	        if (idx.children.length > 0)
	            idx.removeChildAt(0);
	    };
	    Conveyor.prototype.createItem = function (x, y) {
	        var sp = new engine.Sprite();
	        this.addChild(sp);
	        sp.x = x;
	        sp.y = y;
	        return sp;
	    };
	    return Conveyor;
	}(engine.Sprite));
	//# sourceMappingURL=Conveyor.js.map

	var GarbageTypes;
	(function (GarbageTypes) {
	    GarbageTypes["recoverableWaste"] = "recoverableWaste";
	    GarbageTypes["harmfulWaste"] = "harmfulWaste";
	    GarbageTypes["wetWaste"] = "wetWaste";
	    GarbageTypes["dryWaste"] = "dryWaste";
	})(GarbageTypes || (GarbageTypes = {}));
	//# sourceMappingURL=GarbageTypes.js.map

	var GarbageConfig = (function () {
	    function GarbageConfig() {
	    }
	    GarbageConfig.config = [
	        { name: "保鲜盒", source: "g00", type: GarbageTypes.recoverableWaste, width: 129, height: 111 },
	        { name: "报纸", source: "g01", type: GarbageTypes.recoverableWaste, width: 138, height: 144 },
	        { name: "贝壳", source: "g02", type: GarbageTypes.dryWaste, width: 79, height: 117 },
	        { name: "冰箱", source: "g03", type: GarbageTypes.recoverableWaste, width: 63, height: 151 },
	        { name: "菜梗菜叶", source: "g04", type: GarbageTypes.wetWaste, width: 144, height: 98 },
	        { name: "残枝落叶", source: "g05", type: GarbageTypes.wetWaste, width: 120, height: 99 },
	        { name: "茶叶渣", source: "g06", type: GarbageTypes.wetWaste, width: 86, height: 96 },
	        { name: "尘土", source: "g07", type: GarbageTypes.dryWaste, width: 109, height: 114 },
	        { name: "创口贴", source: "g08", type: GarbageTypes.dryWaste, width: 112, height: 90 },
	        { name: "大骨头", source: "g09", type: GarbageTypes.dryWaste, width: 89, height: 101 },
	        { name: "普通干电池", source: "g11", type: GarbageTypes.dryWaste, width: 89, height: 131 },
	        { name: "方便面盒", source: "g12", type: GarbageTypes.dryWaste, width: 89, height: 168 },
	        { name: "废弃食用油脂", source: "g13", type: GarbageTypes.wetWaste, width: 131, height: 164 },
	        { name: "骨骼内脏", source: "g14", type: GarbageTypes.wetWaste, width: 104, height: 82 },
	        { name: "锅具", source: "g15", type: GarbageTypes.recoverableWaste, width: 119, height: 149 },
	        { name: "果核", source: "g16", type: GarbageTypes.wetWaste, width: 99, height: 95 },
	        { name: "果皮", source: "g17", type: GarbageTypes.wetWaste, width: 115, height: 127 },
	        { name: "化妆品", source: "g18", type: GarbageTypes.harmfulWaste, width: 67, height: 151 },
	        { name: "鸡蛋壳", source: "g19", type: GarbageTypes.wetWaste, width: 99, height: 107 },
	        { name: "剪刀", source: "g20", type: GarbageTypes.recoverableWaste, width: 96, height: 127 },
	        { name: "胶带", source: "g21", type: GarbageTypes.dryWaste, width: 87, height: 113 },
	        { name: "榴莲壳", source: "g22", type: GarbageTypes.dryWaste, width: 136, height: 116 },
	        { name: "毛巾", source: "g23", type: GarbageTypes.recoverableWaste, width: 108, height: 96 },
	        { name: "纽扣电池", source: "g24", type: GarbageTypes.harmfulWaste, width: 87, height: 89 },
	        { name: "破旧陶瓷罐", source: "g25", type: GarbageTypes.dryWaste, width: 110, height: 125 },
	        { name: "杀虫剂", source: "g26", type: GarbageTypes.harmfulWaste, width: 64, height: 160 },
	        { name: "剩菜剩饭", source: "g27", type: GarbageTypes.wetWaste, width: 128, height: 96 },
	        { name: "手机", source: "g28", type: GarbageTypes.recoverableWaste, width: 82, height: 142 },
	        { name: "书本", source: "g29", type: GarbageTypes.recoverableWaste, width: 106, height: 132 },
	        { name: "玻璃杯", source: "g30", type: GarbageTypes.recoverableWaste, width: 62, height: 119 },
	        { name: "水银温度计", source: "g31", type: GarbageTypes.harmfulWaste, width: 109, height: 162 },
	        { name: "水银血压计", source: "g32", type: GarbageTypes.harmfulWaste, width: 115, height: 147 },
	        { name: "塑料桶", source: "g33", type: GarbageTypes.recoverableWaste, width: 92, height: 131 },
	        { name: "卫生纸", source: "g34", type: GarbageTypes.dryWaste, width: 92, height: 132 },
	        { name: "污染织物", source: "g35", type: GarbageTypes.dryWaste, width: 128, height: 139 },
	        { name: "污染纸张", source: "g36", type: GarbageTypes.dryWaste, width: 96, height: 136 },
	        { name: "洗衣机", source: "g37", type: GarbageTypes.recoverableWaste, width: 87, height: 157 },
	        { name: "烟蒂", source: "g38", type: GarbageTypes.dryWaste, width: 87, height: 124 },
	        { name: "药品", source: "g39", type: GarbageTypes.harmfulWaste, width: 109, height: 131 },
	        { name: "药品包装", source: "g40", type: GarbageTypes.harmfulWaste, width: 108, height: 125 },
	        { name: "椰子壳", source: "g41", type: GarbageTypes.dryWaste, width: 104, height: 119 },
	        { name: "衣服", source: "g42", type: GarbageTypes.recoverableWaste, width: 83, height: 137 },
	        { name: "衣架", source: "g43", type: GarbageTypes.recoverableWaste, width: 132, height: 125 },
	        { name: "易拉罐", source: "g44", type: GarbageTypes.recoverableWaste, width: 65, height: 133 },
	        { name: "荧光灯", source: "g45", type: GarbageTypes.harmfulWaste, width: 90, height: 118 },
	        { name: "油漆桶", source: "g46", type: GarbageTypes.harmfulWaste, width: 65, height: 143 },
	        { name: "一次性纸杯", source: "g47", type: GarbageTypes.dryWaste, width: 76, height: 116 },
	        { name: "纸尿裤", source: "g48", type: GarbageTypes.dryWaste, width: 93, height: 138 },
	        { name: "纸箱", source: "g49", type: GarbageTypes.recoverableWaste, width: 112, height: 118 },
	        { name: "指甲油", source: "g50", type: GarbageTypes.harmfulWaste, width: 64, height: 138 },
	    ];
	    return GarbageConfig;
	}());
	//# sourceMappingURL=GarbageConfig.js.map

	var transStores = (function (list) {
	    var tmp = [];
	    var contains = function (val) {
	        for (var _i = 0, tmp_1 = tmp; _i < tmp_1.length; _i++) {
	            var i = tmp_1[_i];
	            if (val.targetType == i.targetType && val.itemType == i.itemType && val.itemName == i.itemName)
	                return true;
	        }
	        return false;
	    };
	    list.forEach(function (i) {
	        if (!contains(i))
	            tmp.push(i);
	    });
	    list = tmp;
	    tmp = [];
	    var nameList = [];
	    var contains2 = function (val) {
	        for (var _i = 0, tmp_2 = tmp; _i < tmp_2.length; _i++) {
	            var i = tmp_2[_i];
	            if (val.itemName == i.itemName) {
	                nameList.push(i.itemName);
	                return true;
	            }
	        }
	        return false;
	    };
	    list.forEach(function (i) {
	        if (!contains2(i))
	            tmp.push(i);
	    });
	    list = tmp;
	    list.forEach(function (i) {
	        if (nameList.indexOf(i.itemName) != -1) {
	            i.targetType = i.itemType;
	        }
	    });
	    return list.map(function (i) {
	        return {
	            'targetName': getTargetName(i.targetType),
	            'isCorrect': i.targetType == i.itemType,
	            'itemName': i.itemName,
	            'itemTypeName': getTargetName(i.itemType)
	        };
	    });
	});
	var getTargetName = function (type) {
	    switch (type) {
	        case GarbageTypes.recoverableWaste:
	            return '可回收物';
	        case GarbageTypes.harmfulWaste:
	            return '有害垃圾';
	        case GarbageTypes.wetWaste:
	            return '湿垃圾';
	        case GarbageTypes.dryWaste:
	            return '其他垃圾';
	    }
	};
	//# sourceMappingURL=transStores.js.map

	var checkHit = (function (view, rect) {
	    var x = view.x, y = view.y;
	    var _a = view.texture, width = _a.width, height = _a.height;
	    if (x > rect.x && y > rect.y && (x + width) < (rect.x + rect.width) && (y + height) < (rect.y + rect.height)) {
	        return true;
	    }
	    return false;
	});
	//# sourceMappingURL=checkHit.js.map

	var removeChild = (function (d) {
	    if (d && d.parent) {
	        d.parent.removeChild(d);
	    }
	});
	//# sourceMappingURL=removeChild.js.map

	var removeEle = (function (e, arr) {
	    var index = arr.indexOf(e);
	    if (index >= 0) {
	        arr.splice(index, 1);
	    }
	});
	//# sourceMappingURL=removeEle.js.map

	var shuffle = (function (arr) {
	    var _a;
	    var i = arr.length;
	    while (i) {
	        var j = Math.floor(Math.random() * i--);
	        _a = [arr[i], arr[j]], arr[j] = _a[0], arr[i] = _a[1];
	    }
	    return arr;
	});
	//# sourceMappingURL=shuffle.js.map

	var WrongTips = (function (_super) {
	    tslib.__extends(WrongTips, _super);
	    function WrongTips() {
	        var _this = _super.call(this) || this;
	        _this.img = new engine.Image();
	        _this.img.texture = getTextureByName('wrongTips');
	        _this.addChild(_this.img);
	        _this.img.anchorX = 88 / 2;
	        _this.img.anchorY = 85 / 2;
	        _this.visible = false;
	        return _this;
	    }
	    WrongTips.prototype.play = function (rect) {
	        this.visible = true;
	        if (props.sound) {
	            playSound("wrongTipsMp3");
	        }
	        var dur = 70;
	        var stren = 20;
	        engine.Tween.get(this.img).set({ x: 0, y: 0, scaleX: 1, scaleY: 1, alpha: 1 })
	            .to({ x: stren }, dur)
	            .to({ x: 0 }, dur)
	            .to({ x: -stren }, dur)
	            .to({ x: 0 }, dur)
	            .wait(200)
	            .to({ alpha: 0 }, 300);
	        this.x = rect.x + 180;
	        this.y = rect.y;
	    };
	    return WrongTips;
	}(engine.Sprite));
	var getTargetRect = function (targetType, gameview) {
	    switch (targetType) {
	        case GarbageTypes.dryWaste:
	            return gameview.dryWaste;
	        case GarbageTypes.wetWaste:
	            return gameview.wetWaste;
	        case GarbageTypes.harmfulWaste:
	            return gameview.harmfulWaste;
	        case GarbageTypes.recoverableWaste:
	            return gameview.recoverableWaste;
	    }
	};
	//# sourceMappingURL=WrongTips.js.map

	var Conveyors = (function (_super) {
	    tslib.__extends(Conveyors, _super);
	    function Conveyors(p) {
	        var _this = _super.call(this) || this;
	        _this.conveyorsPool = [];
	        _this.GarbageConfig = GarbageConfig.config;
	        _this.datas = [];
	        _this.wrapper = p;
	        return _this;
	    }
	    Conveyors.prototype.initData = function (conveyor0, conveyor1) {
	        this.conveyor0 = conveyor0;
	        this.conveyor1 = conveyor1;
	    };
	    Conveyors.prototype.setDefault = function () {
	        this.score = 0;
	        this.conveyorsPool.push(this.conveyor0);
	        this.conveyorsPool.push(this.conveyor1);
	        var allConfigs = shuffle(this.GarbageConfig.concat([]));
	        for (var i = 0; i < GarbageConfig.config.length; i++) {
	            allConfigs[i].idx = i;
	            allConfigs[i].isRight = false;
	            allConfigs[i].isMistake = false;
	            allConfigs[i].isOnStage = false;
	            this.datas.push(allConfigs[i]);
	        }
	        for (var i = 0; i < 5; i++) {
	            var data = this.datas[i];
	            var view = new engine.Sprite(getTextureByName(data.source));
	            view.isWrong = false;
	            view.isRight = false;
	            data.isOnStage = true;
	            view.data = data;
	            view.type = data.type;
	            view.name = data.name;
	            view.anchorX = data.width / 2;
	            view.anchorY = data.height;
	            view.x = -data.width / 2;
	            view.y = -data.height + 40;
	            this.conveyor1["idx" + i].addChild(view);
	            view.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onDown_garbage, this);
	        }
	    };
	    Conveyors.prototype.startConveyors = function () {
	        this.setDefault();
	        engine.gameStage.addEventListener(engine.Event.ENTER_FRAME, this.onEnterFrame, this);
	    };
	    Conveyors.prototype.onEnterFrame = function (ENTER_FRAME, onEnterFrame, arg2) {
	        if (this.score == (props.maxScore || 100)) {
	            this.gameOver();
	            this.wrapper.stop();
	            if (props.sound)
	                playSound("gameOverMp3");
	        }
	        this.conveyorsPool.forEach(function (conveyor) {
	            conveyor.x -= props.speed || 3;
	        });
	        if (this.conveyorsPool[this.conveyorsPool.length - 1].x <= 764) {
	            var conveyor = new Conveyor();
	            conveyor.x = this.conveyorsPool[this.conveyorsPool.length - 1].x + 764;
	            this.wrapper.addChild(conveyor);
	            this.conveyorsPool.push(conveyor);
	        }
	        else {
	            var dataList = [];
	            for (var n = 0; n < this.datas.length; n++) {
	                var dataItem = this.datas[n];
	                if (!dataItem.isRight && !dataItem.isOnStage) {
	                    dataList.push(dataItem);
	                }
	            }
	            var lastConveyor = this.conveyorsPool[this.conveyorsPool.length - 1];
	            for (var m = 0; m < 5; m++) {
	                if (!lastConveyor["idx" + m].children[0]) {
	                    var data = dataList.shift();
	                    if (data) {
	                        data.isOnStage = true;
	                        var view = new engine.Sprite(getTextureByName(data.source));
	                        view.data = data;
	                        view.isWrong = false;
	                        view.isRight = false;
	                        view.type = data.type;
	                        view.name = data.name;
	                        view.anchorX = data.width / 2;
	                        view.anchorY = data.height;
	                        view.x = -data.width / 2;
	                        view.y = -data.height + 40;
	                        lastConveyor["idx" + m].addChild(view);
	                        view.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onDown_garbage, this);
	                    }
	                    else {
	                        break;
	                    }
	                }
	            }
	        }
	        if (this.conveyorsPool[0].x < -750) {
	            for (var k = 0; k < this.datas.length; k++) {
	                var dataItem = this.datas[k];
	                var idx4 = this.conveyorsPool[0]["idx" + 4];
	                if (idx4.children[0]) {
	                    if (dataItem.name == idx4.children[0].name) {
	                        dataItem.isOnStage = false;
	                        removeEle(dataItem, this.datas);
	                        this.datas.push(dataItem);
	                        idx4.removeChild(idx4.children[0]);
	                        break;
	                    }
	                }
	            }
	            this.conveyorsPool.shift();
	        }
	        else if (this.conveyorsPool[0].x < -600) {
	            for (var k = 0; k < this.datas.length; k++) {
	                var dataItem = this.datas[k];
	                var idx3 = this.conveyorsPool[0]["idx" + 3];
	                if (idx3.children[0]) {
	                    if (dataItem.name == idx3.children[0].name) {
	                        dataItem.isOnStage = false;
	                        removeEle(dataItem, this.datas);
	                        this.datas.push(dataItem);
	                        idx3.removeChild(idx3.children[0]);
	                        break;
	                    }
	                }
	            }
	        }
	        else if (this.conveyorsPool[0].x < -450) {
	            for (var k = 0; k < this.datas.length; k++) {
	                var dataItem = this.datas[k];
	                var idx2 = this.conveyorsPool[0]["idx" + 2];
	                if (idx2.children[0]) {
	                    if (dataItem.name == idx2.children[0].name) {
	                        dataItem.isOnStage = false;
	                        removeEle(dataItem, this.datas);
	                        this.datas.push(dataItem);
	                        idx2.removeChild(idx2.children[0]);
	                        break;
	                    }
	                }
	            }
	        }
	        else if (this.conveyorsPool[0].x < -300) {
	            for (var k = 0; k < this.datas.length; k++) {
	                var dataItem = this.datas[k];
	                var idx1 = this.conveyorsPool[0]["idx" + 1];
	                if (idx1.children[0]) {
	                    if (dataItem.name == idx1.children[0].name) {
	                        dataItem.isOnStage = false;
	                        removeEle(dataItem, this.datas);
	                        this.datas.push(dataItem);
	                        idx1.removeChild(idx1.children[0]);
	                        break;
	                    }
	                }
	            }
	        }
	        else if (this.conveyorsPool[0].x < -150) {
	            for (var k = 0; k < this.datas.length; k++) {
	                var dataItem = this.datas[k];
	                var idx0 = this.conveyorsPool[0]["idx" + 0];
	                if (idx0.children[0]) {
	                    if (dataItem.name == idx0.children[0].name) {
	                        dataItem.isOnStage = false;
	                        removeEle(dataItem, this.datas);
	                        this.datas.push(dataItem);
	                        idx0.removeChild(idx0.children[0]);
	                        break;
	                    }
	                }
	            }
	        }
	    };
	    Conveyors.prototype.addscore = function () {
	        this.score += (props.onceScore || 2);
	        engine.globalEvent.dispatchEvent('recycling-score-update', {
	            score: this.score
	        });
	    };
	    Conveyors.prototype.gameOver = function () {
	        engine.gameStage.removeEventListener(engine.Event.ENTER_FRAME, this.onEnterFrame, this);
	        engine.globalEvent.dispatchEvent('recycling-game-end', transStores(this.stores));
	    };
	    Conveyors.prototype.onDown_garbage = function (e) {
	        if (this._currentDragView) {
	            removeChild(this._currentDragView);
	        }
	        var target = e.target;
	        var view = new engine.Sprite(target.texture);
	        this._currentDragView = view;
	        this._currentTarget = target;
	        target.scaleX = target.scaleY = 0;
	        this.wrapper.addChild(view);
	        view.x = e.stageX - target.texture.width / 2;
	        view.y = e.stageY - target.texture.height / 2;
	        view.type = target['type'];
	        view.name = target['name'];
	        this.wrapper.addEventListener(engine.MouseEvent.MOUSE_UP, this.onStageMouseUp, this);
	        this.wrapper.addEventListener(engine.MouseEvent.MOUSE_MOVE, this.onStageMouseMove, this);
	    };
	    Conveyors.prototype.onStageMouseMove = function (e) {
	        var view = this._currentDragView;
	        view.x = e.stageX - view.texture.width / 2;
	        view.y = e.stageY - view.texture.height / 2;
	    };
	    Conveyors.prototype.onStageMouseUp = function (e) {
	        var _this = this;
	        this.wrapper.removeEventListener(engine.MouseEvent.MOUSE_UP, this.onStageMouseUp, this);
	        this.wrapper.removeEventListener(engine.MouseEvent.MOUSE_MOVE, this.onStageMouseMove, this);
	        if (!this._currentDragView)
	            return;
	        var result = this.checkHitRect();
	        if (result) {
	            if (result == this._currentDragView['type']) {
	                this.addscore();
	                this.wrapper.rightTips.play(getTargetRect(result, this.wrapper));
	                this._currentTarget.data.isRight = true;
	            }
	            else {
	                engine.Tween.get(this._currentTarget).to({ scaleX: 1, scaleY: 1 }, 300).call(function () { });
	                this.wrapper.wrongTips.play(getTargetRect(result, this.wrapper));
	            }
	            this.stores.push({ targetType: result, itemType: this._currentDragView['type'], itemName: this._currentDragView['name'] });
	        }
	        else {
	            engine.Tween.get(this._currentTarget).to({ scaleX: 1, scaleY: 1 }, 300).call(function () { });
	        }
	        this._currentDragView.anchorX = this._currentDragView.texture.width / 2;
	        this._currentDragView.anchorY = this._currentDragView.texture.height / 2;
	        engine.Tween.get(this._currentDragView).to({ scaleX: 0, scaleY: 0 }, 300).call(function () {
	            removeChild(_this._currentDragView);
	        });
	    };
	    Conveyors.prototype.clear = function () {
	        this.conveyor0.x = 0;
	        this.conveyor1.x = 764;
	        this.conveyorsPool.forEach(function (i) {
	            i.clear();
	        });
	        this.conveyorsPool = [];
	        this.datas = [];
	        this.stores = [];
	    };
	    Conveyors.prototype.timeout = function () {
	        if (this._currentDragView) {
	            removeChild(this._currentDragView);
	        }
	        this.wrapper.removeEventListener(engine.MouseEvent.MOUSE_UP, this.onStageMouseUp, this);
	        this.wrapper.removeEventListener(engine.MouseEvent.MOUSE_MOVE, this.onStageMouseMove, this);
	        this.gameOver();
	    };
	    Conveyors.prototype.checkHitRect = function () {
	        if (checkHit(this._currentDragView, this.wrapper.wetWaste)) {
	            return GarbageTypes.wetWaste;
	        }
	        if (checkHit(this._currentDragView, this.wrapper.harmfulWaste)) {
	            return GarbageTypes.harmfulWaste;
	        }
	        if (checkHit(this._currentDragView, this.wrapper.dryWaste)) {
	            return GarbageTypes.dryWaste;
	        }
	        if (checkHit(this._currentDragView, this.wrapper.recoverableWaste)) {
	            return GarbageTypes.recoverableWaste;
	        }
	        return null;
	    };
	    return Conveyors;
	}(engine.Sprite));
	//# sourceMappingURL=Conveyors.js.map

	var uiConfig = (function () {
	    return [
	        {
	            id: 'playBg',
	            texture: 'playBg'
	        },
	        {
	            id: 'idler0',
	            texture: 'idlerWheel',
	            pos: [75, 1038],
	            anchor: [20, 21.5]
	        },
	        {
	            id: 'idler1',
	            texture: 'idlerWheel',
	            pos: [175, 1038],
	            anchor: [20, 21.5]
	        },
	        {
	            id: 'idler2',
	            texture: 'idlerWheel',
	            pos: [275, 1038],
	            anchor: [20, 21.5]
	        },
	        {
	            id: 'idler3',
	            texture: 'idlerWheel',
	            pos: [375, 1038],
	            anchor: [20, 21.5]
	        },
	        {
	            id: 'idler4',
	            texture: 'idlerWheel',
	            pos: [475, 1038],
	            anchor: [20, 21.5]
	        },
	        {
	            id: 'idler5',
	            texture: 'idlerWheel',
	            pos: [575, 1038],
	            anchor: [20, 21.5]
	        },
	        {
	            id: 'idler6',
	            texture: 'idlerWheel',
	            pos: [675, 1038],
	            anchor: [20, 21.5]
	        },
	    ];
	});
	//# sourceMappingURL=uiConfig.js.map

	var getGuideInfo = (function () {
	    if (!window.localStorage) {
	        return 0;
	    }
	    return localStorage.getItem('recyclingGuide');
	});
	var setGuide = function () {
	    if (window.localStorage)
	        localStorage.setItem('recyclingGuide', '1');
	};
	//# sourceMappingURL=getGuideInfo.js.map

	var createBg = (function (a) {
	    if (a === void 0) { a = 1; }
	    var rect = new engine.Graphics();
	    rect.beginFill(0);
	    rect.drawRect(0, 0, 750, 1624);
	    rect.endFill();
	    rect.alpha = a;
	    return rect;
	});
	//# sourceMappingURL=createBg.js.map

	var createImg = (function (texture) {
	    return new engine.Sprite(getTextureByName(texture));
	});
	//# sourceMappingURL=createImg.js.map

	var CountDownGroup = (function (_super) {
	    tslib.__extends(CountDownGroup, _super);
	    function CountDownGroup() {
	        var _this = _super.call(this) || this;
	        _this.addChild(createBg(.6));
	        _this.num1 = createImg('num1');
	        _this.num2 = createImg('num2');
	        _this.num3 = createImg('num3');
	        _this.go = createImg('go');
	        _this.go.anchorX = 240;
	        _this.go.anchorY = 171.5;
	        _this.num1.anchorX = 125.5;
	        _this.num1.anchorY = 189;
	        _this.num2.anchorX = 149.5;
	        _this.num2.anchorY = 191.5;
	        _this.num3.anchorX = 148.5;
	        _this.num3.anchorY = 191.5;
	        _this.go.x = 750 / 2 - 240;
	        _this.go.y = 525 - 171.5;
	        _this.num1.x = 750 / 2 - 125.5;
	        _this.num1.y = 529 - 189;
	        _this.num2.x = 750 / 2 - 149.5;
	        _this.num2.y = 526 - 191.5;
	        _this.num3.x = 750 / 2 - 148.5;
	        _this.num3.y = 525 - 191.5;
	        _this.addChild(_this.num1);
	        _this.addChild(_this.num2);
	        _this.addChild(_this.num3);
	        _this.addChild(_this.go);
	        _this.visible = false;
	        _this.reset();
	        return _this;
	    }
	    CountDownGroup.prototype.reset = function () {
	        this.go.alpha = this.num1.alpha = this.num2.alpha = this.num3.alpha = 0;
	        this.go.scaleX = this.num1.scaleX = this.num2.scaleX = this.num3.scaleX = 3;
	        this.go.scaleY = this.num1.scaleY = this.num2.scaleY = this.num3.scaleY = 3;
	    };
	    CountDownGroup.prototype.startCountDown = function () {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var _this = this;
	            return tslib.__generator(this, function (_a) {
	                return [2, new Promise(function (r) {
	                        _this.reset();
	                        _this.visible = true;
	                        _this.num3.alpha = 1;
	                        var n3 = engine.Tween.get(_this.num3);
	                        if (props.sound) {
	                            playSound("numCountDown");
	                        }
	                        n3.to({ scaleX: 0.8, scaleY: 0.8 }, 200).to({ scaleX: 1, scaleY: 1 }, 100).wait(500).to({ scaleX: 0, scaleY: 0 }, 200).call(function () {
	                            _this.num2.alpha = 1;
	                            var n2 = engine.Tween.get(_this.num2);
	                            if (props.sound) {
	                                playSound("numCountDown");
	                            }
	                            n2.to({ scaleX: 0.8, scaleY: 0.8 }, 200).to({ scaleX: 1, scaleY: 1 }, 100).wait(500).to({ scaleX: 0, scaleY: 0 }, 200).call(function () {
	                                _this.num1.alpha = 1;
	                                var n1 = engine.Tween.get(_this.num1);
	                                if (props.sound) {
	                                    playSound("numCountDown");
	                                }
	                                n1.to({ scaleX: 0.8, scaleY: 0.8 }, 200).to({ scaleX: 1, scaleY: 1 }, 100).wait(500).to({ scaleX: 0, scaleY: 0 }, 200).call(function () {
	                                    _this.go.alpha = 1;
	                                    var go = engine.Tween.get(_this.go);
	                                    if (props.sound) {
	                                        if (props.sound)
	                                            playSound("goMp3");
	                                    }
	                                    go.to({ scaleX: 0.8, scaleY: 0.8 }, 200).to({ scaleX: 1, scaleY: 1 }, 100).wait(500).call(function () {
	                                        _this.visible = false;
	                                        r();
	                                    });
	                                });
	                            });
	                        });
	                    })];
	            });
	        });
	    };
	    return CountDownGroup;
	}(engine.Sprite));
	//# sourceMappingURL=CountDownGroup.js.map

	var GuideView = (function (_super) {
	    tslib.__extends(GuideView, _super);
	    function GuideView() {
	        var _this = _super.call(this) || this;
	        _this.initUI();
	        _this.visible = false;
	        return _this;
	    }
	    GuideView.prototype.initUI = function () {
	        this.addChild(createBg(.6));
	        this.guideBg = createImg('guideBg');
	        this.addChild(this.guideBg);
	        this.guideEle = createImg('guideEle');
	        this.addChild(this.guideEle);
	        this.guideBg.x = 403;
	        this.guideBg.y = 565;
	        this.guideEle.x = 361;
	        this.guideEle.y = 877;
	        this.guideEle.anchorX = 14;
	        this.guideEle.anchorY = 88;
	        this.guideEle.mouseEnabled = this.guideEle.mouseChildren = true;
	        var svga = createSvga("guideTips");
	        this.svga = svga;
	        this.addChild(svga);
	        svga.gotoAndStop(1);
	        svga.mouseEnabled = svga.mouseChildren = false;
	    };
	    GuideView.prototype.checkHit = function (x, y, w, h) {
	        var rect = new engine.Rectangle(403, 565, 252, 297);
	        if (x > rect.x && y > rect.y && (x + w) < (rect.x + rect.width) && (y + h) < (rect.y + rect.height)) {
	            return true;
	        }
	        return false;
	    };
	    GuideView.prototype.startGuide = function () {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var _this = this;
	            return tslib.__generator(this, function (_a) {
	                return [2, new Promise(function (r) {
	                        _this.visible = true;
	                        _this.svga.gotoAndStop(1);
	                        _this.svga.play(false, true);
	                        _this.guideEle.scaleX = 1;
	                        _this.guideEle.scaleY = 1;
	                        var offset = [0, 0];
	                        var guideOver = function () {
	                            _this.guideEle.removeEventListener(engine.MouseEvent.MOUSE_DOWN, ondown, _this);
	                            _this.guideEle.anchorX = 14;
	                            _this.guideEle.anchorY = 44;
	                            engine.Tween.get(_this.guideEle).to({ scaleX: 0, scaleY: 0 }, 300).call(function () {
	                                _this.visible = false;
	                                r();
	                            });
	                        };
	                        var onUp = function (e) {
	                            _this.stage.removeEventListener(engine.MouseEvent.MOUSE_MOVE, onMove, _this);
	                            if (_this.checkHit(_this.guideEle.x, _this.guideEle.y, _this.guideEle.width, _this.guideEle.height)) {
	                                guideOver();
	                            }
	                            else {
	                                _this.svga.visible = true;
	                                _this.guideEle.x = 361;
	                                _this.guideEle.y = 877;
	                                engine.Tween.get(_this.guideEle).set({ scaleX: 0, scaleY: 0 }).to({ scaleX: 1, scaleY: 1 }, 300);
	                            }
	                        };
	                        var onMove = function (e) {
	                            _this.guideEle.x = e.stageX - offset[0];
	                            _this.guideEle.y = e.stageY - offset[1];
	                        };
	                        var ondown = function (e) {
	                            offset = [e.localX, e.localY];
	                            _this.svga.visible = false;
	                            _this.stage.once(engine.MouseEvent.MOUSE_UP, onUp, _this);
	                            _this.stage.addEventListener(engine.MouseEvent.MOUSE_MOVE, onMove, _this);
	                        };
	                        _this.guideEle.addEventListener(engine.MouseEvent.MOUSE_DOWN, ondown, _this);
	                    })];
	            });
	        });
	    };
	    return GuideView;
	}(engine.Sprite));
	//# sourceMappingURL=guideView.js.map

	var RightTips = (function (_super) {
	    tslib.__extends(RightTips, _super);
	    function RightTips() {
	        var _this = _super.call(this) || this;
	        _this.SCORE = props.onceScore || 2;
	        _this.img = new engine.Image();
	        _this.img.texture = getTextureByName('rightTips');
	        _this.addChild(_this.img);
	        _this.img.anchorX = 88 / 2;
	        _this.img.anchorY = 85 / 2;
	        _this.visible = false;
	        _this.txt = new engine.TextField();
	        _this.addChild(_this.txt);
	        _this.txt.text = '+' + _this.SCORE;
	        _this.txt.size = 60;
	        _this.txt.fillColor = '#437726';
	        engine.playSound;
	        return _this;
	    }
	    RightTips.prototype.play = function (rect) {
	        if (props.sound) {
	            playSound("rightTipsSound");
	        }
	        this.visible = true;
	        this.txt.x = 100;
	        engine.Tween.get(this.txt).set({ y: 60, alpha: 1 })
	            .to({ y: -50 }, 500)
	            .to({ alpha: 0 });
	        engine.Tween.get(this.img).set({ x: 0, y: 0, scaleX: 0, scaleY: 0, alpha: 1 })
	            .to({ scaleX: 1, scaleY: 1 }, 200, engine.Ease.getBackOut(1))
	            .wait(200)
	            .to({ alpha: 0 }, 300);
	        this.x = rect.x + 180;
	        this.y = rect.y;
	    };
	    return RightTips;
	}(engine.Sprite));
	//# sourceMappingURL=RightTips.js.map

	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this._timeCounter = 0;
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.configUI = function () {
	        var uiMap = {};
	        this.uiMap = uiMap;
	        var config = uiConfig();
	        for (var _i = 0, config_1 = config; _i < config_1.length; _i++) {
	            var item = config_1[_i];
	            var id = item.id, texture = item.texture, pos = item.pos, anchor = item.anchor;
	            var sp = new engine.Sprite(getTextureByName(texture));
	            this.addChild(sp);
	            uiMap[id] = sp;
	            if (anchor) {
	                sp.anchorX = anchor[0];
	                sp.anchorY = anchor[1];
	            }
	            if (pos) {
	                sp.x = pos[0];
	                sp.y = pos[1];
	                if (anchor) {
	                    sp.x = pos[0] - sp.anchorX;
	                    sp.y = pos[1] - sp.anchorY;
	                }
	            }
	        }
	        this.configConveyors();
	        this.createRects();
	        this.countdown = new CountDownGroup();
	        this.addChild(this.countdown);
	        this.guide = new GuideView();
	        this.addChild(this.guide);
	        this.wrongTips = new WrongTips();
	        this.rightTips = new RightTips();
	        this.addChild(this.wrongTips);
	        this.addChild(this.rightTips);
	    };
	    GameView.prototype.createRects = function () {
	        this.wetWaste = this.createRect(104, 565, 252, 297, 0xffffff);
	        this.harmfulWaste = this.createRect(104, 232, 252, 297, 0xff0000);
	        this.dryWaste = this.createRect(403, 232, 252, 297, 0x000000);
	        this.recoverableWaste = this.createRect(403, 565, 252, 297, 0x0000ff);
	    };
	    GameView.prototype.createRect = function (x, y, w, h, c) {
	        var rect = new engine.Rectangle(x, y, w, h);
	        var sp = new engine.Sprite();
	        this.addChild(sp);
	        sp.x = x;
	        sp.y = y;
	        var g = new engine.Graphics;
	        g.alpha = 0.0;
	        g.beginFill(c);
	        g.drawRect(0, 0, w, h);
	        g.endFill();
	        sp.addChild(g);
	        return rect;
	    };
	    GameView.prototype.configConveyors = function () {
	        var conveyor0 = new Conveyor();
	        var conveyor1 = new Conveyor();
	        this.addChild(conveyor0);
	        this.addChild(conveyor1);
	        conveyor0.x = 0;
	        conveyor1.x = 764;
	        this.conveyors = new Conveyors(this);
	        this.conveyors.initData(conveyor0, conveyor1);
	    };
	    GameView.prototype.playAni = function () {
	        var _this = this;
	        var idlerWheels = ['idler0', 'idler1', 'idler2', 'idler3', 'idler4', 'idler5', 'idler6'];
	        idlerWheels = idlerWheels.map(function (i) { return _this.uiMap[i]; });
	        idlerWheels.forEach(function (i) {
	            engine.Tween.get(i, { loop: true }).to({ rotation: -360 }, 1000);
	        });
	    };
	    GameView.prototype.stopAni = function () {
	        var _this = this;
	        var idlerWheels = ['idler0', 'idler1', 'idler2', 'idler3', 'idler4', 'idler5', 'idler6'];
	        idlerWheels = idlerWheels.map(function (i) { return _this.uiMap[i]; });
	        idlerWheels.forEach(function (i) {
	            engine.Tween.removeTweens(i);
	        });
	    };
	    GameView.prototype.start = function () {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var _this = this;
	            return tslib.__generator(this, function (_a) {
	                switch (_a.label) {
	                    case 0:
	                        console.log('on start');
	                        this._timeCounter = 0;
	                        if (!!getGuideInfo()) return [3, 2];
	                        return [4, this.guide.startGuide()];
	                    case 1:
	                        _a.sent();
	                        setGuide();
	                        _a.label = 2;
	                    case 2:
	                        this.conveyors.clear();
	                        return [4, this.countdown.startCountDown()];
	                    case 3:
	                        _a.sent();
	                        this.startGame();
	                        engine.globalEvent.dispatchEvent('recycling-time-update', {
	                            second: this.getSecond(),
	                        });
	                        this._timer = setInterval(function () {
	                            _this.onTimer();
	                        }, 1000);
	                        return [2];
	                }
	            });
	        });
	    };
	    GameView.prototype.startGame = function () {
	        this.playAni();
	        this.conveyors.startConveyors();
	    };
	    GameView.prototype.stopGame = function () {
	        this.stopAni();
	    };
	    GameView.prototype.getSecond = function () {
	        return props.time - this._timeCounter;
	    };
	    GameView.prototype.onTimer = function () {
	        this._timeCounter++;
	        engine.globalEvent.dispatchEvent('recycling-time-update', {
	            second: this.getSecond(),
	        });
	        if (this.getSecond() == 0) {
	            this.stop();
	            this.conveyors.timeout();
	            if (props.sound)
	                playSound("gameOverMp3");
	        }
	    };
	    GameView.prototype.stop = function () {
	        clearInterval(this._timer);
	        this.stopGame();
	    };
	    GameView.prototype.setup = function () {
	        console.log('onSteup', props);
	        this.configUI();
	    };
	    GameView.prototype.onDown = function (e) {
	    };
	    GameView.prototype.stageOnUp = function (e) {
	    };
	    GameView.prototype.onSuccess = function () {
	    };
	    GameView.prototype.onMove = function (e) {
	    };
	    return GameView;
	}(engine.Container));
	//# sourceMappingURL=GameView.js.map

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('recycling-start', _this.start, _this);
	        engine.globalEvent.addEventListener('recycling-sound-update', _this.updateSound, _this);
	        engine.globalEvent.addEventListener('recycling-stop', _this.stop, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        return _this;
	    }
	    GameWrapper.prototype.updateSound = function (event) {
	        injectProps(event.data);
	    };
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	        this._gameView.start();
	    };
	    GameWrapper.prototype.stop = function (event) {
	        this._gameView.stop();
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map