/**
 * Created by renjianfeng on 2020-03-13.
 */

const customId = 'recycling';

(async function() {
    let customModule = await fetch(`../meta.json`);
    customModule = await customModule.json();
    console.log(customModule);

    await loadAssets(customModule.assets);
    launchWithCustomModule(customModule);
})();

function launchWithCustomModule(customModule) {
    //engine.registerCustomCodeModule(customModule);
    engine.registerCustomModule(customId, window[customId]);

    const { props: propsOption, assets } = customModule;
    let props = engine.computeProps(customModuleProps, propsOption);
    const customModuleIns = {
        id: customId,
        props,
        assets,
    };

    engine.registerCustomModules([customModuleIns]);
    engine.launchWithConfig({
        options: {
            entrySceneView: 'entry',
        },
        assets: [],
        views: [{
            name: 'entry',
            type: 'node',
            properties: {
                x: 0,
                y: 0,
            }
        }],
        customs: [],
    }, null, function() {
        setTimeout(() => {
            engine.addCustomModule(customId, engine.gameStage.sceneContainer.getChildAt(0));
        }, 100);

        setTimeout(() => {
            engine.globalEvent.dispatchEvent('recycling-start', { time: 1500, maxScore: 200, speed: 3, sound: 1 });

            const d = engine.gameStage.sceneContainer.getChildAt(0);
        }, 2000);

        // setTimeout(() => {
        //     engine.globalEvent.dispatchEvent('recycling-sound-update', { sound: 1 });

        //     const d = engine.gameStage.sceneContainer.getChildAt(0);
        // }, 10 * 100);

        // setTimeout(() => {
        //     engine.globalEvent.dispatchEvent('recycling-start', { time: 8, maxScore: 2 });

        //     const d = engine.gameStage.sceneContainer.getChildAt(0);
        // }, 1000 * 10);
    });
    engine.globalEvent.addEventListener('recycling-time-update', (e) => {
        console.log(e.type, e.data);
    });
    engine.globalEvent.addEventListener('recycling-score-update', (e) => {
        console.log(e.type, e.data);
    });
    engine.globalEvent.addEventListener('recycling-game-end', (e) => {
        console.log(e.type, e.data);
    });
    engine.globalEvent.addEventListener('recycling-game-success', (e) => {
        console.log(e.type, e.data);
    });
}

function getAssetByUUID(uuid) {
    return engine.resolveCustomAsset(customId, uuid);
}

function getProps() {
    return engine.getProps(customId);
}