(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global.playWithPlane = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	//# sourceMappingURL=utils.js.map

	var Ball = (function (_super) {
	    tslib.__extends(Ball, _super);
	    function Ball() {
	        var _this = _super.call(this) || this;
	        _this.plane = new engine.Sprite();
	        _this.addChild(_this.plane);
	        return _this;
	    }
	    Ball.prototype.setPosition = function () { };
	    Ball.prototype.died = function () { };
	    return Ball;
	}(engine.Container));
	//# sourceMappingURL=Ball.js.map

	var SmallPlane = (function (_super) {
	    tslib.__extends(SmallPlane, _super);
	    function SmallPlane() {
	        var _this = _super.call(this) || this;
	        _this._life = 3;
	        _this.smallPlane = new engine.Sprite(getTexture('57d4067e-c32f-4b12-a8fc-185753726fc6'));
	        _this.life = 3;
	        _this.name = "smallBall";
	        _this.addChild(_this.smallPlane);
	        return _this;
	    }
	    SmallPlane.prototype.setPosition = function () {
	        this.x = Math.random() * (750 - this.width);
	        this.y = Math.random() * (this.height);
	    };
	    SmallPlane.prototype.died = function () {
	    };
	    return SmallPlane;
	}(Ball));
	//# sourceMappingURL=SmallBall.js.map

	var Bullets = (function (_super) {
	    tslib.__extends(Bullets, _super);
	    function Bullets(_harm) {
	        if (_harm === void 0) { _harm = 1; }
	        var _this = _super.call(this) || this;
	        _this.bulletPic = new engine.Sprite(getTexture('18852543-1f1d-498b-af64-88cd3b343758'));
	        _this.bullets = [];
	        _this.harm = _harm;
	        _this.addChild(_this.bulletPic);
	        return _this;
	    }
	    Bullets.prototype.addBullet = function (planeModel) {
	        var bullet = new engine.Sprite(getTexture('18852543-1f1d-498b-af64-88cd3b343758'));
	        bullet.x = planeModel ? planeModel.x + planeModel.width / 2 - bullet.width / 2 : 375 - bullet.width / 2;
	        bullet.y = 1150;
	        return bullet;
	    };
	    Bullets.prototype.createBullet = function (planeModel) {
	        this.x = planeModel.x + planeModel.width / 2 - this.bulletPic.width / 2;
	        this.y = 1150;
	    };
	    Bullets.prototype.addBulletNum = function (w) {
	    };
	    return Bullets;
	}(engine.Container));
	//# sourceMappingURL=Bullets.js.map

	var TestView = (function (_super) {
	    tslib.__extends(TestView, _super);
	    function TestView() {
	        var _this = _super.call(this) || this;
	        _this.planeArray = [
	            {
	                type: 'smallBall',
	                enemyPlane: []
	            },
	            {
	                type: 'middleBall',
	                enemyPlane: []
	            },
	            {
	                type: 'largeBall',
	                enemyPlane: []
	            }
	        ];
	        _this.bulletArray = [];
	        _this.score = 0;
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    TestView.prototype.setup = function () {
	        this.stageBg = new engine.Sprite(getTexture('308742a0-0ea2-4610-b34a-a230add82021'));
	        this.addChild(this.stageBg);
	        this.gameBg = new engine.Sprite(getTexture('76820072-df5a-4ab7-8cb7-10c8cd8605c8'));
	        this.startBtn = new engine.Sprite(getTexture('855e3d77-ffff-443d-b884-4f67a2ebe458'));
	        this.startBtn.x = (750 - this.startBtn.width) / 2;
	        this.startBtn.y = (this.stage.height - this.startBtn.height) / 2 + 300;
	        this.stageBg.addChild(this.startBtn);
	        this.startBtn.addEventListener(engine.MouseEvent.CLICK, this.onClick, this);
	    };
	    TestView.prototype.start = function () {
	        var _this = this;
	        this.planeModel = new engine.Sprite(getTexture('32ec481a-3f75-4c36-95ed-ee97aa936517'));
	        this.planeModel.x = (750 - this.planeModel.width) / 2;
	        this.planeModel.y = (this.stage.height - this.planeModel.height);
	        this.planeModel.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onDown, this);
	        this.gameBg.addChild(this.planeModel);
	        var boom = new engine.Sprite(getTexture('38ec6627-efa8-4f7a-9bdc-3c73cea717f1'));
	        setInterval(function () {
	            var smallBall = new SmallPlane();
	            smallBall.setPosition();
	            console.log(_this.planeArray);
	            for (var _i = 0, _a = _this.planeArray; _i < _a.length; _i++) {
	                var planearray = _a[_i];
	                if (planearray.type == smallBall.name) {
	                    console.log(planearray.enemyPlane);
	                    planearray.enemyPlane.push(smallBall);
	                }
	            }
	            _this.gameBg.addChild(smallBall);
	        }, 500);
	        setInterval(function () {
	            for (var _i = 0, _a = _this.planeArray; _i < _a.length; _i++) {
	                var planearray = _a[_i];
	                if (planearray.type === 'smallBall') {
	                    var _loop_1 = function (sball) {
	                        console.log(sball);
	                        sball.y += 1;
	                        if (sball.y > _this.stage.height) {
	                            _this.gameBg.removeChild(sball);
	                            var index_1 = planearray.enemyPlane.indexOf(sball);
	                            planearray.enemyPlane = planearray.enemyPlane.filter(function (ele, i) { return i != index_1; });
	                        }
	                    };
	                    for (var _b = 0, _c = planearray.enemyPlane; _b < _c.length; _b++) {
	                        var sball = _c[_b];
	                        _loop_1(sball);
	                    }
	                }
	            }
	        }, 16);
	        setInterval(function () {
	            var bullet = new Bullets();
	            bullet.createBullet(_this.planeModel);
	            _this.bulletArray.push(bullet);
	            _this.gameBg.addChild(bullet);
	        }, 40);
	        setInterval(function () {
	            console.log(_this.score);
	            var _loop_2 = function (bullet) {
	                bullet.y -= 35;
	                if (bullet.y < -40) {
	                    _this.gameBg.removeChild(bullet);
	                    var index_2 = _this.bulletArray.indexOf(bullet);
	                    _this.bulletArray = _this.bulletArray.filter(function (ele, i) { return i != index_2; });
	                }
	                for (var _i = 0, _a = _this.planeArray; _i < _a.length; _i++) {
	                    var planearray = _a[_i];
	                    if (planearray.type === 'smallBall') {
	                        var _loop_3 = function (splane) {
	                            var y = bullet.y - splane.y;
	                            var bulletRight = bullet.x + bullet.width;
	                            var planeRange = splane.x + splane.width;
	                            if (bulletRight > splane.x && bulletRight < planeRange || bullet.x > splane.x && bullet.x < planeRange) {
	                                if (y <= 0) {
	                                    splane.life -= bullet.harm;
	                                    _this.score += bullet.harm;
	                                    _this.gameBg.removeChild(bullet);
	                                    var index_3 = _this.bulletArray.indexOf(bullet);
	                                    _this.bulletArray = _this.bulletArray.filter(function (ele, i) { return i != index_3; });
	                                    if (splane.life === 0) {
	                                        _this.gameBg.removeChild(splane);
	                                        var ind_1 = planearray.enemyPlane.indexOf(splane);
	                                        planearray.enemyPlane = planearray.enemyPlane.filter(function (ele, i) { return i != ind_1; });
	                                        boom.x = splane.x;
	                                        boom.y = splane.y;
	                                        _this.gameBg.addChild(boom);
	                                        setTimeout(function () {
	                                            _this.gameBg.removeChild(boom);
	                                        }, 1500);
	                                    }
	                                }
	                            }
	                        };
	                        for (var _b = 0, _c = planearray.enemyPlane; _b < _c.length; _b++) {
	                            var splane = _c[_b];
	                            _loop_3(splane);
	                        }
	                    }
	                }
	            };
	            for (var _i = 0, _a = _this.bulletArray; _i < _a.length; _i++) {
	                var bullet = _a[_i];
	                _loop_2(bullet);
	            }
	        }, 16);
	    };
	    TestView.prototype.onClick = function () {
	        this.addChild(this.gameBg);
	        this.gameBg.addChild(this.planeModel);
	    };
	    TestView.prototype.onDown = function (e) {
	        this.mouseX = e.localX;
	        this.mouseY = e.localY;
	        this.stage.addEventListener(engine.MouseEvent.MOUSE_MOVE, this.onMove, this);
	        this.planeModel.x = e.stageX - this.mouseX;
	        this.planeCenterX = this.planeModel.x + this.planeModel.width / 2;
	    };
	    TestView.prototype.onMove = function (e) {
	        this.centerX = this.planeModel.width / 2;
	        var movedCenter = this.centerX + e.stageX - this.mouseX;
	        if (movedCenter < 0) {
	            this.planeModel.x = -this.centerX;
	        }
	        else if (movedCenter > 750) {
	            this.planeModel.x = 750 - this.centerX;
	        }
	        else {
	            this.planeModel.x = e.stageX - this.mouseX;
	            this.planeCenterX = this.planeModel.x + this.planeModel.width / 2;
	        }
	    };
	    TestView.prototype.stop = function () {
	    };
	    return TestView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('pictures-start', _this.start, _this);
	        engine.globalEvent.addEventListener('pictures-stop', _this.stop, _this);
	        var testView = _this._testView = new TestView();
	        _this.addChild(testView);
	        return _this;
	    }
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	        this._testView.start();
	    };
	    GameWrapper.prototype.stop = function (event) {
	        this._testView.stop();
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map