/**
 * Created by rockyl on 2020-01-21.
 */

export function getTexture(uuid) {
	return engine.Texture.from(getAssetByUUID(uuid).uuid);
}

export function getTextureByName(name) {
	return getTexture(engine.getAssetByName(name).uuid);
}

export function playSound(name) {
	engine.playSound(engine.getAssetByName(name).uuid, {keep: true});
}
export function createSvga(name, anchorName?) {
	let inst = new svga.Svga();
	inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	return inst;
}

export function getIndexFromRC(row,col,maxCol){
	let index;
	index = row * maxCol + col ;
	return index
}

export function getCenterPos(target){
	var x = target.x + target.width>>1;
	var y = target.y + target.height>>1;
	return {x:x,y:y};
}


export function getRandomArray(array){
	array.sort(function() {
		return .5 - Math.random();
	});
}

export function rectCollsion(x1:number,y1:number,x2:number,y2:number,w1:number,h1:number,w2:number,h2:number){
	var p1 = x1+w1*0.5;
	var p2 = y1+h1*0.5;
	var p3 = x2+w2*0.5;
	var p4 = y2+h2*0.5; 
	if((Math.abs(p1-p3)<=(w1+w2)*0.5)&&(Math.abs(p2-p4)<=(h1+h2)*0.5)){
		return true;
	}
	return false;
}

/**向量单位化 */
export function vectorUnit(x:number,y:number){
	var vector = new engine.Point(x,y);
	vector.x = x/Math.sqrt(x*x+y*y);
	vector.y = y/Math.sqrt(x*x+y*y);
	return vector;
}

export function getPoint(r: number, ox: number, oy: number, count: number) {
	var p:any[]=[];
    let radians = (Math.PI / 180) * Math.round(360 / count); //弧度
    for (let i: number = 0; i < count; i++) {
        let x = ox + r * Math.sin(radians * i);
        let y = oy + r * Math.cos(radians * i);
        p.unshift({ x: x, y: y }); //为保持数据顺时针
	}
	return p
}