import { BaseEnemyBullet } from "./BaseEnemyBullet";

export class SwordBullet extends BaseEnemyBullet{
    constructor(x:number,y:number,speed:number,vector:engine.Point){
        super();
        this.x = x;
        this.y = y;
        this.speedVector = vector;
        this.speedX = this.speedY = speed;
        this.rotation = Math.atan2(vector.y,vector.x)*180/Math.PI-90;
        // Math.cos(any) = vector.x;
        // Math.sin(any)
    }

    addToViewPort(){
        super.addToViewPort();
        this.setBodyImg("2c7a1136-4ea6-4fdd-be1d-b7f740a79198");
        this.bodyImg.x = -this.bodyImg.width>>1;
    }

    updateSelf(){
        super.updateSelf();
    }
}