import { BaseEnemy, enemyType } from "./BaseEnemy";

export class Rotary extends BaseEnemy{
    constructor(){
        super();
    }

    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.setBody("febdb55f-f8c3-4a73-829c-d7acf882203b");
        that.bodyImg.anchorX = that.bodyImg.width*0.5;
        that.bodyImg.anchorY = that.bodyImg.height*0.5;
        that.hitW = 50;
        that.hitH = 50;
        that.health = 10;
        that.speedVector.y = 1;
        that.speedY = 3;
        that.y = -50;
        that.x = Math.floor(Math.random()*engine.gameStage.width/4*2+engine.gameStage.width/4);
        that.enemyType = enemyType.normal;
    }

    updateSelf(){
        this.bodyImg.rotation += 5;
        super.updateSelf();
        this.worldTime++;
        if(this.worldTime%70 == 0){
            this.worldTime = 0;
            this.createFourSideShot();
        }
    }
}