import { BaseEnemy, enemyState, enemyType } from "./BaseEnemy";

export class PurpleBoss extends BaseEnemy{
    constructor(){
        super();
    }

    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.setBody("b63d73e2-d7c8-4ad0-84a5-317194cdc8bf");
        that.hitW = 318;
        that.hitH = 104;
        that.health = 800;
        that.x = engine.gameStage.width*0.5 - that.bodyImg.width*0.5;
        that.y = -that.bodyImg.height;
        that.curSkillMax = 2;
        that.enemyType = enemyType.boss;
        that.changeState(enemyState.goStage);
    }

    updateSelf(){
        super.updateSelf();
        var that = this;
        switch(that.enemyState){
            case enemyState.goStage:
                if(that.y>=(that.bodyImg.height*0.5)){
                    that.changeState(enemyState.inSatge);
                }
                break;
            case enemyState.inSatge:
                that.worldTime++;
                that.horizonBounds();
                if(that.worldTime%90==0){
                    that.changeState(enemyState.attack);
                }
                break;
            case enemyState.attack:
                that.horizonBounds();
                switch(that.curSkillIndex){
                    case 0:
                        that.createSpiralShot();
                        break;
                    case 1:
                        that.createLaser(48);
                        break;
                    case 2:
                        that.createGrapeshot();
                        break;
                }
                break;
        }
    }

    changeState(state:enemyState){
        var that = this;
        switch(state){
            case enemyState.goStage:
                that.bossSetGoStage();
                break;
            case enemyState.inSatge:
                that.bossSetInStage();
                break;
            case enemyState.attack:
                that.attackState();
                break;
        }
        that.enemyState = state;
    }
}