import { TotleManager } from "../Manager/TotleManager";
import { BaseEnemyBullet } from "./BaseEnemyBullet";
import { getPoint, vectorUnit } from "../utils";
import { LayerManager } from "../Manager/LayerManager";
import { DartBullet } from "./DartBullet";


export class ExplosionBullet extends BaseEnemyBullet{
    type:number = 0;
    targetPoint:engine.Point = null;
    constructor(x:number,y:number,vector:engine.Point,speed:number,type:number=1,targetPoint:engine.Point){
        super();
        this.x = x;
        this.y = y;
        this.speedVector = vector;
        this.type = type;
        this.speedX = this.speedY = speed;
        this.targetPoint = targetPoint;
    }

    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.setBodyImg("e06a8cd4-81f9-4ed9-bc6f-ff8a964bf0a6");
        that.bodyImg.x = -that.bodyImg.width>>1;
        that.bodyImg.y = -that.bodyImg.height>>1;
        // if(this.type!=1){
        //     var random = Math.random();
        //     that.targetPoint = new engine.Point();
        //     that.targetPoint.y = engine.gameStage.height>>1;
        //     if(random<=0.5){
        //         that.targetPoint.x = engine.gameStage.width/3;
        //     }else{
        //         that.targetPoint.x = engine.gameStage.width*0.75;
        //     }
        if(this.targetPoint)
            that.speedVector = vectorUnit(that.targetPoint.x-that.x,that.targetPoint.y-that.y);
        // }
    }
    
    updateSelf(){
        var that = this;
        switch(that.type){
            case 1:
                that.x += that.speedVector.x*that.speedX;
                that.y += that.speedVector.y*that.speedY;
                break;
            case 2:
                that.x += that.speedVector.x*that.speedX;
                that.y += that.speedVector.y*that.speedY;
                if(Math.abs(that.targetPoint.x-that.x)<=that.speedX&&Math.abs(that.targetPoint.y-that.y)<=that.speedY){
                    that.type = 3;
                }
                break;
            case 3:
                that.worldTime++;
                if(that.worldTime%14==0){
                    this.type = 4;
                    this.splitBullet();
                    this.visible = false;
                    this.removeSelf();
                }
                break;
        }
        that.boundsJudge();
        that.playerCollsion();
    }

    splitBullet(){
        var posArr = getPoint(30,this.x,this.y,12);
        for(var i=0;i<posArr.length;i++){
            var vector = vectorUnit(posArr[i].x-this.x,posArr[i].y-this.y);
            window["EnemyBulletManager"].createBullet(null,LayerManager.Ins.bulletLayer,posArr[i].x,posArr[i].y,1,4,vector,2);
        }
    }
}