import { BaseEnemyBullet } from "./BaseEnemyBullet";
import { getTexture } from "../utils";
export class DartBullet extends BaseEnemyBullet{
    constructor(x:number,y:number,speed:number,vector:engine.Point){
        super();
        this.x = x;
        this.y = y;
        this.speedX = this.speedY = speed;
        this.speedVector = vector;
    }

    addToViewPort(){
        super.addToViewPort();
        this.bodyImg.texture = getTexture("8c18a621-f3dc-4f2d-a31a-5f1d8a3f1158");
        this.bodyImg.x = -this.bodyImg.width>>1;
        this.bodyImg.y = -this.bodyImg.height>>1;
    }

    updateSelf(){
        this.rotation+=5;
        super.updateSelf();
    }
}
