import { BaseEnemy, enemyType } from "./BaseEnemy";

export class Blue extends BaseEnemy{
    dir:number;
    constructor(x:number,y:number,dir:number){
        super();
        this.x = x;
        this.y = y;
        this.dir = dir;
    }

    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.setBody("3729397b-a35a-47ce-9406-7f72f14c2513");
        that.bodyImg.anchorX = that.bodyImg.width*0.5;
        that.bodyImg.anchorY = that.bodyImg.height*0.5;
        that.hitW = 70;
        that.hitH = 40;
        that.health = 10;
        that.enemyType = enemyType.normal;
        if(that.dir<0){     //从左边飞出
            that.bodyImg.rotation = -90;
            that.speedX = 12;
            that.speedVector.x = 1;
            that.speedY = 8
        }else{      //从右边飞出
            that.bodyImg.rotation = 90;
            that.speedX = 12;
            that.speedVector.x = -1;
            that.speedY = 8;
        }
    }

    updateSelf(){
        var that = this;
        super.updateSelf();
        
        if(that.dir<0){
            if(that.x>=engine.gameStage.width*3/4){
                that.speedVector.x = 0;
            }
            if(that.x>(engine.gameStage.width/4-50)){
                if(that.bodyImg.rotation<0)
                    that.bodyImg.rotation += 2.5;
                else
                    that.bodyImg.rotation = 0;
                that.speedVector.y = 1;
            }
        }else{
            if(that.x<=(engine.gameStage.width/4-50)){
                that.speedVector.x = 0;
            }
            if(that.x<engine.gameStage.width*3/4){
                if(that.bodyImg.rotation>0)
                    that.bodyImg.rotation -= 2.5;
                else
                    that.bodyImg.rotation = 0;
                that.speedVector.y = 1;
            }
        }
    }
}