import { BaseSprite } from "../BaseSprite";
import { EnemyBulletManager } from "../Manager/EnemyBulletManager";
import { getTexture, rectCollsion } from "../utils";
import { GameManager } from "../Manager/GameManager";

export class BaseEnemyBullet extends BaseSprite{
    speedX:number;
    speedY:number;
    speedVector:engine.Point;
    bodyImg:engine.Image;
    damageValue:number;
    hitW:number;
    hitH:number;
    manager:EnemyBulletManager
    isRemove:boolean = false;
    worldTime:number = 0;
    constructor(){
        super();
    }

    addToViewPort(){
        super.addToViewPort();
        this.bodyImg = new engine.Image();
        this.addChild(this.bodyImg);
    }

    updateSelf(){
        var that = this;
        that.x += that.speedX*that.speedVector.x;
        that.y += that.speedY*that.speedVector.y;
        that.boundsJudge();
        that.playerCollsion();
    }

    setBodyImg(uuid){
        this.bodyImg.texture = getTexture(uuid);
    }

    removeSelf(){
        window["EnemyBulletManager"].arrRemove(this);
    }

    /**判断边界 */
    boundsJudge(){
        if((this.x<=-this.bodyImg.width*0.5)||(this.x>=(engine.gameStage.width+this.bodyImg.width*0.5))||(this.y<=-this.bodyImg.height*0.5)||(this.y>=(engine.gameStage.height+this.bodyImg.height*0.5)))
        {
            this.removeSelf();
        }
    }

    playerCollsion(){
        var player = GameManager.INS.playerPlane;
        var x1 = player.getCenterP().x;
        var y1 = player.getCenterP().y;
        var pos = this.localToGlobal(new engine.Point(0,0))
        var x2 = pos.x;
        var y2 = pos.y;
        var w1 = player.hitW;
        var h1 = player.hitH;
        var w2 = this.bodyImg.width;
        var h2 = this.bodyImg.height;
        if(rectCollsion(x1,y1,x2,y2,w1,h1,w2,h2)){
            player.hitDamage(1);
        }
    }
}