import {getTexture} from './utils'
import {props} from "../props";
import {PlayerPlane} from "./PlayerPlane"
import { EnemyManager } from './Manager/EnemyManager';
import { LayerManager } from './Manager/LayerManager';
import { GameManager } from './Manager/GameManager';
import { EnemyBulletManager } from './Manager/EnemyBulletManager';

export default class TestView extends engine.Container{
    playerPlane:PlayerPlane;
    offsetX:number;
    offsetY:number;
    canMove:boolean = false;
    stageW:number;
    stageH:number;
    bgArr:engine.Image[] = [];
    bgMove:boolean = true;
    bgMoveSpeed = 8;
    injuredImg:engine.Image = null;
    imgFlashCount:number = 0;
    bossDead:boolean = true;
    worldTime:number = 0;
    bossCnt:number = 1;
    bossMaxCnt:number = 5;

    constructor(){
        super()
        this.addEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
    }

    setup(){
        var that = this;
        that.removeEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
        that.stageW = engine.gameStage.width;
        that.stageH = engine.gameStage.height;
        that.setLayer();
        that.setBg();
        that.playerPlane = new PlayerPlane();
        that.playerPlane.x = that.stageW - that.playerPlane.width>>1;
        that.playerPlane.y = that.stageH - 200;
        LayerManager.Ins.playerLayer.addChild(that.playerPlane);
        that.playerPlane.setView(that);
        that.playerPlane.canShootF(true);
        GameManager.INS.playerPlane = that.playerPlane;
        that.addEvent();
        EnemyBulletManager.Ins;
        EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer,10);
        GameManager.INS.createUserHealth(LayerManager.Ins.uiLayer,60,60);
        GameManager.INS.createBoomBtn(LayerManager.Ins.uiLayer,engine.gameStage.width-120,engine.gameStage.height-200)
        that.injuredImg = new engine.Image(getTexture("3e931ea3-ad7a-4751-b042-108744d8fcdd"));
        LayerManager.Ins.uiLayer.addChild(that.injuredImg);
        that.injuredImg.visible = false;
        that.injuredImg.alpha = 0.2;
    }

    /**设置层级 */
    setLayer(){
        LayerManager.Ins.initLayer(this);
    }

    setBg(){
        for(var i=0;i<2;i++){
            var bg = new engine.Image(getTexture("f25a0b83-e351-454f-b178-2741a36e58b6"));
            LayerManager.Ins.bgLayer.addChild(bg);
            bg.x = 0;
            bg.y = -1624+i*1624;
            this.bgArr.push(bg);
        }
    }

    addEvent(){
        var that = this;
        engine.gameStage.stage.addEventListener(engine.MouseEvent.MOUSE_DOWN,that.touchDown,that);
        engine.gameStage.stage.addEventListener(engine.MouseEvent.MOUSE_MOVE,that.touchMove,that);
        engine.gameStage.stage.addEventListener(engine.MouseEvent.MOUSE_UP,that.touchUp,that);
        // that.addEventListener(engine.Event.ENTER_FRAME,that.updateGame,that);
        setInterval(()=>{
            that.updateGame();
        },1000/60);
        engine.globalEvent.addEventListener("playerInjured",()=>{
            that.injuredImg.visible = true;
            engine.Tween.get(that.injuredImg,{loop:true}).to({alpha:1},100).to({alpha:0.2},100).call(()=>{
                that.imgFlashCount++;
                if(that.imgFlashCount>=3){
                    that.imgFlashCount = 0;
                    that.injuredImg.visible = false
                    engine.Tween.removeTweens(that.injuredImg);
                }
            },this)
        },this)
        engine.globalEvent.addEventListener("bossDead",()=>{
            that.bossDead = true;
        },that);
    }

    updateGame(){
        var that = this;
        if(that.playerPlane){
            that.playerPlane.updateSelf();
        }
        EnemyManager.Ins.updateEnemy();
        EnemyBulletManager.Ins.updateEnemyBullet();
        GameManager.INS.updateGame();

        if(that.bgMove){
            for(var i=0;i<that.bgArr.length;i++){
                that.bgArr[i].y += that.bgMoveSpeed;
                if(that.bgArr[i].y>=1624){
                    that.bgArr[i].y = -1624;
                }
            }
        }
        if(that.bossCnt<=that.bossMaxCnt){
            if(that.bossDead){
                that.worldTime ++ ;
                if(that.worldTime%150 == 0){
                    EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer,that.bossCnt);
                    that.bossCnt ++;
                    that.bossDead = false;
                    that.worldTime = 0;
                    if(that.bossCnt>that.bossMaxCnt){
                        
                    }
                }
            }
        }else{
            that.worldTime++;
            if(that.worldTime%80 == 0){
                if(EnemyManager.Ins.enemyArr.length<12)
                    EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer,Math.floor(Math.random()*5+6));
                that.worldTime = 0;
            }
        }
        
    }

    /**用户触摸按下 */
    touchDown(e:engine.MouseEvent){
        this.offsetX = e.stageX - this.playerPlane.x;
        this.offsetY = e.stageY - this.playerPlane.y;
        this.canMove = true;
    }

    /**用户触摸移动 */
    touchMove(e:engine.MouseEvent){
        if(!this.canMove) return;
        var x = e.stageX - this.offsetX;
        var y = e.stageY - this.offsetY;
        this.playerPlane.move(x,y);
    }

    /**用户触摸抬起 */
    touchUp(){
        this.canMove = false;
    }
}