import {getTexture} from './utils'
import {getCenterPos} from './utils'
import { BaseSprite } from './BaseSprite'
import { PlayerBullet } from './PlayerBullet';
import {rectCollsion} from "./utils";
import TestView from './TestView';
import { EnemyManager } from './Manager/EnemyManager';
import { LayerManager } from './Manager/LayerManager';
import { GameManager } from './Manager/GameManager';

export class PlayerPlane extends BaseSprite
{
    planeImg:engine.Image;
    canShoot:boolean = false;
    bulletPool:PlayerBullet[] = [];
    bulletArr:PlayerBullet[] = [];
    maxBulletCount:number = 500;
    curFireLevel:number = 1;
    maxFireLevel:number = 4;
    view:TestView;
    canDamaged:boolean = true;
    damageFlashCount:number = 0;
    hitW:number = 0;
    hitH:number = 0;
    bulletDamage:number = 1;

    constructor(){
        super();
        this.init();
    }

    init(){
        for(var i=0;i<this.maxBulletCount;i++){
            var bullet = new PlayerBullet();
            this.bulletPool.push(bullet);
        }
        this.hitW = 80;
        this.hitH = 80;
    }

    addToViewPort(){
        super.addToViewPort();
        this.planeImg = new engine.Image(getTexture("d3794d48-e936-4829-80d9-fdc81b678b9f"));
        this.addChild(this.planeImg);
        this.shoot();
    }

    fireLevelUp(value:number){
        var that = this;
        if((that.curFireLevel+value)>=that.maxFireLevel){
            that.curFireLevel = that.maxFireLevel;
        }else{
            that.curFireLevel += value;
        }
    }

    updateSelf(){
        var that = this;
        for(var i=0;i<that.bulletArr.length;i++){
            var bullet = that.bulletArr[i];
            if(bullet){
                bullet.y += bullet.speedY;
                if(bullet.y<=-15){
                    bullet.parent.removeChild(bullet);
                    that.bulletPool.push(bullet);
                    that.bulletArr.splice(i,1);
                    i--;
                    continue;
                }
                for(var j=0;j<EnemyManager.Ins.enemyArr.length;j++){
                    var enemy = EnemyManager.Ins.enemyArr[j];
                    if(enemy){
                        if(rectCollsion(bullet.x,bullet.y,enemy.x,enemy.y,bullet.width,bullet.height,enemy.hitW,enemy.hitH)){
                            console.log("打到了");
                            enemy.damageHit(that.bulletDamage);
                            bullet.parent.removeChild(bullet);
                            that.bulletPool.push(bullet);
                            that.bulletArr.splice(i,1);
                            i--;
                            break;
                        }
                    }
                }
                
            }
        }
    }

    move(x:number,y:number){
        var that = this;
        var stageW = engine.gameStage.width;
        var stageH = engine.gameStage.height;
        if(x>=(stageW-that.planeImg.width)){
            that.x = stageW -that.planeImg.width;
        }else if(x<=0){
            that.x = 0;
        }else{
            that.x = x;
        }
        if(y<=200){
            that.y = 200;
        }else if(y>=(stageH-100)){
            that.y = stageH-100;
        }else{
            that.y = y;
        }
    }

    setView(view){
        this.view = view;
    }


    canShootF(value:boolean){
        this.canShoot = value;
    }

    shoot(){
        var that = this;
        setInterval(()=>{
            if(!that.canShoot)return;
            switch(that.curFireLevel){
                case 1:
                var bullet = that.bulletPool.pop()
                LayerManager.Ins.bulletLayer.addChild(bullet);
                that.bulletArr.push(bullet);
                bullet.x = that.x+that.planeImg.width*0.5-bullet.width*0.5;
                bullet.y = that.y;
                break;
                case 2:
                for(var i=0;i<2;i++){
                var bullet = that.bulletPool.pop()
                LayerManager.Ins.bulletLayer.addChild(bullet);
                that.bulletArr.push(bullet);
                bullet.x = that.x+that.planeImg.width*0.5-bullet.width*0.5-15+i*30;
                bullet.y = that.y;
                }    
                break;
                case 3:
                for(var i=0;i<3;i++){
                var bullet = that.bulletPool.pop()
                LayerManager.Ins.bulletLayer.addChild(bullet);
                that.bulletArr.push(bullet);
                bullet.x = that.x+that.planeImg.width*0.5-bullet.width*0.5-15+i*15;
                bullet.y = that.y;
                if(i==1){
                bullet.y = that.y-10;
                }
                }    
                break;
                case 4:
                for(var i=0;i<5;i++){
                var bullet = that.bulletPool.pop()
                LayerManager.Ins.bulletLayer.addChild(bullet);
                that.bulletArr.push(bullet);
                bullet.x = that.x+that.planeImg.width*0.5-bullet.width*0.5-30+i*15;
                if(i==0||i==4){
                bullet.y = that.y
                }else if(i==1||i==3){
                bullet.y = that.y - 10;
                }else{
                bullet.y = that.y - 20;
                }
                }
                break;
            }
        },100)
    }

    getCenterP(){
        var x = this.x + this.planeImg.width*0.5;
        var y = this.y + this.planeImg.height*0.5;
        return {x:x,y:y};
    }

    hitDamage(value:number){
        if(!this.canDamaged) return;
        var that = this;
        console.log("玩家被攻击到")
        that.canDamaged = false;
        GameManager.INS.userHealth.reduceHealth(1);
        engine.globalEvent.dispatchEvent("playerInjured");
        engine.Tween.get(that,{loop:true}).to({alpha:0.2},200).to({alpha:1},200).call(()=>{
            that.damageFlashCount++;
            if(that.damageFlashCount>=4){
                that.canDamaged = true;
                that.damageFlashCount = 0;
                engine.Tween.removeTweens(that);
            }
        })
    }
}