import { PlayerPlane } from "../PlayerPlane";
import { UserHealth } from "../UserHealth";
import { Buff, buffType } from "../Buff/Buff";
import { ClearUpBtn } from "../ClearUpBtn";

export class GameManager{
    private static _ins:GameManager = null;
    static get INS(){
        if(!this._ins){
            this._ins = new GameManager();
        }
        return this._ins;
    }

    playerPlane:PlayerPlane = null;
    userHealth:UserHealth = null;
    boomBtn:ClearUpBtn = null;
    buffArr:Buff[] = [];

    constructor(){
        window["GameManager"] = this;
    }

    /**添加玩家生命值ui */
    createUserHealth(view:engine.Container,x:number,y:number){
        if(this.userHealth){
            this.userHealth.parent.removeChild(this.userHealth);
            this.userHealth = null;
        }
        this.userHealth = new UserHealth(x,y);
        view.addChild(this.userHealth);
    }

    /**添加原子弹按钮ui */
    createBoomBtn(view:engine.Container,x:number,y:number){
        if(this.boomBtn){
            this.boomBtn.parent.removeChild(this.boomBtn);
            this.boomBtn = null;
        }
        this.boomBtn = new ClearUpBtn();
        this.boomBtn.x = x;
        this.boomBtn.y = y;
        view.addChild(this.boomBtn);
    }

    /**添加buff */
    createBuff(view:engine.Container,x:number,y:number,buffType:buffType){
        var buff = new Buff(x,y,buffType,this.playerPlane);
        view.addChild(buff);
        this.buffArr.push(buff);
    }

    updateGame(){
        for(var i=0;i<this.buffArr.length;i++){
            if(this.buffArr[i])
                this.buffArr[i].updateSelf();
        }
    }

    buffArrRemove(obj){
        if(obj&&obj.parent){
            obj.parent.removeChild(obj);
        }
        var index = this.buffArr.indexOf(obj);
        if(index>=0){
            this.buffArr.splice(index,1);
        }
    }
}