import { BaseEnemy } from "../enemy/BaseEnemy";
import { BuleBoss } from "../enemy/BlueBoss";
import { ThreeBallsBoss } from "../enemy/ThreeBallsBoss";
import { GreenBoss } from "../enemy/GreenBoss";
import { RedBoss } from "../enemy/RedBoss";
import { PurpleBoss } from "../enemy/PurpleBoss";
import { Small } from "../enemy/Small";
import { Blue } from "../enemy/Blue";
import { Green } from "../enemy/Green";
import { Rotary } from "../enemy/Rotary";
import { Mazarine } from "../enemy/Mazarine";

export class EnemyManager
{
    private static _ins:EnemyManager = null;
    static get Ins(){
        if(!this._ins){
            this._ins = new EnemyManager();
        }
        return this._ins;
    }

    constructor(){
        window["EnemyManager"] = this;
        // engine.globalEvent.addEventListener("enemyRemove",this.enemyArrRemove.bind(this),this)
    }
    enemyArr:BaseEnemy[] = [];
    

    enemyArrRemove(e){
        let obj = e.data;
        // console.log("1111",obj);
        var index = this.enemyArr.indexOf(obj);
        if(index>=0){
            this.enemyArr.splice(index,1);
        }
        if(obj&&obj.parent){
            obj.parent.removeChild(obj);
        }
    }

    /**创建敌人，1-5是5个boss */
    enemyCreate(view:engine.Container,type:number){
        var enemy:BaseEnemy;
        var canAdd:boolean = true;
        switch(type){
            case 1:
                enemy = new BuleBoss(); //蓝色BOSS
                break;
            case 2:
                enemy = new ThreeBallsBoss();   //三个球BOSS
                break;
            case 3:
                enemy = new GreenBoss();    //绿色BOSS
                break;
            case 4:
                enemy = new RedBoss();  //红色BOSS
                break;
            case 5:
                enemy = new PurpleBoss();   //紫色BOSS
                break;
            case 6:
                canAdd = false;
                var x1 = Math.floor(Math.random()*engine.gameStage.width/4*2+engine.gameStage.width/4);
                for(let i=0;i<4;i++){   //四个红色小飞机
                    let y = -60 - i*80;
                    let enemy = new Small(x1,y);
                    this.enemyArr.push(enemy);
                    view.addChild(enemy)
                }
                break;
            case 7:
                canAdd = false;
                var y = 300;
                var dir:number = 0;
                var originX:number = 0;
                if(Math.random()>0.5){
                    dir = -1;
                    originX = -100;
                }else{
                    dir = 1;
                    originX = engine.gameStage.width+45;
                }
                for(let i=0;i<4;i++){       //四个蓝色小飞机
                    let x = originX + dir*i*140;
                    enemy = new Blue(x,y,dir);
                    view.addChild(enemy);
                    this.enemyArr.push(enemy);
                }
                break;
            case 8:
                enemy = new Green();    //绿色小飞机
                break;
            case 9:
                enemy = new Rotary();   //旋转小飞机
                break;
            case 10:
                enemy = new Mazarine(); //mazarine小飞机
                break;
        }
        if(canAdd){
            this.enemyArr.push(enemy);
            view.addChild(enemy);
            return enemy;
        }
    }

    /**敌人更新 */
    updateEnemy(){
        for(var i=0;i<this.enemyArr.length;i++){
            if(this.enemyArr[i]&&!this.enemyArr[i].isDead){
                this.enemyArr[i].updateSelf();
            }
        }
    }
}