import { BaseEnemyBullet } from "../enemy/BaseEnemyBullet";
import { DartBullet } from "../enemy/DartBullet";
import { Laser } from "../enemy/Laser";
import { ExplosionBullet } from "../enemy/ExplosionBullet";
import { BaseEnemy } from "../enemy/BaseEnemy";
import { SwordBullet } from "../enemy/SwordBullet";
import { SmallBullet } from "../enemy/SmallBullet";

export class EnemyBulletManager{
    private static _ins:EnemyBulletManager = null;
    static get Ins(){
        if(!this._ins){
            this._ins = new EnemyBulletManager();
        }
        return this._ins;
    }

    constructor(){
        window["EnemyBulletManager"] = this;
    }
    
    bulletArr:BaseEnemyBullet[] = [];
    createBullet(enemy:BaseEnemy,view:engine.Container,x:number,y:number,type:number,speed?:number,vector?:engine.Point,type1:number=1,targtPoint?:engine.Point,call?:Function,args?:any){
        var bullet;
        switch(type){
            case 1:
                bullet = new DartBullet(x,y,speed,vector);
                break;
            case 2:
                bullet = new Laser(enemy,x,y,call,args,type1);
                break;
            case 3:
                bullet = new ExplosionBullet(x,y,vector,speed,type1,targtPoint);
                break;
            case 4:
                bullet = new SwordBullet(x,y,speed,vector);
                break;
            case 5:
                bullet = new SmallBullet(x,y,speed,vector);
                break;
        }
        this.bulletArr.push(bullet);
        view.addChild(bullet);
        return bullet;
    }

    /**从数组删除子弹 */
    arrRemove(obj){
        var index = this.bulletArr.indexOf(obj);
        if(index>=0){
            this.bulletArr.splice(index,1);
        }
        if(obj&&obj.parent){
            obj.parent.removeChild(obj);
        }
    }

    updateEnemyBullet(){
        for(var i=0;i<this.bulletArr.length;i++){
            // if(this.bulletArr[i].isRemove){
            //     this.arrRemove(this.bulletArr[i]);
            //     continue;
            // }
            if(this.bulletArr[i])
            this.bulletArr[i].updateSelf();
        }
    }
}