import { BaseSprite } from "./BaseSprite";
import { getTexture, getTextureByName } from "./utils";
import { EffectManager } from "./Manager/EffectManager";
import { LayerManager } from "./Manager/LayerManager";
import { BaseEnemy} from "./enemy/BaseEnemy";
import { BaseEnemyBullet } from "./enemy/BaseEnemyBullet";

export class ClearUpBtn extends BaseSprite{
    bodyImg:engine.Image;
    countImg:engine.Image;
    count:number;
    maxCount:number;
    cntImgArr:engine.Texture[] = [];
    constructor(){
        super();
    }

    addToViewPort(){
        var that = this;
        super.addToViewPort();
        that.count = 3;
        that.maxCount = 3;
        that.bodyImg = new engine.Image();
        that.addChild(that.bodyImg);
        that.countImg = new engine.Image();
        that.addChild(that.countImg);
        that.mouseEnabled = that.mouseChildren = true;
        for(let i=0;i<that.maxCount;i++){
            var texture = getTextureByName("boomCount"+(i+1));
            that.cntImgArr.push(texture);
        }
        that.cntJudge();
        that.countImg.x = that.bodyImg.width-20;
        that.addEvent();
    }

    addEvent(){
        this.addListener(this.bodyImg,engine.MouseEvent.CLICK,this.effect,this);
    }   
    
    /**效果 */
    effect(){
        var that = this;
        that.mouseEnabled = that.mouseChildren = false;
        EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer,"原子弹爆炸",30,14,engine.gameStage.width*0.5,engine.gameStage.height*0.5,()=>{
            that.reduceCnt(1);
        },that)
        var enemyArr:BaseEnemy[] = window["EnemyManager"].enemyArr;
        var enemyBulletArr:BaseEnemyBullet[] = window["EnemyBulletManager"].bulletArr;
        for(let i=0;i<enemyArr.length;i++){
            var enemy = enemyArr[i];
            if(enemy.enemyType === 1){
                enemy.health -= 500;
            }else{
                enemy.removeEnemy();
                i--;
            }
        }
        for(let i=0;i<enemyBulletArr.length;i++){
            let bullet = enemyBulletArr[i];
            bullet.removeSelf();
            i--;
        }
    //    var a = new p2.Body()
    //     a.addShape()

    }

    /**增加炸弹值 */
    increaseCnt(value:number){
        var that = this;
        if((that.count+value)>=that.maxCount){
            that.count = that.maxCount;
        }else{
            that.count += value;
        }
        that.cntJudge();
        
    }

    /**减少炸弹值 */
    reduceCnt(value:number){
        var that = this;
        if(0>=(that.count-value)){
            that.count = 0;
        }else{
            that.count -= value;
        }
        that.cntJudge();
    }

    /**判断当前炸弹值 */
    cntJudge(){
        var that = this;
        if(that.count>0){
            that.mouseEnabled = that.mouseChildren = true;
            that.countImg.visible = true;
            that.countImg.texture = that.cntImgArr[that.count-1]
            that.bodyImg.texture = getTexture("16fbf861-d6a2-4123-939b-50125db78ded");
        }
        else{
            that.mouseEnabled = that.mouseChildren = false;
            that.countImg.visible = false;
            that.bodyImg.texture = getTexture("2c6f37dd-e138-4dcc-a7aa-0ffc2290276e");
        }
        
    }
}