import { BaseSprite } from "../BaseSprite";
import { getTextureByName, rectCollsion } from "../utils";
import { PlayerPlane } from "../PlayerPlane";
import { UserHealth } from "../UserHealth";

export enum buffType{
    healing,
    fireLevel
}

export class Buff extends BaseSprite{
    bodyImg:engine.Image;
    speedY:number = 2;
    buffImgName:string[] = [];
    buffType:buffType = null;
    playerPlane:PlayerPlane;
    constructor(x:number,y:number,buffType:buffType,player){
        super();
        this.x = x;
        this.y = y;
        this.buffType = buffType;
        if(player) 
            this.playerPlane =player;
        this.init();
    }

    init(){
        this.buffImgName = ["userHealth","buff"];
    }

    addToViewPort(){
        this.bodyImg = new engine.Image(getTextureByName(this.buffImgName[this.buffType]));
        this.addChild(this.bodyImg);
    }

    updateSelf(){
        var that = this;
        that.y += that.speedY;
        if(that.y>=(engine.gameStage.height)){
            that.removeSelf();
            return;
        }
        
        var player:PlayerPlane = this.playerPlane;
        if(rectCollsion(that.x,that.y,player.x,player.y,that.bodyImg.width,that.bodyImg.height,player.planeImg.width,player.planeImg.height)){
            that.buffEffect();
            that.removeSelf();
            return;
        }
    }

    buffEffect(){
        var that = this;
        var player:PlayerPlane = this.playerPlane;
        switch(that.buffType){
            case buffType.fireLevel:
                player.fireLevelUp(1);
                break;
            case buffType.healing:
                var health:UserHealth = window["GameManager"].userHealth;
                health.increaseHealth(1);
                break;
        }

    }

    removeSelf(){
        window["GameManager"].buffArrRemove(this);
    }
}