(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global.planeWar = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	function rectCollsion(x1, y1, x2, y2, w1, h1, w2, h2) {
	    var p1 = x1 + w1 * 0.5;
	    var p2 = y1 + h1 * 0.5;
	    var p3 = x2 + w2 * 0.5;
	    var p4 = y2 + h2 * 0.5;
	    if ((Math.abs(p1 - p3) <= (w1 + w2) * 0.5) && (Math.abs(p2 - p4) <= (h1 + h2) * 0.5)) {
	        return true;
	    }
	    return false;
	}
	function vectorUnit(x, y) {
	    var vector = new engine.Point(x, y);
	    vector.x = x / Math.sqrt(x * x + y * y);
	    vector.y = y / Math.sqrt(x * x + y * y);
	    return vector;
	}
	function getPoint(r, ox, oy, count) {
	    var p = [];
	    var radians = (Math.PI / 180) * Math.round(360 / count);
	    for (var i = 0; i < count; i++) {
	        var x = ox + r * Math.sin(radians * i);
	        var y = oy + r * Math.cos(radians * i);
	        p.unshift({ x: x, y: y });
	    }
	    return p;
	}
	//# sourceMappingURL=utils.js.map

	var BaseSprite = (function (_super) {
	    tslib.__extends(BaseSprite, _super);
	    function BaseSprite() {
	        var _this = _super.call(this) || this;
	        _this.listenerArr = [];
	        _this.init();
	        _this.addEventListener(engine.Event.ADDED_TO_STAGE, _this.addToViewPort, _this);
	        _this.addEventListener(engine.Event.REMOVED_FROM_STAGE, _this.removeFromViewPort, _this);
	        return _this;
	    }
	    BaseSprite.prototype.init = function () {
	    };
	    BaseSprite.prototype.addToViewPort = function () {
	        this.removeEventListener(engine.Event.ADDED_TO_STAGE, this.addToViewPort, this);
	    };
	    BaseSprite.prototype.removeFromViewPort = function () {
	        engine.Tween.removeTweens(this);
	        this.removeEventListener(engine.Event.REMOVED_FROM_STAGE, this.removeFromViewPort, this);
	        for (var i = 0; i < this.listenerArr.length; i++) {
	            var data = this.listenerArr[i];
	            data.obj.removeEventListener(data.type, data.listener, data.context, data.useCapture);
	        }
	    };
	    BaseSprite.prototype.addListener = function (obj, type, listener, context, useCapture) {
	        var data = {
	            obj: obj,
	            type: type,
	            listener: listener,
	            context: context,
	            useCapture: useCapture
	        };
	        this.listenerArr.push(data);
	        obj.addEventListener(type, listener, context, useCapture);
	    };
	    BaseSprite.prototype.removeListener = function (obj, type, listener, context, useCapture) {
	        for (var i = 0; i < this.listenerArr.length; i++) {
	            if (this.listenerArr[i].obj == obj && this.listenerArr[i].type == type) {
	                this.listenerArr.splice(i, 1);
	                break;
	            }
	        }
	        obj.removeEventListener(type, listener, context, useCapture);
	    };
	    return BaseSprite;
	}(engine.Sprite));
	//# sourceMappingURL=BaseSprite.js.map

	var PlayerBullet = (function (_super) {
	    tslib.__extends(PlayerBullet, _super);
	    function PlayerBullet() {
	        var _this = _super.call(this) || this;
	        _this.addEventListener(engine.Event.ADDED_TO_STAGE, _this.addToViewPort, _this);
	        return _this;
	    }
	    PlayerBullet.prototype.addToViewPort = function () {
	        this.speedY = -30;
	        this.bullet1Texture = getTexture("f1777abc-521a-4dbb-993e-fcd4042893ac");
	        this.texture = this.bullet1Texture;
	    };
	    PlayerBullet.prototype.updateSelf = function () {
	        this.y += this.speedY;
	    };
	    PlayerBullet.prototype.removeToViewPort = function () {
	    };
	    return PlayerBullet;
	}(engine.Image));
	//# sourceMappingURL=PlayerBullet.js.map

	var EffectAnim = (function (_super) {
	    tslib.__extends(EffectAnim, _super);
	    function EffectAnim(titleName, effectFrame, maxCount, x, y, callBack, arg, loop, maxRepeatCount) {
	        if (loop === void 0) { loop = false; }
	        if (maxRepeatCount === void 0) { maxRepeatCount = 0; }
	        var _this = _super.call(this) || this;
	        _this.titleName = '';
	        _this.count = 2;
	        _this.textureArr = [];
	        _this.effectFrame = 0;
	        _this.maxCount = 0;
	        _this.loop = false;
	        _this.repeatCount = 0;
	        _this.maxRepeatCount = 0;
	        _this.titleName = titleName;
	        _this.effectFrame = effectFrame;
	        _this.maxCount = maxCount;
	        _this.x = x;
	        _this.y = y;
	        _this.callBack = callBack;
	        _this.arg = arg;
	        _this.loop = loop;
	        _this.maxRepeatCount = maxRepeatCount;
	        return _this;
	    }
	    EffectAnim.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        this.bodyImg = new engine.Image(getTextureByName(this.titleName + 1));
	        this.bodyImg.x = -this.bodyImg.width >> 1;
	        this.bodyImg.y = -this.bodyImg.height >> 1;
	        this.addChild(this.bodyImg);
	        this.setTextureArr();
	        this.playEffect();
	    };
	    EffectAnim.prototype.setTextureArr = function () {
	        for (var i = 1; i <= this.maxCount; i++) {
	            var texture = getTextureByName(this.titleName + i);
	            this.textureArr.push(texture);
	        }
	    };
	    EffectAnim.prototype.playEffect = function () {
	        var _this = this;
	        var that = this;
	        that.intervalHandler = setInterval(function () {
	            that.bodyImg.texture = that.textureArr[that.count - 1];
	            that.bodyImg.x = -that.bodyImg.width >> 1;
	            that.bodyImg.y = -that.bodyImg.height >> 1;
	            that.count++;
	            if (_this.loop && that.count > that.maxCount) {
	                that.repeatCount++;
	                if (that.maxRepeatCount > 0 && that.repeatCount >= that.maxRepeatCount) {
	                    that.loop = false;
	                    that.removeEffect();
	                }
	                that.count = 1;
	            }
	            else if (that.count > that.maxCount) {
	                that.removeEffect();
	            }
	        }, that.effectFrame);
	    };
	    EffectAnim.prototype.removeEffect = function () {
	        var that = this;
	        clearInterval(that.intervalHandler);
	        if (that.callBack && that.arg) {
	            that.callBack.call(that.arg);
	        }
	        that.callBack = that.arg = null;
	        if (that && that.parent) {
	            that.parent.removeChild(that);
	        }
	    };
	    EffectAnim.prototype.removeFromViewPort = function () {
	        _super.prototype.removeFromViewPort.call(this);
	        var that = this;
	        clearInterval(that.intervalHandler);
	        if (that.callBack && that.arg) {
	            that.callBack.call(that.arg);
	        }
	        that.callBack = that.arg = null;
	    };
	    return EffectAnim;
	}(BaseSprite));
	//# sourceMappingURL=EffectAnim.js.map

	var EffectManager = (function () {
	    function EffectManager() {
	    }
	    Object.defineProperty(EffectManager, "Ins", {
	        get: function () {
	            if (!this._ins) {
	                this._ins = new EffectManager();
	            }
	            return this._ins;
	        },
	        enumerable: false,
	        configurable: true
	    });
	    EffectManager.prototype.createEffect = function (view, titleName, effectFrame, maxCount, x, y, callBack, arg, loop, maxRepeatCount) {
	        if (loop === void 0) { loop = false; }
	        if (maxRepeatCount === void 0) { maxRepeatCount = 0; }
	        var effect = new EffectAnim(titleName, effectFrame, maxCount, x, y, callBack, arg, loop, maxRepeatCount);
	        view.addChild(effect);
	        return effect;
	    };
	    EffectManager._ins = null;
	    return EffectManager;
	}());
	//# sourceMappingURL=EffectManager.js.map

	var LayerManager = (function () {
	    function LayerManager() {
	    }
	    Object.defineProperty(LayerManager, "Ins", {
	        get: function () {
	            if (!this._ins) {
	                this._ins = new LayerManager();
	            }
	            return this._ins;
	        },
	        enumerable: false,
	        configurable: true
	    });
	    LayerManager.prototype.initLayer = function (view) {
	        var that = this;
	        that.bgLayer = new engine.Sprite();
	        view.addChild(that.bgLayer);
	        that.enemyLayer = new engine.Sprite();
	        view.addChild(that.enemyLayer);
	        that.playerLayer = new engine.Sprite();
	        view.addChild(that.playerLayer);
	        that.bulletLayer = new engine.Sprite();
	        view.addChild(that.bulletLayer);
	        that.buffLayer = new engine.Sprite();
	        view.addChild(that.buffLayer);
	        that.effectLayer = new engine.Sprite();
	        view.addChild(that.effectLayer);
	        that.uiLayer = new engine.Sprite();
	        view.addChild(that.uiLayer);
	    };
	    LayerManager._ins = null;
	    return LayerManager;
	}());
	//# sourceMappingURL=LayerManager.js.map

	var UserHealth = (function (_super) {
	    tslib.__extends(UserHealth, _super);
	    function UserHealth(x, y) {
	        var _this = _super.call(this) || this;
	        _this.health = 0;
	        _this.imgArr = [];
	        _this.x = x;
	        _this.y = y;
	        return _this;
	    }
	    UserHealth.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        this.health = 3;
	        this.setHeartImg();
	        this.addEvent();
	    };
	    UserHealth.prototype.addEvent = function () {
	    };
	    UserHealth.prototype.removeFromViewPort = function () {
	        _super.prototype.removeFromViewPort.call(this);
	    };
	    UserHealth.prototype.reduceHealth = function (value) {
	        this.health -= value;
	        for (var i = 0; i < value; i++) {
	            var img = this.imgArr.pop();
	            this.removeChild(img);
	        }
	    };
	    UserHealth.prototype.increaseHealth = function (value) {
	        for (var i = 0; i < value; i++) {
	            var image = new engine.Image(getTexture("25cdfb44-505b-441d-b904-7aef306d77e1"));
	            this.addChild(image);
	            image.x = (i + this.health) * (image.width + 20);
	            this.imgArr.push(image);
	        }
	        this.health += value;
	    };
	    UserHealth.prototype.setHeartImg = function () {
	        for (var i = 0; i < this.health; i++) {
	            var image = new engine.Image(getTexture("25cdfb44-505b-441d-b904-7aef306d77e1"));
	            this.addChild(image);
	            image.x = i * (image.width + 20);
	            this.imgArr.push(image);
	        }
	    };
	    return UserHealth;
	}(BaseSprite));
	//# sourceMappingURL=UserHealth.js.map

	var buffType;
	(function (buffType) {
	    buffType[buffType["healing"] = 0] = "healing";
	    buffType[buffType["fireLevel"] = 1] = "fireLevel";
	})(buffType || (buffType = {}));
	var Buff = (function (_super) {
	    tslib.__extends(Buff, _super);
	    function Buff(x, y, buffType, player) {
	        var _this = _super.call(this) || this;
	        _this.speedY = 2;
	        _this.buffImgName = [];
	        _this.buffType = null;
	        _this.x = x;
	        _this.y = y;
	        _this.buffType = buffType;
	        if (player)
	            _this.playerPlane = player;
	        _this.init();
	        return _this;
	    }
	    Buff.prototype.init = function () {
	        this.buffImgName = ["userHealth", "buff"];
	    };
	    Buff.prototype.addToViewPort = function () {
	        this.bodyImg = new engine.Image(getTextureByName(this.buffImgName[this.buffType]));
	        this.addChild(this.bodyImg);
	    };
	    Buff.prototype.updateSelf = function () {
	        var that = this;
	        that.y += that.speedY;
	        if (that.y >= (engine.gameStage.height)) {
	            that.removeSelf();
	            return;
	        }
	        var player = this.playerPlane;
	        if (rectCollsion(that.x, that.y, player.x, player.y, that.bodyImg.width, that.bodyImg.height, player.planeImg.width, player.planeImg.height)) {
	            that.buffEffect();
	            that.removeSelf();
	            return;
	        }
	    };
	    Buff.prototype.buffEffect = function () {
	        var that = this;
	        var player = this.playerPlane;
	        switch (that.buffType) {
	            case buffType.fireLevel:
	                player.fireLevelUp(1);
	                break;
	            case buffType.healing:
	                var health = window["GameManager"].userHealth;
	                health.increaseHealth(1);
	                break;
	        }
	    };
	    Buff.prototype.removeSelf = function () {
	        window["GameManager"].buffArrRemove(this);
	    };
	    return Buff;
	}(BaseSprite));
	//# sourceMappingURL=Buff.js.map

	var ClearUpBtn = (function (_super) {
	    tslib.__extends(ClearUpBtn, _super);
	    function ClearUpBtn() {
	        var _this = _super.call(this) || this;
	        _this.cntImgArr = [];
	        return _this;
	    }
	    ClearUpBtn.prototype.addToViewPort = function () {
	        var that = this;
	        _super.prototype.addToViewPort.call(this);
	        that.count = 3;
	        that.maxCount = 3;
	        that.bodyImg = new engine.Image();
	        that.addChild(that.bodyImg);
	        that.countImg = new engine.Image();
	        that.addChild(that.countImg);
	        that.mouseEnabled = that.mouseChildren = true;
	        for (var i = 0; i < that.maxCount; i++) {
	            var texture = getTextureByName("boomCount" + (i + 1));
	            that.cntImgArr.push(texture);
	        }
	        that.cntJudge();
	        that.countImg.x = that.bodyImg.width - 20;
	        that.addEvent();
	    };
	    ClearUpBtn.prototype.addEvent = function () {
	        this.addListener(this.bodyImg, engine.MouseEvent.CLICK, this.effect, this);
	    };
	    ClearUpBtn.prototype.effect = function () {
	        var that = this;
	        that.mouseEnabled = that.mouseChildren = false;
	        EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer, "原子弹爆炸", 30, 14, engine.gameStage.width * 0.5, engine.gameStage.height * 0.5, function () {
	            that.reduceCnt(1);
	        }, that);
	        var enemyArr = window["EnemyManager"].enemyArr;
	        var enemyBulletArr = window["EnemyBulletManager"].bulletArr;
	        for (var i = 0; i < enemyArr.length; i++) {
	            var enemy = enemyArr[i];
	            if (enemy.enemyType === 1) {
	                enemy.health -= 500;
	            }
	            else {
	                enemy.removeEnemy();
	                i--;
	            }
	        }
	        for (var i = 0; i < enemyBulletArr.length; i++) {
	            var bullet = enemyBulletArr[i];
	            bullet.removeSelf();
	            i--;
	        }
	    };
	    ClearUpBtn.prototype.increaseCnt = function (value) {
	        var that = this;
	        if ((that.count + value) >= that.maxCount) {
	            that.count = that.maxCount;
	        }
	        else {
	            that.count += value;
	        }
	        that.cntJudge();
	    };
	    ClearUpBtn.prototype.reduceCnt = function (value) {
	        var that = this;
	        if (0 >= (that.count - value)) {
	            that.count = 0;
	        }
	        else {
	            that.count -= value;
	        }
	        that.cntJudge();
	    };
	    ClearUpBtn.prototype.cntJudge = function () {
	        var that = this;
	        if (that.count > 0) {
	            that.mouseEnabled = that.mouseChildren = true;
	            that.countImg.visible = true;
	            that.countImg.texture = that.cntImgArr[that.count - 1];
	            that.bodyImg.texture = getTexture("16fbf861-d6a2-4123-939b-50125db78ded");
	        }
	        else {
	            that.mouseEnabled = that.mouseChildren = false;
	            that.countImg.visible = false;
	            that.bodyImg.texture = getTexture("2c6f37dd-e138-4dcc-a7aa-0ffc2290276e");
	        }
	    };
	    return ClearUpBtn;
	}(BaseSprite));
	//# sourceMappingURL=ClearUpBtn.js.map

	var GameManager = (function () {
	    function GameManager() {
	        this.playerPlane = null;
	        this.userHealth = null;
	        this.boomBtn = null;
	        this.buffArr = [];
	        window["GameManager"] = this;
	    }
	    Object.defineProperty(GameManager, "INS", {
	        get: function () {
	            if (!this._ins) {
	                this._ins = new GameManager();
	            }
	            return this._ins;
	        },
	        enumerable: false,
	        configurable: true
	    });
	    GameManager.prototype.createUserHealth = function (view, x, y) {
	        if (this.userHealth) {
	            this.userHealth.parent.removeChild(this.userHealth);
	            this.userHealth = null;
	        }
	        this.userHealth = new UserHealth(x, y);
	        view.addChild(this.userHealth);
	    };
	    GameManager.prototype.createBoomBtn = function (view, x, y) {
	        if (this.boomBtn) {
	            this.boomBtn.parent.removeChild(this.boomBtn);
	            this.boomBtn = null;
	        }
	        this.boomBtn = new ClearUpBtn();
	        this.boomBtn.x = x;
	        this.boomBtn.y = y;
	        view.addChild(this.boomBtn);
	    };
	    GameManager.prototype.createBuff = function (view, x, y, buffType) {
	        var buff = new Buff(x, y, buffType, this.playerPlane);
	        view.addChild(buff);
	        this.buffArr.push(buff);
	    };
	    GameManager.prototype.updateGame = function () {
	        for (var i = 0; i < this.buffArr.length; i++) {
	            if (this.buffArr[i])
	                this.buffArr[i].updateSelf();
	        }
	    };
	    GameManager.prototype.buffArrRemove = function (obj) {
	        if (obj && obj.parent) {
	            obj.parent.removeChild(obj);
	        }
	        var index = this.buffArr.indexOf(obj);
	        if (index >= 0) {
	            this.buffArr.splice(index, 1);
	        }
	    };
	    GameManager._ins = null;
	    return GameManager;
	}());
	//# sourceMappingURL=GameManager.js.map

	var BaseEnemyBullet = (function (_super) {
	    tslib.__extends(BaseEnemyBullet, _super);
	    function BaseEnemyBullet() {
	        var _this = _super.call(this) || this;
	        _this.isRemove = false;
	        _this.worldTime = 0;
	        return _this;
	    }
	    BaseEnemyBullet.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        this.bodyImg = new engine.Image();
	        this.addChild(this.bodyImg);
	    };
	    BaseEnemyBullet.prototype.updateSelf = function () {
	        var that = this;
	        that.x += that.speedX * that.speedVector.x;
	        that.y += that.speedY * that.speedVector.y;
	        that.boundsJudge();
	        that.playerCollsion();
	    };
	    BaseEnemyBullet.prototype.setBodyImg = function (uuid) {
	        this.bodyImg.texture = getTexture(uuid);
	    };
	    BaseEnemyBullet.prototype.removeSelf = function () {
	        window["EnemyBulletManager"].arrRemove(this);
	    };
	    BaseEnemyBullet.prototype.boundsJudge = function () {
	        if ((this.x <= -this.bodyImg.width * 0.5) || (this.x >= (engine.gameStage.width + this.bodyImg.width * 0.5)) || (this.y <= -this.bodyImg.height * 0.5) || (this.y >= (engine.gameStage.height + this.bodyImg.height * 0.5))) {
	            this.removeSelf();
	        }
	    };
	    BaseEnemyBullet.prototype.playerCollsion = function () {
	        var player = GameManager.INS.playerPlane;
	        var x1 = player.getCenterP().x;
	        var y1 = player.getCenterP().y;
	        var pos = this.localToGlobal(new engine.Point(0, 0));
	        var x2 = pos.x;
	        var y2 = pos.y;
	        var w1 = player.hitW;
	        var h1 = player.hitH;
	        var w2 = this.bodyImg.width;
	        var h2 = this.bodyImg.height;
	        if (rectCollsion(x1, y1, x2, y2, w1, h1, w2, h2)) {
	            player.hitDamage(1);
	        }
	    };
	    return BaseEnemyBullet;
	}(BaseSprite));
	//# sourceMappingURL=BaseEnemyBullet.js.map

	var DartBullet = (function (_super) {
	    tslib.__extends(DartBullet, _super);
	    function DartBullet(x, y, speed, vector) {
	        var _this = _super.call(this) || this;
	        _this.x = x;
	        _this.y = y;
	        _this.speedX = _this.speedY = speed;
	        _this.speedVector = vector;
	        return _this;
	    }
	    DartBullet.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        this.bodyImg.texture = getTexture("8c18a621-f3dc-4f2d-a31a-5f1d8a3f1158");
	        this.bodyImg.x = -this.bodyImg.width >> 1;
	        this.bodyImg.y = -this.bodyImg.height >> 1;
	    };
	    DartBullet.prototype.updateSelf = function () {
	        this.rotation += 5;
	        _super.prototype.updateSelf.call(this);
	    };
	    return DartBullet;
	}(BaseEnemyBullet));
	//# sourceMappingURL=DartBullet.js.map

	var Laser = (function (_super) {
	    tslib.__extends(Laser, _super);
	    function Laser(enemy, x, y, call, args, type1) {
	        var _this = _super.call(this) || this;
	        _this.laserAwake = false;
	        _this.enemy = enemy;
	        _this.offset = x;
	        _this.y = y;
	        _this.call = call;
	        _this.args = args;
	        _this.type = type1;
	        return _this;
	    }
	    Laser.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        this.setBodyImg("fbfa0a2b-479d-4a04-b40a-e416eecfabcb");
	        this.bodyImg.anchorX = this.bodyImg.width * 0.5;
	        this.bodyImg.x = -this.bodyImg.width * 0.5;
	        this.bodyImg.scaleY = 0;
	        EffectManager.Ins.createEffect(this, "laserHead", 15, 4, 0, 0, null, null, true);
	    };
	    Laser.prototype.updateSelf = function () {
	        var that = this;
	        if (that.bodyImg.scaleY < 1) {
	            that.bodyImg.scaleY += 0.05;
	        }
	        else {
	            this.worldTime++;
	            if (this.worldTime % 60 == 0) {
	                if (that.args && that.call) {
	                    that.call.call(that.args);
	                    that.call = that.args = null;
	                }
	                this.removeSelf();
	                return;
	            }
	            that.bodyImg.scaleY = 1;
	        }
	        if (that.enemy && !that.enemy.isDead) {
	            if (that.type == 0) {
	                that.x = that.offset ? that.enemy.getCenterP().x - that.offset : that.enemy.getCenterP().x - 80;
	            }
	            else {
	                that.x = that.offset ? that.enemy.getCenterP().x + that.offset : that.enemy.getCenterP().x + 80;
	            }
	        }
	        var player = GameManager.INS.playerPlane;
	        var x1 = player.getCenterP().x;
	        var y1 = player.getCenterP().y;
	        var pos = this.localToGlobal(new engine.Point(0, this.bodyImg.height * 0.5));
	        var x2 = pos.x;
	        var y2 = pos.y;
	        var w1 = player.hitW;
	        var h1 = player.hitH;
	        var w2 = this.bodyImg.width;
	        var h2 = this.bodyImg.height;
	        if (rectCollsion(x1, y1, x2, y2, w1, h1, w2, h2)) {
	            player.hitDamage(1);
	        }
	    };
	    return Laser;
	}(BaseEnemyBullet));
	//# sourceMappingURL=Laser.js.map

	var ExplosionBullet = (function (_super) {
	    tslib.__extends(ExplosionBullet, _super);
	    function ExplosionBullet(x, y, vector, speed, type, targetPoint) {
	        if (type === void 0) { type = 1; }
	        var _this = _super.call(this) || this;
	        _this.type = 0;
	        _this.targetPoint = null;
	        _this.x = x;
	        _this.y = y;
	        _this.speedVector = vector;
	        _this.type = type;
	        _this.speedX = _this.speedY = speed;
	        _this.targetPoint = targetPoint;
	        return _this;
	    }
	    ExplosionBullet.prototype.addToViewPort = function () {
	        var that = this;
	        _super.prototype.addToViewPort.call(this);
	        that.setBodyImg("e06a8cd4-81f9-4ed9-bc6f-ff8a964bf0a6");
	        that.bodyImg.x = -that.bodyImg.width >> 1;
	        that.bodyImg.y = -that.bodyImg.height >> 1;
	        if (this.targetPoint)
	            that.speedVector = vectorUnit(that.targetPoint.x - that.x, that.targetPoint.y - that.y);
	    };
	    ExplosionBullet.prototype.updateSelf = function () {
	        var that = this;
	        switch (that.type) {
	            case 1:
	                that.x += that.speedVector.x * that.speedX;
	                that.y += that.speedVector.y * that.speedY;
	                break;
	            case 2:
	                that.x += that.speedVector.x * that.speedX;
	                that.y += that.speedVector.y * that.speedY;
	                if (Math.abs(that.targetPoint.x - that.x) <= that.speedX && Math.abs(that.targetPoint.y - that.y) <= that.speedY) {
	                    that.type = 3;
	                }
	                break;
	            case 3:
	                that.worldTime++;
	                if (that.worldTime % 14 == 0) {
	                    this.type = 4;
	                    this.splitBullet();
	                    this.visible = false;
	                    this.removeSelf();
	                }
	                break;
	        }
	        that.boundsJudge();
	        that.playerCollsion();
	    };
	    ExplosionBullet.prototype.splitBullet = function () {
	        var posArr = getPoint(30, this.x, this.y, 12);
	        for (var i = 0; i < posArr.length; i++) {
	            var vector = vectorUnit(posArr[i].x - this.x, posArr[i].y - this.y);
	            window["EnemyBulletManager"].createBullet(null, LayerManager.Ins.bulletLayer, posArr[i].x, posArr[i].y, 1, 4, vector, 2);
	        }
	    };
	    return ExplosionBullet;
	}(BaseEnemyBullet));
	//# sourceMappingURL=ExplosionBullet.js.map

	var SwordBullet = (function (_super) {
	    tslib.__extends(SwordBullet, _super);
	    function SwordBullet(x, y, speed, vector) {
	        var _this = _super.call(this) || this;
	        _this.x = x;
	        _this.y = y;
	        _this.speedVector = vector;
	        _this.speedX = _this.speedY = speed;
	        _this.rotation = Math.atan2(vector.y, vector.x) * 180 / Math.PI - 90;
	        return _this;
	    }
	    SwordBullet.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        this.setBodyImg("2c7a1136-4ea6-4fdd-be1d-b7f740a79198");
	        this.bodyImg.x = -this.bodyImg.width >> 1;
	    };
	    SwordBullet.prototype.updateSelf = function () {
	        _super.prototype.updateSelf.call(this);
	    };
	    return SwordBullet;
	}(BaseEnemyBullet));
	//# sourceMappingURL=SwordBullet.js.map

	var SmallBullet = (function (_super) {
	    tslib.__extends(SmallBullet, _super);
	    function SmallBullet(x, y, speed, vector) {
	        var _this = _super.call(this) || this;
	        _this.x = x;
	        _this.y = y;
	        _this.speedX = _this.speedY = speed;
	        _this.speedVector = vector;
	        return _this;
	    }
	    SmallBullet.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        this.bodyImg.texture = getTexture("e595af59-4023-4363-823c-acf0f1436e00");
	        this.bodyImg.x = -this.bodyImg.width >> 1;
	        this.bodyImg.y = -this.bodyImg.height >> 1;
	    };
	    SmallBullet.prototype.updateSelf = function () {
	        _super.prototype.updateSelf.call(this);
	    };
	    return SmallBullet;
	}(BaseEnemyBullet));
	//# sourceMappingURL=SmallBullet.js.map

	var EnemyBulletManager = (function () {
	    function EnemyBulletManager() {
	        this.bulletArr = [];
	        window["EnemyBulletManager"] = this;
	    }
	    Object.defineProperty(EnemyBulletManager, "Ins", {
	        get: function () {
	            if (!this._ins) {
	                this._ins = new EnemyBulletManager();
	            }
	            return this._ins;
	        },
	        enumerable: false,
	        configurable: true
	    });
	    EnemyBulletManager.prototype.createBullet = function (enemy, view, x, y, type, speed, vector, type1, targtPoint, call, args) {
	        if (type1 === void 0) { type1 = 1; }
	        var bullet;
	        switch (type) {
	            case 1:
	                bullet = new DartBullet(x, y, speed, vector);
	                break;
	            case 2:
	                bullet = new Laser(enemy, x, y, call, args, type1);
	                break;
	            case 3:
	                bullet = new ExplosionBullet(x, y, vector, speed, type1, targtPoint);
	                break;
	            case 4:
	                bullet = new SwordBullet(x, y, speed, vector);
	                break;
	            case 5:
	                bullet = new SmallBullet(x, y, speed, vector);
	                break;
	        }
	        this.bulletArr.push(bullet);
	        view.addChild(bullet);
	        return bullet;
	    };
	    EnemyBulletManager.prototype.arrRemove = function (obj) {
	        var index = this.bulletArr.indexOf(obj);
	        if (index >= 0) {
	            this.bulletArr.splice(index, 1);
	        }
	        if (obj && obj.parent) {
	            obj.parent.removeChild(obj);
	        }
	    };
	    EnemyBulletManager.prototype.updateEnemyBullet = function () {
	        for (var i = 0; i < this.bulletArr.length; i++) {
	            if (this.bulletArr[i])
	                this.bulletArr[i].updateSelf();
	        }
	    };
	    EnemyBulletManager._ins = null;
	    return EnemyBulletManager;
	}());
	//# sourceMappingURL=EnemyBulletManager.js.map

	var enemyState;
	(function (enemyState) {
	    enemyState[enemyState["default"] = 0] = "default";
	    enemyState[enemyState["goStage"] = 1] = "goStage";
	    enemyState[enemyState["inSatge"] = 2] = "inSatge";
	    enemyState[enemyState["wait"] = 3] = "wait";
	    enemyState[enemyState["dash"] = 4] = "dash";
	    enemyState[enemyState["attack"] = 5] = "attack";
	})(enemyState || (enemyState = {}));
	var enemyType;
	(function (enemyType) {
	    enemyType[enemyType["default"] = 0] = "default";
	    enemyType[enemyType["boss"] = 1] = "boss";
	    enemyType[enemyType["elite"] = 2] = "elite";
	    enemyType[enemyType["normal"] = 3] = "normal";
	})(enemyType || (enemyType = {}));
	var BaseEnemy = (function (_super) {
	    tslib.__extends(BaseEnemy, _super);
	    function BaseEnemy() {
	        var _this = _super.call(this) || this;
	        _this.worldTime = 0;
	        _this.damage = 0;
	        _this.speedX = 0;
	        _this.speedY = 0;
	        _this.hitW = 0;
	        _this.hitH = 0;
	        _this.enemyState = enemyState.default;
	        _this.enemyType = enemyType.default;
	        _this.isInvincible = false;
	        _this.damageEffecting = false;
	        _this.health = 0;
	        _this.isDead = false;
	        _this.lastSkillIndex = 0;
	        _this.curSkillIndex = -1;
	        _this.curSkillMax = 1;
	        _this.dartBulletVector1 = null;
	        _this.dartBulletVector2 = null;
	        _this.dartBulletCount = 0;
	        _this.dartBulletMax = 4;
	        _this.dartBulletTime = 0;
	        _this.volatilizationCount = 0;
	        _this.volatilizationMax = 5;
	        _this.volatilizationTime = 9;
	        _this.volatilizationEffect = false;
	        _this.canCreateLaser = true;
	        _this.groupShotCnt = 0;
	        _this.groupShotMax = 3;
	        _this.groupShotTime = 9;
	        _this.groupShotEffect = false;
	        _this.spiralTime = 2;
	        _this.spiralRotate = 0;
	        _this.spiralCnt = 0;
	        _this.spiralMax = 24;
	        return _this;
	    }
	    BaseEnemy.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        var that = this;
	        this.speedVector = new engine.Point();
	        that.bodyImg = new engine.Image();
	        that.addChild(that.bodyImg);
	    };
	    BaseEnemy.prototype.updateSelf = function () {
	        var that = this;
	        that.x += that.speedX * that.speedVector.x;
	        that.y += that.speedY * that.speedVector.y;
	        that.playerCollsion();
	        if (that.y > engine.gameStage.height) {
	            that.removeEnemy();
	            return;
	        }
	    };
	    BaseEnemy.prototype.damageHit = function (value) {
	        if (this.isInvincible || this.isDead)
	            return;
	        var that = this;
	        if (!that.damageEffecting) {
	            that.damageEffecting = true;
	            EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer, "hit", 26, 4, that.x + that.bodyImg.width * 0.5, that.y + that.bodyImg.height * 0.5, function () {
	                if (that && that.parent)
	                    that.damageEffecting = false;
	            }, that);
	        }
	        that.health -= value;
	        if (that.health <= 0) {
	            that.visible = false;
	            that.isDead = true;
	            switch (that.enemyType) {
	                case enemyType.normal:
	                    EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer, "eboom", 36, 7, that.getCenterP().x, that.getCenterP().y);
	                    break;
	                case enemyType.elite:
	                    EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer, "eboom", 36, 7, that.getCenterP().x, that.getCenterP().y);
	                    break;
	                case enemyType.boss:
	                    EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer, "boom", 40, 4, that.getCenterP().x, that.getCenterP().y);
	                    GameManager.INS.createBuff(LayerManager.Ins.buffLayer, that.getCenterP().x, that.getCenterP().y, buffType.fireLevel);
	                    break;
	                default: console.log("敌人类型没有设置，为default");
	            }
	            that.removeEnemy();
	        }
	    };
	    BaseEnemy.prototype.removeEnemy = function () {
	        if (this.enemyType === 1)
	            engine.globalEvent.dispatchEvent("bossDead");
	        EnemyManager.Ins.enemyArrRemove(this);
	    };
	    BaseEnemy.prototype.changeState = function (state) {
	    };
	    BaseEnemy.prototype.createDartBullet = function () {
	        var that = this;
	        that.dartBulletTime++;
	        if (that.dartBulletTime % 6 == 0) {
	            that.dartBulletTime = 0;
	            for (var i = 0; i < 2; i++) {
	                if (!that.dartBulletVector1 || !that.dartBulletVector2) {
	                    that.dartBulletVector1 = vectorUnit(GameManager.INS.playerPlane.getCenterP().x - (that.getCenterP().x - 80), GameManager.INS.playerPlane.getCenterP().y - that.getCenterP().y);
	                    that.dartBulletVector2 = vectorUnit(GameManager.INS.playerPlane.getCenterP().x - (that.getCenterP().x + 160), GameManager.INS.playerPlane.getCenterP().y - that.getCenterP().y);
	                }
	                var vector = that.dartBulletVector1;
	                if (i % 2 != 0)
	                    vector = that.dartBulletVector2;
	                EnemyBulletManager.Ins.createBullet(null, LayerManager.Ins.bulletLayer, that.getCenterP().x - 80 + i * 160, that.y + that.bodyImg.height, 1, 10, vector);
	            }
	            that.dartBulletCount++;
	            if (that.dartBulletCount >= that.dartBulletMax) {
	                that.dartBulletCount = 0;
	                that.dartBulletVector1 = null;
	                that.dartBulletVector2 = null;
	                that.changeState(enemyState.inSatge);
	            }
	        }
	    };
	    BaseEnemy.prototype.createLaser = function (offset) {
	        if (!this.canCreateLaser)
	            return;
	        var that = this;
	        that.canCreateLaser = false;
	        var x1 = offset ? that.bodyImg.width * 0.5 - offset : that.bodyImg.width * 0.5 - 80;
	        var x2 = offset ? that.bodyImg.width * 0.5 + offset : that.bodyImg.width * 0.5 + 80;
	        EffectManager.Ins.createEffect(that, "polymerization", 56, 5, x1, that.bodyImg.height, function () {
	            EnemyBulletManager.Ins.createBullet(that, LayerManager.Ins.bulletLayer, offset, that.y + that.bodyImg.height - 10, 2, null, null, 0, null, function () {
	                if (that && that.parent) {
	                    that.canCreateLaser = true;
	                    that.changeState(enemyState.inSatge);
	                }
	            }, that);
	        }, that, true, 2);
	        EffectManager.Ins.createEffect(that, "polymerization", 56, 5, x2, that.bodyImg.height, function () {
	            EnemyBulletManager.Ins.createBullet(that, LayerManager.Ins.bulletLayer, offset, that.y + that.bodyImg.height - 10, 2, null, null, 1, null, function () {
	                if (that && that.parent) {
	                    that.canCreateLaser = true;
	                    that.changeState(enemyState.inSatge);
	                }
	            }, that);
	        }, that, true, 2);
	    };
	    BaseEnemy.prototype.createVolatilization = function () {
	        var that = this;
	        if (!that.volatilizationEffect) {
	            that.volatilizationEffect = true;
	            for (var i = 0; i < 3; i++) {
	                var x = that.getCenterP().x - 60 + i * 60;
	                var y = that.getCenterP().y + 60 - (i % 2) * 120;
	                EffectManager.Ins.createEffect(LayerManager.Ins.effectLayer, "polymerization", 44, 5, x, y, null, null, true, 4);
	            }
	            that.volatilizationTime = 9;
	        }
	        that.volatilizationTime++;
	        if (that.volatilizationTime % 10 == 0) {
	            that.volatilizationTime = 0;
	            var player = GameManager.INS.playerPlane;
	            for (var i = 0; i < 3; i++) {
	                var x = that.getCenterP().x - 60 + i * 60;
	                var y = that.getCenterP().y + 60 - (i % 2) * 120;
	                var targetX = player.getCenterP().x + Math.floor(Math.random() * 10 - 5);
	                var targetY = player.getCenterP().y + Math.floor(Math.random() * 10 - 5);
	                var vector = vectorUnit(targetX - x, targetY - y);
	                EnemyBulletManager.Ins.createBullet(null, LayerManager.Ins.bulletLayer, x, y, 3, 14, vector, 1);
	            }
	            that.volatilizationCount++;
	            if (that.volatilizationCount >= that.volatilizationMax) {
	                that.volatilizationEffect = false;
	                that.volatilizationCount = 0;
	                that.volatilizationTime = 9;
	                that.changeState(enemyState.inSatge);
	            }
	        }
	    };
	    BaseEnemy.prototype.createSplitBullet = function () {
	        var that = this;
	        var randomX = Math.floor(Math.random() * (engine.gameStage.width - 160) + 80);
	        var randomY = Math.floor(Math.random() * (engine.gameStage.height / 3) + engine.gameStage.height / 3);
	        for (var i = 0; i < 2; i++) {
	            var x = that.getCenterP().x - 40 + i * 80;
	            var y = that.y + that.bodyImg.height;
	            EnemyBulletManager.Ins.createBullet(that, LayerManager.Ins.bulletLayer, x, y, 3, 8, null, 2, new engine.Point(randomX + i * 80, randomY));
	        }
	        that.changeState(enemyState.inSatge);
	    };
	    BaseEnemy.prototype.createGrapeshot = function (offset) {
	        var that = this;
	        if (!that.groupShotEffect) {
	            that.groupShotEffect = true;
	            for (var i = 0; i < 2; i++) {
	                var x_1 = that.bodyImg.width * 0.5 - 60 + i * 120;
	                EffectManager.Ins.createEffect(that, "polymerization", 50, 5, x_1, that.bodyImg.height + 40, null, null, true, 3);
	            }
	            that.groupShotTime = 9;
	        }
	        that.groupShotTime++;
	        if (that.groupShotTime % 10 == 0) {
	            that.groupShotTime = 0;
	            that.groupShotCnt++;
	            for (var i = 0; i < 6; i++) {
	                var x = that.getCenterP().x - 100 + i * 40;
	                var x1 = that.getCenterP().x - 125 + i * 50;
	                var y = that.getCenterP().y + that.bodyImg.height * 0.5;
	                var vector = vectorUnit(x1 - x, 40);
	                EnemyBulletManager.Ins.createBullet(that, LayerManager.Ins.bulletLayer, x, y, 3, 10, vector);
	            }
	            if (that.groupShotCnt >= that.groupShotMax) {
	                that.groupShotCnt = 0;
	                that.groupShotEffect = false;
	                that.changeState(enemyState.inSatge);
	            }
	        }
	    };
	    BaseEnemy.prototype.createAGrapeShot = function () {
	        var that = this;
	        for (var i = 0; i < 2; i++) {
	            var x_2 = that.bodyImg.width * 0.5 - 60 + i * 120;
	            EffectManager.Ins.createEffect(that, "polymerization", 50, 5, x_2, that.bodyImg.height + 40);
	        }
	        for (var i = 0; i < 6; i++) {
	            var x = that.getCenterP().x - 100 + i * 40;
	            var x1 = that.getCenterP().x - 125 + i * 50;
	            var y = that.getCenterP().y + that.bodyImg.height * 0.5;
	            var vector = vectorUnit(x1 - x, 40);
	            EnemyBulletManager.Ins.createBullet(that, LayerManager.Ins.bulletLayer, x, y, 3, 10, vector);
	        }
	    };
	    BaseEnemy.prototype.createTwoSword = function (offset) {
	        var that = this;
	        var y = that.y + that.bodyImg.height;
	        for (var i = 0; i < 2; i++) {
	            var x = offset ? that.getCenterP().x - offset + i * 2 * offset : that.getCenterP().x - 20 + i * 2 * 20;
	            EnemyBulletManager.Ins.createBullet(that, LayerManager.Ins.bulletLayer, x, y, 4, 8, new engine.Point(0, 1));
	        }
	    };
	    BaseEnemy.prototype.creareThreeSword = function (offset) {
	        var that = this;
	        for (var i = 0; i < 3; i++) {
	            var originX = offset ? that.getCenterP().x - offset + i * offset : that.getCenterP().x - 30 + i * 30;
	            var originY = that.y + that.bodyImg.height;
	        }
	    };
	    BaseEnemy.prototype.createSpiralShot = function () {
	        var that = this;
	        that.spiralTime++;
	        if (that.spiralTime % 5 == 0) {
	            that.spiralTime = 0;
	            var angleUnit = 360 / that.spiralMax;
	            var angle = that.spiralCnt * angleUnit;
	            var randus = Math.PI / 180 * angle;
	            var x = that.getCenterP().x;
	            var y = that.getCenterP().y;
	            var vector = new engine.Point(Math.cos(randus), Math.sin(randus));
	            EnemyBulletManager.Ins.createBullet(that, LayerManager.Ins.bulletLayer, x, y, 1, 5, vector);
	            that.spiralCnt++;
	            if (that.spiralCnt >= that.spiralMax) {
	                that.spiralRotate = 0;
	                that.spiralCnt = 0;
	                that.spiralTime = 4;
	                that.changeState(enemyState.inSatge);
	            }
	        }
	    };
	    BaseEnemy.prototype.createFourSideShot = function () {
	        var that = this;
	        var x = 0;
	        var y = 0;
	        for (var i = 0; i < 4; i++) {
	            switch (i) {
	                case 0:
	                    x = that.getCenterP().x + 20;
	                    y = that.getCenterP().y;
	                    var vector = new engine.Point(1, 0);
	                    break;
	                case 1:
	                    x = that.getCenterP().x;
	                    y = that.getCenterP().y + 20;
	                    var vector = new engine.Point(0, 1);
	                    break;
	                case 2:
	                    x = that.getCenterP().x - 20;
	                    y = that.getCenterP().y;
	                    var vector = new engine.Point(-1, 0);
	                    break;
	                case 3:
	                    x = that.getCenterP().x;
	                    y = that.getCenterP().y - 20;
	                    var vector = new engine.Point(0, -1);
	                    break;
	            }
	            EnemyBulletManager.Ins.createBullet(that, LayerManager.Ins.enemyLayer, x, y, 5, 8, vector);
	        }
	    };
	    BaseEnemy.prototype.playerCollsion = function () {
	        var that = this;
	        if (that.isDead)
	            return;
	        var player = GameManager.INS.playerPlane;
	        if (rectCollsion(this.x, this.y, player.x, player.y, this.hitW, this.hitH, player.hitW, player.hitH)) {
	            player.hitDamage(1);
	        }
	    };
	    BaseEnemy.prototype.horizonBounds = function () {
	        var that = this;
	        if (that.x <= that.bodyImg.width * 0.2 || (that.x >= (engine.gameStage.width - that.bodyImg.width * 1.2))) {
	            that.speedVector.x = -that.speedVector.x;
	        }
	    };
	    BaseEnemy.prototype.bossSetGoStage = function () {
	        this.speedY = 1;
	        this.speedVector.y = 1;
	        this.speedX = this.speedVector.x = 0;
	    };
	    BaseEnemy.prototype.bossSetInStage = function () {
	        this.speedY = 0;
	        this.speedX = 1;
	        this.worldTime = 0;
	        if (this.speedVector.x == 0)
	            this.speedVector.x = 1;
	        this.speedVector.y = 0;
	    };
	    BaseEnemy.prototype.attackState = function () {
	        this.curSkillIndex++;
	        if (this.curSkillIndex > this.curSkillMax)
	            this.curSkillIndex = 0;
	    };
	    BaseEnemy.prototype.setBody = function (uuid) {
	        this.bodyImg.texture = getTexture(uuid);
	    };
	    BaseEnemy.prototype.getCenterP = function () {
	        var x = this.x + this.bodyImg.width * 0.5;
	        var y = this.y + this.bodyImg.height * 0.5;
	        return { x: x, y: y };
	    };
	    return BaseEnemy;
	}(BaseSprite));
	//# sourceMappingURL=BaseEnemy.js.map

	var BuleBoss = (function (_super) {
	    tslib.__extends(BuleBoss, _super);
	    function BuleBoss() {
	        return _super.call(this) || this;
	    }
	    BuleBoss.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        this.setBody("5d447892-7234-47b6-9fa1-bfd79914d9cc");
	        this.hitW = 320;
	        this.hitH = 130;
	        this.x = engine.gameStage.width * 0.5 - this.bodyImg.width * 0.5;
	        this.y = -this.bodyImg.height;
	        this.enemyType = enemyType.boss;
	        this.changeState(enemyState.goStage);
	        this.curSkillMax = 1;
	        this.health = 200;
	    };
	    BuleBoss.prototype.updateSelf = function () {
	        _super.prototype.updateSelf.call(this);
	        var that = this;
	        switch (that.enemyState) {
	            case enemyState.goStage:
	                if (that.y >= (that.bodyImg.height * 0.1)) {
	                    that.changeState(enemyState.wait);
	                }
	                break;
	            case enemyState.inSatge:
	                that.worldTime++;
	                that.horizonBounds();
	                if (that.worldTime % 90 == 0) {
	                    that.worldTime = 0;
	                    that.changeState(enemyState.attack);
	                }
	                break;
	            case enemyState.wait:
	                that.worldTime++;
	                if (that.worldTime % 90 == 0) {
	                    that.changeState(enemyState.inSatge);
	                }
	                break;
	            case enemyState.attack:
	                that.horizonBounds();
	                switch (that.curSkillIndex) {
	                    case 0:
	                        that.createDartBullet();
	                        break;
	                    case 1:
	                        that.createLaser();
	                        break;
	                }
	                break;
	        }
	    };
	    BuleBoss.prototype.changeState = function (state) {
	        switch (state) {
	            case enemyState.goStage:
	                this.speedY = 2;
	                this.speedX = 0;
	                this.speedVector.x = 0;
	                this.speedVector.y = 1;
	                break;
	            case enemyState.inSatge:
	                this.bossSetInStage();
	                break;
	            case enemyState.attack:
	                this.curSkillIndex++;
	                if (this.curSkillIndex > this.curSkillMax)
	                    this.curSkillIndex = 0;
	                break;
	        }
	        this.enemyState = state;
	    };
	    return BuleBoss;
	}(BaseEnemy));
	//# sourceMappingURL=BlueBoss.js.map

	var ThreeBallsBoss = (function (_super) {
	    tslib.__extends(ThreeBallsBoss, _super);
	    function ThreeBallsBoss() {
	        return _super.call(this) || this;
	    }
	    ThreeBallsBoss.prototype.addToViewPort = function () {
	        var that = this;
	        _super.prototype.addToViewPort.call(this);
	        that.setBody("6e726b08-91a7-4fed-acfb-5cecdd649f63");
	        that.bodyImg.anchorX = that.bodyImg.width >> 1;
	        that.bodyImg.anchorY = that.bodyImg.height >> 1;
	        that.x = engine.gameStage.width * 0.5 - that.bodyImg.width * 0.5;
	        that.y = -that.bodyImg.height;
	        that.hitW = 200;
	        that.hitH = 150;
	        that.health = 400;
	        that.enemyType = enemyType.boss;
	        that.changeState(enemyState.goStage);
	    };
	    ThreeBallsBoss.prototype.updateSelf = function () {
	        _super.prototype.updateSelf.call(this);
	        var that = this;
	        that.bodyImg.rotation += 2;
	        switch (that.enemyState) {
	            case enemyState.goStage:
	                if (that.y >= (that.bodyImg.height * 0.5)) {
	                    that.changeState(enemyState.inSatge);
	                }
	                break;
	            case enemyState.inSatge:
	                that.worldTime++;
	                if (that.worldTime % 100 == 0) {
	                    that.changeState(enemyState.attack);
	                }
	                break;
	            case enemyState.attack:
	                that.createVolatilization();
	                break;
	        }
	    };
	    ThreeBallsBoss.prototype.changeState = function (state) {
	        this.enemyState = state;
	        switch (state) {
	            case enemyState.goStage:
	                this.speedY = 2;
	                this.speedX = 0;
	                this.speedVector.x = 0;
	                this.speedVector.y = 1;
	                break;
	            case enemyState.inSatge:
	                this.speedY = 0;
	                this.speedX = 0;
	                this.speedVector.x = 0;
	                this.speedVector.y = 0;
	                this.worldTime = 0;
	                break;
	        }
	    };
	    return ThreeBallsBoss;
	}(BaseEnemy));
	//# sourceMappingURL=ThreeBallsBoss.js.map

	var GreenBoss = (function (_super) {
	    tslib.__extends(GreenBoss, _super);
	    function GreenBoss() {
	        var _this = _super.call(this) || this;
	        _this.canDash = true;
	        _this.lastSpeedX = 1;
	        return _this;
	    }
	    GreenBoss.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        this.setBody("86f41d76-950d-44af-9e43-7b5d339f6ec4");
	        this.x = engine.gameStage.width * 0.5 - this.bodyImg.width * 0.5;
	        this.y = -this.bodyImg.height;
	        this.hitW = 250;
	        this.hitH = 120;
	        this.health = 600;
	        this.enemyType = enemyType.boss;
	        this.changeState(enemyState.goStage);
	    };
	    GreenBoss.prototype.updateSelf = function () {
	        _super.prototype.updateSelf.call(this);
	        var that = this;
	        switch (that.enemyState) {
	            case enemyState.goStage:
	                if (that.y >= that.bodyImg.height * 0.4) {
	                    that.changeState(enemyState.inSatge);
	                }
	                break;
	            case enemyState.inSatge:
	                that.worldTime++;
	                that.horizonBounds();
	                if (that.worldTime % 90 == 0) {
	                    that.changeState(enemyState.attack);
	                }
	                break;
	            case enemyState.attack:
	                that.horizonBounds();
	                switch (that.curSkillIndex) {
	                    case 0:
	                        that.createDartBullet();
	                        break;
	                    case 1:
	                        that.dashAttack();
	                        break;
	                }
	                break;
	        }
	    };
	    GreenBoss.prototype.dashAttack = function () {
	        var that = this;
	        if (!that.canDash)
	            return;
	        that.canDash = false;
	        that.lastSpeedX = that.speedVector.x;
	        that.speedVector.x = 0;
	        that.dashEffect = EffectManager.Ins.createEffect(this, "DashFire", 50, 3, this.bodyImg.width >> 1, 0, null, null, true);
	        engine.Tween.get(this).to({ y: engine.gameStage.height }, 1000, engine.Ease.quintIn).call(function () {
	            if (that && !that.isDead) {
	                that.dashEffect.removeEffect();
	                that.y = -that.bodyImg.height;
	                that.canDash = true;
	                that.changeState(enemyState.goStage);
	            }
	        }, this);
	    };
	    GreenBoss.prototype.changeState = function (state) {
	        var that = this;
	        switch (state) {
	            case enemyState.goStage:
	                that.speedX = 0;
	                that.speedY = 2;
	                that.speedVector.y = 1;
	                that.speedVector.x = 0;
	                break;
	            case enemyState.inSatge:
	                that.speedY = 0;
	                that.speedX = 1;
	                that.worldTime = 0;
	                if (that.speedVector.x == 0)
	                    that.speedVector.x = that.lastSpeedX;
	                that.speedVector.y = 0;
	                break;
	            case enemyState.attack:
	                that.attackState();
	                break;
	        }
	        that.enemyState = state;
	    };
	    GreenBoss.prototype.removeFromViewPort = function () {
	        _super.prototype.removeFromViewPort.call(this);
	    };
	    return GreenBoss;
	}(BaseEnemy));
	//# sourceMappingURL=GreenBoss.js.map

	var RedBoss = (function (_super) {
	    tslib.__extends(RedBoss, _super);
	    function RedBoss() {
	        return _super.call(this) || this;
	    }
	    RedBoss.prototype.addToViewPort = function () {
	        var that = this;
	        _super.prototype.addToViewPort.call(this);
	        that.setBody("bef1923a-10b9-4524-8d03-3363053480c0");
	        that.hitW = 316;
	        that.hitH = 140;
	        that.health = 750;
	        that.curSkillMax = 2;
	        that.x = engine.gameStage.width * 0.5 - that.bodyImg.width * 0.5;
	        that.y = -that.bodyImg.height;
	        that.enemyType = enemyType.boss;
	        that.changeState(enemyState.goStage);
	    };
	    RedBoss.prototype.updateSelf = function () {
	        _super.prototype.updateSelf.call(this);
	        var that = this;
	        switch (that.enemyState) {
	            case enemyState.goStage:
	                if (that.y >= (that.bodyImg.height * 0.5)) {
	                    that.changeState(enemyState.wait);
	                }
	                break;
	            case enemyState.inSatge:
	                that.worldTime++;
	                that.horizonBounds();
	                if (that.worldTime % 100 == 0) {
	                    that.changeState(enemyState.attack);
	                }
	                break;
	            case enemyState.attack:
	                that.horizonBounds();
	                switch (that.curSkillIndex) {
	                    case 0:
	                        that.createSplitBullet();
	                        break;
	                    case 1:
	                        that.createLaser(50);
	                        break;
	                    case 2:
	                        that.createGrapeshot();
	                        break;
	                }
	                break;
	            case enemyState.wait:
	                that.worldTime++;
	                if (that.worldTime % 60 == 0) {
	                    that.changeState(enemyState.inSatge);
	                }
	                break;
	        }
	    };
	    RedBoss.prototype.changeState = function (state) {
	        var that = this;
	        switch (state) {
	            case enemyState.goStage:
	                that.speedVector.y = 1;
	                that.speedY = 1;
	                break;
	            case enemyState.wait:
	                that.speedVector.y = 0;
	                break;
	            case enemyState.inSatge:
	                that.bossSetInStage();
	                break;
	            case enemyState.attack:
	                that.attackState();
	                break;
	        }
	        that.enemyState = state;
	    };
	    return RedBoss;
	}(BaseEnemy));
	//# sourceMappingURL=RedBoss.js.map

	var PurpleBoss = (function (_super) {
	    tslib.__extends(PurpleBoss, _super);
	    function PurpleBoss() {
	        return _super.call(this) || this;
	    }
	    PurpleBoss.prototype.addToViewPort = function () {
	        var that = this;
	        _super.prototype.addToViewPort.call(this);
	        that.setBody("b63d73e2-d7c8-4ad0-84a5-317194cdc8bf");
	        that.hitW = 318;
	        that.hitH = 104;
	        that.health = 800;
	        that.x = engine.gameStage.width * 0.5 - that.bodyImg.width * 0.5;
	        that.y = -that.bodyImg.height;
	        that.curSkillMax = 2;
	        that.enemyType = enemyType.boss;
	        that.changeState(enemyState.goStage);
	    };
	    PurpleBoss.prototype.updateSelf = function () {
	        _super.prototype.updateSelf.call(this);
	        var that = this;
	        switch (that.enemyState) {
	            case enemyState.goStage:
	                if (that.y >= (that.bodyImg.height * 0.5)) {
	                    that.changeState(enemyState.inSatge);
	                }
	                break;
	            case enemyState.inSatge:
	                that.worldTime++;
	                that.horizonBounds();
	                if (that.worldTime % 90 == 0) {
	                    that.changeState(enemyState.attack);
	                }
	                break;
	            case enemyState.attack:
	                that.horizonBounds();
	                switch (that.curSkillIndex) {
	                    case 0:
	                        that.createSpiralShot();
	                        break;
	                    case 1:
	                        that.createLaser(48);
	                        break;
	                    case 2:
	                        that.createGrapeshot();
	                        break;
	                }
	                break;
	        }
	    };
	    PurpleBoss.prototype.changeState = function (state) {
	        var that = this;
	        switch (state) {
	            case enemyState.goStage:
	                that.bossSetGoStage();
	                break;
	            case enemyState.inSatge:
	                that.bossSetInStage();
	                break;
	            case enemyState.attack:
	                that.attackState();
	                break;
	        }
	        that.enemyState = state;
	    };
	    return PurpleBoss;
	}(BaseEnemy));
	//# sourceMappingURL=PurpleBoss.js.map

	var Small = (function (_super) {
	    tslib.__extends(Small, _super);
	    function Small(x, y) {
	        var _this = _super.call(this) || this;
	        _this.x = x;
	        _this.y = y;
	        return _this;
	    }
	    Small.prototype.addToViewPort = function () {
	        var that = this;
	        _super.prototype.addToViewPort.call(this);
	        that.setBody("63bf2838-f5b8-42b7-8a81-b5a07247920a");
	        that.health = 10;
	        that.speedY = 1;
	        that.speedVector.y = 8;
	        that.hitW = 56;
	        that.hitH = 50;
	        that.enemyType = enemyType.normal;
	    };
	    Small.prototype.updateSelf = function () {
	        _super.prototype.updateSelf.call(this);
	    };
	    return Small;
	}(BaseEnemy));
	//# sourceMappingURL=Small.js.map

	var Blue = (function (_super) {
	    tslib.__extends(Blue, _super);
	    function Blue(x, y, dir) {
	        var _this = _super.call(this) || this;
	        _this.x = x;
	        _this.y = y;
	        _this.dir = dir;
	        return _this;
	    }
	    Blue.prototype.addToViewPort = function () {
	        var that = this;
	        _super.prototype.addToViewPort.call(this);
	        that.setBody("3729397b-a35a-47ce-9406-7f72f14c2513");
	        that.bodyImg.anchorX = that.bodyImg.width * 0.5;
	        that.bodyImg.anchorY = that.bodyImg.height * 0.5;
	        that.hitW = 70;
	        that.hitH = 40;
	        that.health = 10;
	        that.enemyType = enemyType.normal;
	        if (that.dir < 0) {
	            that.bodyImg.rotation = -90;
	            that.speedX = 12;
	            that.speedVector.x = 1;
	            that.speedY = 8;
	        }
	        else {
	            that.bodyImg.rotation = 90;
	            that.speedX = 12;
	            that.speedVector.x = -1;
	            that.speedY = 8;
	        }
	    };
	    Blue.prototype.updateSelf = function () {
	        var that = this;
	        _super.prototype.updateSelf.call(this);
	        if (that.dir < 0) {
	            if (that.x >= engine.gameStage.width * 3 / 4) {
	                that.speedVector.x = 0;
	            }
	            if (that.x > (engine.gameStage.width / 4 - 50)) {
	                if (that.bodyImg.rotation < 0)
	                    that.bodyImg.rotation += 2.5;
	                else
	                    that.bodyImg.rotation = 0;
	                that.speedVector.y = 1;
	            }
	        }
	        else {
	            if (that.x <= (engine.gameStage.width / 4 - 50)) {
	                that.speedVector.x = 0;
	            }
	            if (that.x < engine.gameStage.width * 3 / 4) {
	                if (that.bodyImg.rotation > 0)
	                    that.bodyImg.rotation -= 2.5;
	                else
	                    that.bodyImg.rotation = 0;
	                that.speedVector.y = 1;
	            }
	        }
	    };
	    return Blue;
	}(BaseEnemy));
	//# sourceMappingURL=Blue.js.map

	var Green = (function (_super) {
	    tslib.__extends(Green, _super);
	    function Green() {
	        return _super.call(this) || this;
	    }
	    Green.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        var that = this;
	        that.setBody("230fd63e-fb9f-4a6c-bc42-25bc4b7259f8");
	        that.y = -60;
	        that.hitW = 92;
	        that.hitH = 42;
	        that.health = 14;
	        that.speedVector.y = 1;
	        that.speedY = 4;
	        that.x = Math.floor(Math.random() * engine.gameStage.width / 4 * 2 + engine.gameStage.width / 4);
	        that.enemyType = enemyType.normal;
	    };
	    Green.prototype.updateSelf = function () {
	        _super.prototype.updateSelf.call(this);
	        this.worldTime++;
	        if (this.worldTime % 50 === 0) {
	            this.createTwoSword();
	        }
	    };
	    return Green;
	}(BaseEnemy));
	//# sourceMappingURL=Green.js.map

	var Rotary = (function (_super) {
	    tslib.__extends(Rotary, _super);
	    function Rotary() {
	        return _super.call(this) || this;
	    }
	    Rotary.prototype.addToViewPort = function () {
	        var that = this;
	        _super.prototype.addToViewPort.call(this);
	        that.setBody("febdb55f-f8c3-4a73-829c-d7acf882203b");
	        that.bodyImg.anchorX = that.bodyImg.width * 0.5;
	        that.bodyImg.anchorY = that.bodyImg.height * 0.5;
	        that.hitW = 50;
	        that.hitH = 50;
	        that.health = 10;
	        that.speedVector.y = 1;
	        that.speedY = 3;
	        that.y = -50;
	        that.x = Math.floor(Math.random() * engine.gameStage.width / 4 * 2 + engine.gameStage.width / 4);
	        that.enemyType = enemyType.normal;
	    };
	    Rotary.prototype.updateSelf = function () {
	        this.bodyImg.rotation += 5;
	        _super.prototype.updateSelf.call(this);
	        this.worldTime++;
	        if (this.worldTime % 70 == 0) {
	            this.worldTime = 0;
	            this.createFourSideShot();
	        }
	    };
	    return Rotary;
	}(BaseEnemy));
	//# sourceMappingURL=Rotary.js.map

	var Mazarine = (function (_super) {
	    tslib.__extends(Mazarine, _super);
	    function Mazarine() {
	        return _super.call(this) || this;
	    }
	    Mazarine.prototype.addToViewPort = function () {
	        var that = this;
	        _super.prototype.addToViewPort.call(this);
	        that.setBody("ed542094-674b-4ca6-9b4d-3c89e4bc46cc");
	        that.hitW = 100;
	        that.hitH = 70;
	        that.health = 10;
	        that.speedVector.y = 1;
	        that.speedY = 3;
	        that.y = -80;
	        that.x = Math.floor(Math.random() * engine.gameStage.width * 2 / 4 + engine.gameStage.width / 4);
	        that.enemyType = enemyType.normal;
	    };
	    Mazarine.prototype.updateSelf = function () {
	        _super.prototype.updateSelf.call(this);
	        this.worldTime++;
	        if (this.worldTime % 70 == 0) {
	            this.worldTime = 0;
	            this.createFourSideShot();
	        }
	    };
	    return Mazarine;
	}(BaseEnemy));
	//# sourceMappingURL=Mazarine.js.map

	var EnemyManager = (function () {
	    function EnemyManager() {
	        this.enemyArr = [];
	        window["EnemyManager"] = this;
	    }
	    Object.defineProperty(EnemyManager, "Ins", {
	        get: function () {
	            if (!this._ins) {
	                this._ins = new EnemyManager();
	            }
	            return this._ins;
	        },
	        enumerable: false,
	        configurable: true
	    });
	    EnemyManager.prototype.enemyArrRemove = function (e) {
	        var obj = e.data;
	        var index = this.enemyArr.indexOf(obj);
	        if (index >= 0) {
	            this.enemyArr.splice(index, 1);
	        }
	        if (obj && obj.parent) {
	            obj.parent.removeChild(obj);
	        }
	    };
	    EnemyManager.prototype.enemyCreate = function (view, type) {
	        var enemy;
	        var canAdd = true;
	        switch (type) {
	            case 1:
	                enemy = new BuleBoss();
	                break;
	            case 2:
	                enemy = new ThreeBallsBoss();
	                break;
	            case 3:
	                enemy = new GreenBoss();
	                break;
	            case 4:
	                enemy = new RedBoss();
	                break;
	            case 5:
	                enemy = new PurpleBoss();
	                break;
	            case 6:
	                canAdd = false;
	                var x1 = Math.floor(Math.random() * engine.gameStage.width / 4 * 2 + engine.gameStage.width / 4);
	                for (var i = 0; i < 4; i++) {
	                    var y_1 = -60 - i * 80;
	                    var enemy_1 = new Small(x1, y_1);
	                    this.enemyArr.push(enemy_1);
	                    view.addChild(enemy_1);
	                }
	                break;
	            case 7:
	                canAdd = false;
	                var y = 300;
	                var dir = 0;
	                var originX = 0;
	                if (Math.random() > 0.5) {
	                    dir = -1;
	                    originX = -100;
	                }
	                else {
	                    dir = 1;
	                    originX = engine.gameStage.width + 45;
	                }
	                for (var i = 0; i < 4; i++) {
	                    var x = originX + dir * i * 140;
	                    enemy = new Blue(x, y, dir);
	                    view.addChild(enemy);
	                    this.enemyArr.push(enemy);
	                }
	                break;
	            case 8:
	                enemy = new Green();
	                break;
	            case 9:
	                enemy = new Rotary();
	                break;
	            case 10:
	                enemy = new Mazarine();
	                break;
	        }
	        if (canAdd) {
	            this.enemyArr.push(enemy);
	            view.addChild(enemy);
	            return enemy;
	        }
	    };
	    EnemyManager.prototype.updateEnemy = function () {
	        for (var i = 0; i < this.enemyArr.length; i++) {
	            if (this.enemyArr[i] && !this.enemyArr[i].isDead) {
	                this.enemyArr[i].updateSelf();
	            }
	        }
	    };
	    EnemyManager._ins = null;
	    return EnemyManager;
	}());

	var PlayerPlane = (function (_super) {
	    tslib.__extends(PlayerPlane, _super);
	    function PlayerPlane() {
	        var _this = _super.call(this) || this;
	        _this.canShoot = false;
	        _this.bulletPool = [];
	        _this.bulletArr = [];
	        _this.maxBulletCount = 500;
	        _this.curFireLevel = 1;
	        _this.maxFireLevel = 4;
	        _this.canDamaged = true;
	        _this.damageFlashCount = 0;
	        _this.hitW = 0;
	        _this.hitH = 0;
	        _this.bulletDamage = 1;
	        _this.init();
	        return _this;
	    }
	    PlayerPlane.prototype.init = function () {
	        for (var i = 0; i < this.maxBulletCount; i++) {
	            var bullet = new PlayerBullet();
	            this.bulletPool.push(bullet);
	        }
	        this.hitW = 80;
	        this.hitH = 80;
	    };
	    PlayerPlane.prototype.addToViewPort = function () {
	        _super.prototype.addToViewPort.call(this);
	        this.planeImg = new engine.Image(getTexture("d3794d48-e936-4829-80d9-fdc81b678b9f"));
	        this.addChild(this.planeImg);
	        this.shoot();
	    };
	    PlayerPlane.prototype.fireLevelUp = function (value) {
	        var that = this;
	        if ((that.curFireLevel + value) >= that.maxFireLevel) {
	            that.curFireLevel = that.maxFireLevel;
	        }
	        else {
	            that.curFireLevel += value;
	        }
	    };
	    PlayerPlane.prototype.updateSelf = function () {
	        var that = this;
	        for (var i = 0; i < that.bulletArr.length; i++) {
	            var bullet = that.bulletArr[i];
	            if (bullet) {
	                bullet.y += bullet.speedY;
	                if (bullet.y <= -15) {
	                    bullet.parent.removeChild(bullet);
	                    that.bulletPool.push(bullet);
	                    that.bulletArr.splice(i, 1);
	                    i--;
	                    continue;
	                }
	                for (var j = 0; j < EnemyManager.Ins.enemyArr.length; j++) {
	                    var enemy = EnemyManager.Ins.enemyArr[j];
	                    if (enemy) {
	                        if (rectCollsion(bullet.x, bullet.y, enemy.x, enemy.y, bullet.width, bullet.height, enemy.hitW, enemy.hitH)) {
	                            console.log("打到了");
	                            enemy.damageHit(that.bulletDamage);
	                            bullet.parent.removeChild(bullet);
	                            that.bulletPool.push(bullet);
	                            that.bulletArr.splice(i, 1);
	                            i--;
	                            break;
	                        }
	                    }
	                }
	            }
	        }
	    };
	    PlayerPlane.prototype.move = function (x, y) {
	        var that = this;
	        var stageW = engine.gameStage.width;
	        var stageH = engine.gameStage.height;
	        if (x >= (stageW - that.planeImg.width)) {
	            that.x = stageW - that.planeImg.width;
	        }
	        else if (x <= 0) {
	            that.x = 0;
	        }
	        else {
	            that.x = x;
	        }
	        if (y <= 200) {
	            that.y = 200;
	        }
	        else if (y >= (stageH - 100)) {
	            that.y = stageH - 100;
	        }
	        else {
	            that.y = y;
	        }
	    };
	    PlayerPlane.prototype.setView = function (view) {
	        this.view = view;
	    };
	    PlayerPlane.prototype.canShootF = function (value) {
	        this.canShoot = value;
	    };
	    PlayerPlane.prototype.shoot = function () {
	        var that = this;
	        setInterval(function () {
	            if (!that.canShoot)
	                return;
	            switch (that.curFireLevel) {
	                case 1:
	                    var bullet = that.bulletPool.pop();
	                    LayerManager.Ins.bulletLayer.addChild(bullet);
	                    that.bulletArr.push(bullet);
	                    bullet.x = that.x + that.planeImg.width * 0.5 - bullet.width * 0.5;
	                    bullet.y = that.y;
	                    break;
	                case 2:
	                    for (var i = 0; i < 2; i++) {
	                        var bullet = that.bulletPool.pop();
	                        LayerManager.Ins.bulletLayer.addChild(bullet);
	                        that.bulletArr.push(bullet);
	                        bullet.x = that.x + that.planeImg.width * 0.5 - bullet.width * 0.5 - 15 + i * 30;
	                        bullet.y = that.y;
	                    }
	                    break;
	                case 3:
	                    for (var i = 0; i < 3; i++) {
	                        var bullet = that.bulletPool.pop();
	                        LayerManager.Ins.bulletLayer.addChild(bullet);
	                        that.bulletArr.push(bullet);
	                        bullet.x = that.x + that.planeImg.width * 0.5 - bullet.width * 0.5 - 15 + i * 15;
	                        bullet.y = that.y;
	                        if (i == 1) {
	                            bullet.y = that.y - 10;
	                        }
	                    }
	                    break;
	                case 4:
	                    for (var i = 0; i < 5; i++) {
	                        var bullet = that.bulletPool.pop();
	                        LayerManager.Ins.bulletLayer.addChild(bullet);
	                        that.bulletArr.push(bullet);
	                        bullet.x = that.x + that.planeImg.width * 0.5 - bullet.width * 0.5 - 30 + i * 15;
	                        if (i == 0 || i == 4) {
	                            bullet.y = that.y;
	                        }
	                        else if (i == 1 || i == 3) {
	                            bullet.y = that.y - 10;
	                        }
	                        else {
	                            bullet.y = that.y - 20;
	                        }
	                    }
	                    break;
	            }
	        }, 100);
	    };
	    PlayerPlane.prototype.getCenterP = function () {
	        var x = this.x + this.planeImg.width * 0.5;
	        var y = this.y + this.planeImg.height * 0.5;
	        return { x: x, y: y };
	    };
	    PlayerPlane.prototype.hitDamage = function (value) {
	        if (!this.canDamaged)
	            return;
	        var that = this;
	        console.log("玩家被攻击到");
	        that.canDamaged = false;
	        GameManager.INS.userHealth.reduceHealth(1);
	        engine.globalEvent.dispatchEvent("playerInjured");
	        engine.Tween.get(that, { loop: true }).to({ alpha: 0.2 }, 200).to({ alpha: 1 }, 200).call(function () {
	            that.damageFlashCount++;
	            if (that.damageFlashCount >= 4) {
	                that.canDamaged = true;
	                that.damageFlashCount = 0;
	                engine.Tween.removeTweens(that);
	            }
	        });
	    };
	    return PlayerPlane;
	}(BaseSprite));
	//# sourceMappingURL=PlayerPlane.js.map

	var TestView = (function (_super) {
	    tslib.__extends(TestView, _super);
	    function TestView() {
	        var _this = _super.call(this) || this;
	        _this.canMove = false;
	        _this.bgArr = [];
	        _this.bgMove = true;
	        _this.bgMoveSpeed = 8;
	        _this.injuredImg = null;
	        _this.imgFlashCount = 0;
	        _this.bossDead = true;
	        _this.worldTime = 0;
	        _this.bossCnt = 1;
	        _this.bossMaxCnt = 5;
	        _this.addEventListener(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    TestView.prototype.setup = function () {
	        var that = this;
	        that.removeEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
	        that.stageW = engine.gameStage.width;
	        that.stageH = engine.gameStage.height;
	        that.setLayer();
	        that.setBg();
	        that.playerPlane = new PlayerPlane();
	        that.playerPlane.x = that.stageW - that.playerPlane.width >> 1;
	        that.playerPlane.y = that.stageH - 200;
	        LayerManager.Ins.playerLayer.addChild(that.playerPlane);
	        that.playerPlane.setView(that);
	        that.playerPlane.canShootF(true);
	        GameManager.INS.playerPlane = that.playerPlane;
	        that.addEvent();
	        EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer, 10);
	        GameManager.INS.createUserHealth(LayerManager.Ins.uiLayer, 60, 60);
	        GameManager.INS.createBoomBtn(LayerManager.Ins.uiLayer, engine.gameStage.width - 120, engine.gameStage.height - 200);
	        that.injuredImg = new engine.Image(getTexture("3e931ea3-ad7a-4751-b042-108744d8fcdd"));
	        LayerManager.Ins.uiLayer.addChild(that.injuredImg);
	        that.injuredImg.visible = false;
	        that.injuredImg.alpha = 0.2;
	    };
	    TestView.prototype.setLayer = function () {
	        LayerManager.Ins.initLayer(this);
	    };
	    TestView.prototype.setBg = function () {
	        for (var i = 0; i < 2; i++) {
	            var bg = new engine.Image(getTexture("f25a0b83-e351-454f-b178-2741a36e58b6"));
	            LayerManager.Ins.bgLayer.addChild(bg);
	            bg.x = 0;
	            bg.y = -1624 + i * 1624;
	            this.bgArr.push(bg);
	        }
	    };
	    TestView.prototype.addEvent = function () {
	        var _this = this;
	        var that = this;
	        engine.gameStage.stage.addEventListener(engine.MouseEvent.MOUSE_DOWN, that.touchDown, that);
	        engine.gameStage.stage.addEventListener(engine.MouseEvent.MOUSE_MOVE, that.touchMove, that);
	        engine.gameStage.stage.addEventListener(engine.MouseEvent.MOUSE_UP, that.touchUp, that);
	        setInterval(function () {
	            that.updateGame();
	        }, 1000 / 60);
	        engine.globalEvent.addEventListener("playerInjured", function () {
	            that.injuredImg.visible = true;
	            engine.Tween.get(that.injuredImg, { loop: true }).to({ alpha: 1 }, 100).to({ alpha: 0.2 }, 100).call(function () {
	                that.imgFlashCount++;
	                if (that.imgFlashCount >= 3) {
	                    that.imgFlashCount = 0;
	                    that.injuredImg.visible = false;
	                    engine.Tween.removeTweens(that.injuredImg);
	                }
	            }, _this);
	        }, this);
	        engine.globalEvent.addEventListener("bossDead", function () {
	            that.bossDead = true;
	        }, that);
	    };
	    TestView.prototype.updateGame = function () {
	        var that = this;
	        if (that.playerPlane) {
	            that.playerPlane.updateSelf();
	        }
	        EnemyManager.Ins.updateEnemy();
	        EnemyBulletManager.Ins.updateEnemyBullet();
	        GameManager.INS.updateGame();
	        if (that.bgMove) {
	            for (var i = 0; i < that.bgArr.length; i++) {
	                that.bgArr[i].y += that.bgMoveSpeed;
	                if (that.bgArr[i].y >= 1624) {
	                    that.bgArr[i].y = -1624;
	                }
	            }
	        }
	        if (that.bossCnt <= that.bossMaxCnt) {
	            if (that.bossDead) {
	                that.worldTime++;
	                if (that.worldTime % 150 == 0) {
	                    EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer, that.bossCnt);
	                    that.bossCnt++;
	                    that.bossDead = false;
	                    that.worldTime = 0;
	                    if (that.bossCnt > that.bossMaxCnt) ;
	                }
	            }
	        }
	        else {
	            that.worldTime++;
	            if (that.worldTime % 80 == 0) {
	                if (EnemyManager.Ins.enemyArr.length < 12)
	                    EnemyManager.Ins.enemyCreate(LayerManager.Ins.enemyLayer, Math.floor(Math.random() * 5 + 6));
	                that.worldTime = 0;
	            }
	        }
	    };
	    TestView.prototype.touchDown = function (e) {
	        this.offsetX = e.stageX - this.playerPlane.x;
	        this.offsetY = e.stageY - this.playerPlane.y;
	        this.canMove = true;
	    };
	    TestView.prototype.touchMove = function (e) {
	        if (!this.canMove)
	            return;
	        var x = e.stageX - this.offsetX;
	        var y = e.stageY - this.offsetY;
	        this.playerPlane.move(x, y);
	    };
	    TestView.prototype.touchUp = function () {
	        this.canMove = false;
	    };
	    return TestView;
	}(engine.Container));
	//# sourceMappingURL=TestView.js.map

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener("pictures-set", _this.set, _this);
	        var testView = _this._testView = new TestView();
	        _this.addChild(testView);
	        return _this;
	    }
	    GameWrapper.prototype.set = function (event) {
	        injectProps(event.data);
	    };
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	    };
	    GameWrapper.prototype.stop = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map