/**
 * Created by rockyl on 2020-01-09.
 */

import GameView from "./GameView";
import { injectProps } from "../props";


export class GameWrapper extends engine.Container {
	private _status;
	private _gameView: GameView;


	constructor() {
		super();
		/*
		event-pickTeaGame-init //游戏初始化
		//event-wait-uplevel //待升级
		event-add-oneScore //+1
		event-pick-tea //采茶叶
		event-tea-skyup //茶叶向上飞
		event-hand-grasp //手抓去
		event-change-TeaNum //茶叶数量  改变svga动画
		event-getBasket-Type //获得篮子类型
		event-setBasket-Type //设置篮子类型
		*/
		// event-getchange-TeaNum //茶叶数量{初始值totalNum，总量nowNum} 改变svga动画
		// event-getBasket-Type //获得篮子类型
		// event-hand-grasp //手抓去

		//event-pickTeaGame-init 游戏初始化
		engine.globalEvent.addEventListener('event-pickTeaGame-init', this.reset, this);

		engine.globalEvent.addEventListener('event-hand-grasp', this.handGrasp, this);
		engine.globalEvent.addEventListener('event-getClick-person', this.clickPerson, this);
		engine.globalEvent.addEventListener('event-getchange-TeaNum', this.setTeaNum, this);
		engine.globalEvent.addEventListener('event-getBasket-Type', this.setPickTeaLevel, this);



		let gameView = this._gameView = new GameView();
		this.addChild(gameView);
	}

	//设置茶叶数量
	setTeaNum(event: engine.Event) {
		injectProps(event.data);
		this._gameView.setTeaNum(event.data);
	}

	//设置茶蓝等级
	setPickTeaLevel(event: engine.Event) {
		injectProps(event.data);
		this._gameView.setPickTeaLevel(event.data);
	}
	
	handGrasp() {
		this._gameView.handGrasp();
	}
	//点击人物
	clickPerson() {
		this._gameView.showVerse();
	}
	reset(event: engine.Event) {
		injectProps(event.data);
		this._gameView.visible = true;
		this._gameView.reset();
	}


	start(event: engine.Event) {
		injectProps(event.data);
		this._status = 1;
		this._gameView.start();
	}

	pause() {
		this._gameView.pause();
	}

	resume() {
		this._gameView.resume();
	}

	revive() {
		this._gameView.revive();
	}

	clear() {
		this._gameView.visible = false;
	}





	private onTap(event) {
		//	this._gameView.tap(event);
	}
}
