/**
 * Created by rockyl on 2018/8/16.
 */

import { props } from "../props";
import ObjectPool = engine.ObjectPool;
import { getTextureByName, createSvga } from "./utils";

export default class GameView extends engine.Container {
  private _hasSetup;
  
  //npc层
  private NpcBg: engine.Container;
  //底座
  private bottomCircle: engine.Container;
  //爱心点缀
  private loveDot: engine.Container;
  //礼盒
  private giftboxSvga;
  //礼盒前动画
  private giftAfterSvga
  
	private rect;

  constructor() {
    super();
    this.once(engine.Event.ADDED_TO_STAGE, this.setup, this);
  }

  setup() {
    if (this._hasSetup) {
      return;
    }

    this._hasSetup = true;

    this.NpcBg = new engine.Container();
    this.NpcBg.x = props.initX;
    this.NpcBg.y = props.initY;
    this.addChild(this.NpcBg);
    this.bottomCircle = new engine.Sprite(getTextureByName('底座'));
    this.bottomCircle.x = 17;
    this.bottomCircle.y = 305;
    this.loveDot = new engine.Sprite(getTextureByName('点缀'));
    this.loveDot.x = 0;
    this.loveDot.y = 6;

    this.giftboxSvga = createSvga('初始礼盒');
    this.giftboxSvga.x = 105;
    this.giftboxSvga.y = 37;
    this.giftAfterSvga = createSvga("拆礼盒");
    this.giftAfterSvga.x = 105;
    this.giftAfterSvga.y = 0;
    this.giftAfterSvga.visible = false;
    this.NpcBg.addChild(this.bottomCircle);
    this.NpcBg.addChild(this.giftboxSvga);
    this.NpcBg.addChild(this.giftAfterSvga);
    this.NpcBg.addChild(this.loveDot);
    this.giftboxSvga.play(false, true)
		// this.rect = new engine.Rect();
    // this.rect.width = props.gameStageWidth;
    // this.rect.height = props.gameStageHeight;
		// this.rect.x = 0;
		// this.rect.y = 0;
		// this.addChild(this.rect);

    // this.NpcBg.mask = this.rect;
	}
  /**
   * 重置场景
   */
  reset() {
    this.giftboxSvga.visible = true;
    this.giftAfterSvga.visible = false;
  }

  /**
   * 开始
   */
  start() {
    this.giftAfterSvga.visible = true;
    this.giftboxSvga.visible = false;
    this.giftAfterSvga.play(false, false)
    this.giftAfterSvga.once(engine.Event.END_FRAME, () => {
      engine.globalEvent.dispatchEvent('open-gift-game-end');
    }, this);
  }

  /**
   * 重新开始
   */
  resume() {
    this.reset();
    this.start();
  }
}
