(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['open-gift'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	function createSvga(name, anchorName) {
	    var inst = new svga.Svga();
	    inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	    return inst;
	}
	//# sourceMappingURL=utils.js.map

	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.setup = function () {
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        this.NpcBg = new engine.Container();
	        this.NpcBg.x = props.initX;
	        this.NpcBg.y = props.initY;
	        this.addChild(this.NpcBg);
	        this.bottomCircle = new engine.Sprite(getTextureByName('底座'));
	        this.bottomCircle.x = 17;
	        this.bottomCircle.y = 305;
	        this.loveDot = new engine.Sprite(getTextureByName('点缀'));
	        this.loveDot.x = 0;
	        this.loveDot.y = 6;
	        this.giftboxSvga = createSvga('初始礼盒');
	        this.giftboxSvga.x = 105;
	        this.giftboxSvga.y = 37;
	        this.giftAfterSvga = createSvga("拆礼盒");
	        this.giftAfterSvga.x = 105;
	        this.giftAfterSvga.y = 0;
	        this.giftAfterSvga.visible = false;
	        this.NpcBg.addChild(this.bottomCircle);
	        this.NpcBg.addChild(this.giftboxSvga);
	        this.NpcBg.addChild(this.giftAfterSvga);
	        this.NpcBg.addChild(this.loveDot);
	        this.giftboxSvga.play(false, true);
	    };
	    GameView.prototype.reset = function () {
	        this.giftboxSvga.visible = true;
	        this.giftAfterSvga.visible = false;
	    };
	    GameView.prototype.start = function () {
	        this.giftAfterSvga.visible = true;
	        this.giftboxSvga.visible = false;
	        this.giftAfterSvga.play(false, false);
	        this.giftAfterSvga.once(engine.Event.END_FRAME, function () {
	            engine.globalEvent.dispatchEvent('open-gift-game-end');
	        }, this);
	    };
	    GameView.prototype.resume = function () {
	        this.reset();
	        this.start();
	    };
	    return GameView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('open-gift-game-init', _this.reset, _this);
	        engine.globalEvent.addEventListener('open-gift-game-start', _this.start, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        return _this;
	    }
	    GameWrapper.prototype.reset = function (event) {
	        injectProps(event.data);
	        this._gameView.visible = true;
	        this._gameView.reset();
	    };
	    GameWrapper.prototype.start = function (event) {
	        console.log('监听开始');
	        injectProps(event.data);
	        this._gameView.start();
	    };
	    GameWrapper.prototype.clear = function () {
	        this._gameView.visible = false;
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map