

import {props} from '../props'
import { getTexture } from "./utils";

const W = 600
const H = 600
const MAX_ROW = 3;
const MAX_COL = 3;
const GAP = 10;
const w = W / MAX_COL;
const h = H / MAX_ROW;




export default class GameView extends engine.Container{


    constructor(){
        super()
        this.once(engine.Event.ADDED_TO_STAGE,this.setup,this);

    }

    start(){



    }

    pictures:engine.Sprite[]
    private picturesWrapper: engine.Sprite;

    setup(){

        const getSprites = this.cutPicture(this.picturesWrapper,props.picUrl,MAX_ROW,MAX_COL)
        this.pictures = getSprites[0];
        


        const parent = new engine.Sprite();
        this.picturesWrapper = parent;
        this.addChild(parent);




    }

    // 切图
    cutPicture(parent, url, MAX_ROW, MAX_COL){

        const sprite = []
        const spritePos = []

        // 正确的图片顺序
        for(let row = 0; row < MAX_ROW; row++) {
            for(let col = 0; col < MAX_COL; col++) {
                // 创建图片子节点
                const child = engine.Sprite.fromImage(url);
                sprite.push(child)
                child.scaleX = 1 / MAX_COL;
                child.scaleY = 1 / MAX_ROW; 
                parent.addChild(child);
                child.x = col * (W / MAX_COL + GAP);
                child.y = row * (H / MAX_ROW + GAP);

                spritePos.push([child.x,child.y]);

                child.addEventListener(engine.Event.COMPLETE, () => {
                    const uvs = new Float32Array([
                        col / MAX_COL,
                        row / MAX_ROW,
                        (col + 1) / MAX_COL,
                        row / MAX_ROW,
                        (col + 1) / MAX_COL,
                        (row + 1) / MAX_ROW,
                        col / MAX_COL,
                        (row + 1) / MAX_ROW,
                    ]);
            
                    child.uvs = uvs;
                });
            }
        }

        return [sprite,spritePos];
    }

    // 随机函数
    getRandomArray(array){
        array.sort(()=>{
            return 0.5 - Math.random();
        })
    }


}