/**
 * Created by rockyl on 2020-02-02.
 *
 * 口红
 */
import {getTextureByName} from "./utils";
import {props} from "../props";

export class Stick extends engine.Container {
	private _body: engine.Sprite;
	private _toY;

	constructor() {
		super();

		let body = this._body = new engine.Sprite(getTextureByName('口红素材'));
		body.anchorY = this._body.height / 2;
		body.x = -body.width / 2;
		this.addChild(body);
	}

	reset() {
		this.visible = true;
		this.rotation = 0;
		this.anchorOffsetY = 0;
		let body = this._body;
		body.y = 0;
		body.rotation = 0;
	}

	playSend(y, callback) {
		this._toY = y;
		engine.Tween.get(this)
			.to({y}, props.stickSendDuration)
			.call(callback);
	}

	stopSend() {
		engine.Tween.removeTweens(this);
	}

	playFall() {
		return new Promise(resolve => {
			engine.Tween.get(this, null, null, true)
				.to({rotation: 30, y: this._toY + props.stickFallDistance}, 500, engine.Ease.cubicOut)
				.call(resolve);
		})

	}

	set anchorOffsetY(v) {
		this._body.y = v;
	}
}
