/**
 * Created by rockyl on 2020-01-30.
 */
import {props} from "../props";
import {getTextureByName} from "./utils";

export class GuideLayer extends engine.Container {
	private guideMask: engine.Container;
	private label: engine.Label;

	constructor() {
		super();

		this.setup();
	}

	private setup() {

	}

	show(id, options) {
		return new Promise(resolve => {
			this.visible = true;
			if (!this.guideMask) {
				const {width, height} = this.stage;
				let guideMask = this.guideMask = new engine.Container();

				let guideHole = new engine.Image(getTextureByName('引导遮罩'));
				guideHole.x = (width - guideHole.width) / 2;
				guideHole.y = options.y;
				guideMask.addChild(guideHole);

				this.createRect(guideMask, 0, 0, width, guideHole.y);
				this.createRect(guideMask, 0, guideHole.y, guideHole.x, guideHole.height);
				this.createRect(guideMask, guideHole.x + guideHole.width, guideHole.y, width - guideHole.x - guideHole.width, guideHole.height);
				this.createRect(guideMask, 0, guideHole.y + guideHole.height, width, height - guideHole.y - guideHole.height);

				let label = this.label = new engine.Label();
				label.fillColor = 'white';
				label.size = 25;
				label.text = props.guideText;
				label.x = (width - label.width) / 2;
				label.y = guideHole.y + guideHole.height + 50;
				guideMask.addChild(label);

				this.addChild(guideMask);
			}
			this.once(engine.MouseEvent.CLICK, function(){
				this.visible = false;
				resolve();
			}, this);
		})
	}

	createRect(container, x, y, width, height) {
		let rect = new engine.Rect();
		rect.x = x;
		rect.y = y;
		rect.width = width;
		rect.height = height;
		rect.fillColor = 'black';
		rect.alpha = 0.7;

		container.addChild(rect);
	}
}
