/**
 * Created by rockyl on 2020-01-09.
 */

import GameView from "./GameView";
import {injectProps} from "../props";

export class GameWrapper extends engine.Container {
	private _status;
	private _gameView: GameView;
	private _touchLayer: engine.Container;

	constructor() {
		super();

		engine.globalEvent.addEventListener('lipstick-turntable-reset', this.reset, this);
		engine.globalEvent.addEventListener('lipstick-turntable-start', this.start, this);
		engine.globalEvent.addEventListener('lipstick-turntable-pause', this.pause, this);
		engine.globalEvent.addEventListener('lipstick-turntable-resume', this.resume, this);
		engine.globalEvent.addEventListener('lipstick-turntable-revive', this.revive, this);
		engine.globalEvent.addEventListener('lipstick-turntable-clear', this.clear, this);

		this.addEventListener(engine.MouseEvent.CLICK, this.onTap, this);

		let gameView = this._gameView = new GameView();
		this.addChild(gameView);

		let touchLayer = this._touchLayer = new engine.Container();
		this.addChild(touchLayer);

		setTimeout(this.onAddedToStage, 100);
		//this.once(engine.Event.ENTER_FRAME, this.onAddedToStage, this);
	}

	private onAddedToStage=()=> {
		let p = this.globalToLocal(new engine.Point());

		let touchLayer = this._touchLayer;
		touchLayer.x = p.x;
		touchLayer.y = p.y;
		//touchLayer.fillColor = 0xFFFF00;
		//touchLayer.strokeWidth = 1;
		touchLayer.width = engine.gameStage.width;
		touchLayer.height = engine.gameStage.height;
	}

	reset(event: engine.Event) {
		injectProps(event.data);
		this._gameView.visible = true;
		this._gameView.reset(false, event.data);
	}

	start(event: engine.Event) {
		injectProps(event.data);

		this._status = 1;

		this._gameView.start();
	}

	pause() {
		this._gameView.pause();
	}

	resume() {
		this._gameView.resume();
	}

	revive() {
		this._gameView.revive();
	}

	clear() {
		this._gameView.visible = false;
	}

	private onTap(event) {
		this._gameView.tap(event);
	}
}
