(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['lipstick-turntable'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	//# sourceMappingURL=utils.js.map

	var GuideLayer = (function (_super) {
	    tslib.__extends(GuideLayer, _super);
	    function GuideLayer() {
	        var _this = _super.call(this) || this;
	        _this.setup();
	        return _this;
	    }
	    GuideLayer.prototype.setup = function () {
	    };
	    GuideLayer.prototype.show = function (id, options) {
	        var _this = this;
	        return new Promise(function (resolve) {
	            _this.visible = true;
	            if (!_this.guideMask) {
	                var _a = _this.stage, width = _a.width, height = _a.height;
	                var guideMask = _this.guideMask = new engine.Container();
	                var guideHole = new engine.Image(getTextureByName('引导遮罩'));
	                guideHole.x = (width - guideHole.width) / 2;
	                guideHole.y = options.y;
	                guideMask.addChild(guideHole);
	                _this.createRect(guideMask, 0, 0, width, guideHole.y);
	                _this.createRect(guideMask, 0, guideHole.y, guideHole.x, guideHole.height);
	                _this.createRect(guideMask, guideHole.x + guideHole.width, guideHole.y, width - guideHole.x - guideHole.width, guideHole.height);
	                _this.createRect(guideMask, 0, guideHole.y + guideHole.height, width, height - guideHole.y - guideHole.height);
	                var label = _this.label = new engine.Label();
	                label.fillColor = 'white';
	                label.size = 25;
	                label.text = props.guideText;
	                label.x = (width - label.width) / 2;
	                label.y = guideHole.y + guideHole.height + 50;
	                guideMask.addChild(label);
	                _this.addChild(guideMask);
	            }
	            _this.once(engine.MouseEvent.CLICK, function () {
	                this.visible = false;
	                resolve();
	            }, _this);
	        });
	    };
	    GuideLayer.prototype.createRect = function (container, x, y, width, height) {
	        var rect = new engine.Rect();
	        rect.x = x;
	        rect.y = y;
	        rect.width = width;
	        rect.height = height;
	        rect.fillColor = 'black';
	        rect.alpha = 0.7;
	        container.addChild(rect);
	    };
	    return GuideLayer;
	}(engine.Container));
	//# sourceMappingURL=GuideLayer.js.map

	var Stick = (function (_super) {
	    tslib.__extends(Stick, _super);
	    function Stick() {
	        var _this = _super.call(this) || this;
	        var body = _this._body = new engine.Sprite(getTextureByName('口红素材'));
	        body.anchorY = _this._body.height / 2;
	        body.x = -body.width / 2;
	        _this.addChild(body);
	        return _this;
	    }
	    Stick.prototype.reset = function () {
	        this.visible = true;
	        this.rotation = 0;
	        this.anchorOffsetY = 0;
	        var body = this._body;
	        body.y = 0;
	        body.rotation = 0;
	    };
	    Stick.prototype.playSend = function (y, callback) {
	        this._toY = y;
	        engine.Tween.get(this)
	            .to({ y: y }, props.stickSendDuration)
	            .call(callback);
	    };
	    Stick.prototype.stopSend = function () {
	        engine.Tween.removeTweens(this);
	    };
	    Stick.prototype.playFall = function () {
	        var _this = this;
	        return new Promise(function (resolve) {
	            engine.Tween.get(_this, null, null, true)
	                .to({ rotation: 30, y: _this._toY + props.stickFallDistance }, 500, engine.Ease.cubicOut)
	                .call(resolve);
	        });
	    };
	    Object.defineProperty(Stick.prototype, "anchorOffsetY", {
	        set: function (v) {
	            this._body.y = v;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return Stick;
	}(engine.Container));
	//# sourceMappingURL=Stick.js.map

	var ObjectPool = engine.ObjectPool;
	var PoolName = 'stick';
	ObjectPool.registerPool(PoolName, function () {
	    return new Stick();
	}, function (item, data) {
	    item.reset();
	});
	//# sourceMappingURL=object-pool-init.js.map

	var BreakUpPart = (function (_super) {
	    tslib.__extends(BreakUpPart, _super);
	    function BreakUpPart(turntable, from, to) {
	        var _this = _super.call(this) || this;
	        var body = _this._body = new engine.Image();
	        _this.addChild(body);
	        var mask = _this._body.mask = new engine.Graphics();
	        _this.addChild(mask);
	        _this._turntable = turntable;
	        _this._from = from;
	        _this._to = to;
	        _this._fromR = from * Math.PI / 180;
	        _this._toR = to * Math.PI / 180;
	        return _this;
	    }
	    BreakUpPart.prototype.updateMask = function () {
	        var mask = this._body.mask;
	        mask.beginFill(0xff0000);
	        mask.moveTo(0, 0);
	        mask.arc(0, 0, this._turntable.radius + 5, this._fromR, this._toR);
	        mask.endFill();
	        var _a = props.breakUpDistanceRange, min = _a[0], max = _a[1];
	        var mid = (this._toR - this._fromR) / 2 + this._fromR;
	        this.x = Math.cos(mid) * Math.random() * max + min;
	        this.y = Math.sin(mid) * Math.random() * max + min;
	        this.alpha = 1;
	        this.rotation = 0;
	    };
	    BreakUpPart.prototype.playFall = function (rotation) {
	        var _this = this;
	        this._body.rotation = rotation;
	        return new Promise(function (resolve) {
	            var angle = (_this._to - _this._from) / 2 + _this._from;
	            var rotation = (angle > 270 ? 360 : 0) + 90 - angle;
	            engine.Tween.get(_this, null, null, true)
	                .to({ y: _this.y + props.turntableFallDistance, alpha: 0, rotation: rotation }, props.turntableFallDuration, engine.Ease.cubicIn)
	                .call(resolve);
	        });
	    };
	    Object.defineProperty(BreakUpPart.prototype, "body", {
	        get: function () {
	            return this._body;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return BreakUpPart;
	}(engine.Container));
	//# sourceMappingURL=BreakUpPart.js.map

	var ObjectPool$1 = engine.ObjectPool;
	var Turntable = (function (_super) {
	    tslib.__extends(Turntable, _super);
	    function Turntable() {
	        var _this = _super.call(this) || this;
	        _this._items = [];
	        var wrapper = _this._wrapper = new engine.Container();
	        _this.addChild(wrapper);
	        var stickContainer = _this._stickContainer = new engine.Container();
	        wrapper.addChild(stickContainer);
	        var body = _this._body = new engine.Image();
	        wrapper.addChild(body);
	        var breakUpContainer = _this._breakUpContainer = new engine.Container();
	        for (var i = 0, li = props.breakUpRatios.length - 1; i < li; i++) {
	            var part = new BreakUpPart(_this, props.breakUpRatios[i], props.breakUpRatios[i + 1]);
	            breakUpContainer.addChild(part);
	        }
	        breakUpContainer.visible = false;
	        _this.addChild(breakUpContainer);
	        return _this;
	    }
	    Turntable.prototype.resetAsset = function (body, asset) {
	        body.source = asset;
	        body.x = -body.width / 2;
	        body.y = -body.height / 2;
	        body.anchorX = -body.x;
	        body.anchorY = -body.y;
	    };
	    Turntable.prototype.reset = function (options) {
	        var turntableAssetName = options.turntableAssetName;
	        this.rotationRange = props.rotationRange;
	        var body = this._body;
	        body.visible = true;
	        this.resetAsset(body, turntableAssetName);
	        this._radius = body.width / 2;
	        this.hideSticks();
	        for (var _i = 0, _a = this._breakUpContainer.children; _i < _a.length; _i++) {
	            var part = _a[_i];
	            this.resetAsset(part.body, turntableAssetName);
	            part.updateMask();
	        }
	        this._breakUpContainer.visible = false;
	    };
	    Object.defineProperty(Turntable.prototype, "radius", {
	        get: function () {
	            return this._radius;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Turntable.prototype.start = function () {
	        this._dir = 1;
	        this._items.splice(0);
	        this.rotateOnce();
	    };
	    Turntable.prototype.pause = function () {
	        engine.Tween.pauseTweens(this._wrapper);
	    };
	    Turntable.prototype.resume = function () {
	        engine.Tween.resumeTweens(this._wrapper);
	    };
	    Turntable.prototype.addStick = function (stick) {
	        var angle = this.parseAngle(this._wrapper.rotation);
	        var minDis = props.stickAngle * 2;
	        var hitOn = false;
	        for (var _i = 0, _a = this._items; _i < _a.length; _i++) {
	            var item = _a[_i];
	            if (Math.abs(item - angle) < minDis) {
	                hitOn = true;
	                break;
	            }
	        }
	        if (hitOn) {
	            this.pause();
	        }
	        else {
	            this._items.push(angle);
	            stick.anchorOffsetY = stick.y;
	            stick.y = 0;
	            stick.rotation = -this._wrapper.rotation;
	            this._stickContainer.addChild(stick);
	            this.shake();
	        }
	        return hitOn;
	    };
	    Turntable.prototype.parseAngle = function (r) {
	        var round = r % 360;
	        if (round < 0) {
	            round += 360;
	        }
	        return round;
	    };
	    Turntable.prototype.hideSticks = function () {
	        for (var _i = 0, _a = this._stickContainer.children; _i < _a.length; _i++) {
	            var stick = _a[_i];
	            ObjectPool$1.recycleObject(PoolName, stick);
	        }
	        this._stickContainer.removeChildren();
	    };
	    Turntable.prototype.playBreakUp = function () {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var p, _i, _a, part;
	            return tslib.__generator(this, function (_b) {
	                switch (_b.label) {
	                    case 0:
	                        this.pause();
	                        this._body.visible = false;
	                        this._breakUpContainer.visible = true;
	                        for (_i = 0, _a = this._breakUpContainer.children; _i < _a.length; _i++) {
	                            part = _a[_i];
	                            p = part.playFall(this._wrapper.rotation);
	                        }
	                        return [4, p];
	                    case 1:
	                        _b.sent();
	                        return [2];
	                }
	            });
	        });
	    };
	    Turntable.prototype.shake = function () {
	        engine.Tween.get(this, null, null, true)
	            .to({ y: this.y - 5 }, 50)
	            .to({ y: this.y }, 50);
	    };
	    Turntable.prototype.rotateOnce = function () {
	        var _a = this.rotationRange, min = _a[0], max = _a[1];
	        var dealtRotation = Math.random() * max + min;
	        var duration = dealtRotation * (Math.random() * props.rotationDurationMultipleRandom + props.rotationDurationMultipleBase);
	        var rotation = this._wrapper.rotation + this._dir * dealtRotation;
	        this._dir *= -1;
	        engine.Tween.get(this._wrapper, null, null, true)
	            .to({ rotation: rotation }, duration)
	            .call(this.rotateOnce, this);
	    };
	    return Turntable;
	}(engine.Container));
	//# sourceMappingURL=Turntable.js.map

	var ObjectPool$2 = engine.ObjectPool;
	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this.countDownStep = function (decrease) {
	            if (decrease === void 0) { decrease = true; }
	            if (decrease) {
	                _this._countdown--;
	                if (_this._countdown <= 0) {
	                    _this.stopCountDown();
	                    _this.onTimeout();
	                }
	            }
	            engine.globalEvent.dispatchEvent('lipstick-turntable-countdown', {
	                second: _this._countdown,
	            });
	        };
	        _this.onHit = function () { return tslib.__awaiter(_this, void 0, void 0, function () {
	            var stick;
	            return tslib.__generator(this, function (_a) {
	                switch (_a.label) {
	                    case 0:
	                        stick = this._stick;
	                        if (!this.turntable.addStick(stick)) return [3, 2];
	                        this.stopCountDown();
	                        return [4, stick.playFall()];
	                    case 1:
	                        _a.sent();
	                        engine.globalEvent.dispatchEvent('lipstick-turntable-game-failed', {
	                            reason: 2,
	                        });
	                        return [3, 5];
	                    case 2:
	                        this._counting--;
	                        engine.globalEvent.dispatchEvent('lipstick-turntable-hit', {
	                            remain: this._counting,
	                        });
	                        if (!(this._counting === 0)) return [3, 4];
	                        this.turntable.hideSticks();
	                        this.stopCountDown();
	                        return [4, this.turntable.playBreakUp()];
	                    case 3:
	                        _a.sent();
	                        engine.globalEvent.dispatchEvent('lipstick-turntable-game-success');
	                        return [3, 5];
	                    case 4:
	                        this.prepareStick();
	                        _a.label = 5;
	                    case 5: return [2];
	                }
	            });
	        }); };
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.setup = function () {
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        var turntable = this.turntable = new Turntable();
	        this.addChild(turntable);
	        var guideLayer = this.guideLayer = new GuideLayer();
	        this.addChild(guideLayer);
	    };
	    GameView.prototype.reset = function (revive, options) {
	        if (options === void 0) { options = null; }
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            return tslib.__generator(this, function (_a) {
	                if (options) {
	                    this.turntable.reset(options);
	                    this.recycleStick();
	                }
	                else {
	                    this.prepareStick();
	                }
	                return [2];
	            });
	        });
	    };
	    GameView.prototype.start = function () {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            return tslib.__generator(this, function (_a) {
	                this._countdown = props.countDown;
	                this._counting = props.lipstickCount;
	                this.turntable.start();
	                this.prepareStick();
	                this.countDownStep(false);
	                this.startCountDown();
	                return [2];
	            });
	        });
	    };
	    GameView.prototype.startCountDown = function () {
	        this._timer = setInterval(this.countDownStep, 1000);
	    };
	    GameView.prototype.stopCountDown = function () {
	        if (this._timer) {
	            clearInterval(this._timer);
	            this._timer = null;
	        }
	    };
	    GameView.prototype.prepareStick = function () {
	        var stick = this._stick = ObjectPool$2.getObject(PoolName);
	        stick.y = props.stickDistance;
	        this.addChildAt(stick, 0);
	        this._touchEnabled = true;
	    };
	    GameView.prototype.recycleStick = function () {
	        var stick = this._stick;
	        if (stick) {
	            this._stick = null;
	            this.removeChild(stick);
	            ObjectPool$2.recycleObject(PoolName, stick);
	        }
	    };
	    GameView.prototype.pause = function () {
	        this.turntable.pause();
	        this._stick.stopSend();
	        this._stick.playFall();
	        this.stopCountDown();
	    };
	    GameView.prototype.resume = function () {
	        this.recycleStick();
	        this.turntable.resume();
	        this.startCountDown();
	    };
	    GameView.prototype.revive = function () {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            return tslib.__generator(this, function (_a) {
	                this.recycleStick();
	                this.prepareStick();
	                this.turntable.resume();
	                return [2];
	            });
	        });
	    };
	    GameView.prototype.onTimeout = function () {
	        this.pause();
	        this._touchEnabled = false;
	        engine.globalEvent.dispatchEvent('lipstick-turntable-game-failed', {
	            reason: 1,
	        });
	    };
	    GameView.prototype.tap = function (e) {
	        if (!this._touchEnabled) {
	            return;
	        }
	        this._touchEnabled = false;
	        this._stick.playSend(this.turntable.radius - props.stickInsertDepth, this.onHit);
	    };
	    return GameView;
	}(engine.Container));
	//# sourceMappingURL=GameView.js.map

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        _this.onAddedToStage = function () {
	            var p = _this.globalToLocal(new engine.Point());
	            var touchLayer = _this._touchLayer;
	            touchLayer.x = p.x;
	            touchLayer.y = p.y;
	            touchLayer.width = engine.gameStage.width;
	            touchLayer.height = engine.gameStage.height;
	        };
	        engine.globalEvent.addEventListener('lipstick-turntable-reset', _this.reset, _this);
	        engine.globalEvent.addEventListener('lipstick-turntable-start', _this.start, _this);
	        engine.globalEvent.addEventListener('lipstick-turntable-pause', _this.pause, _this);
	        engine.globalEvent.addEventListener('lipstick-turntable-resume', _this.resume, _this);
	        engine.globalEvent.addEventListener('lipstick-turntable-revive', _this.revive, _this);
	        engine.globalEvent.addEventListener('lipstick-turntable-clear', _this.clear, _this);
	        _this.addEventListener(engine.MouseEvent.CLICK, _this.onTap, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        var touchLayer = _this._touchLayer = new engine.Container();
	        _this.addChild(touchLayer);
	        setTimeout(_this.onAddedToStage, 100);
	        return _this;
	    }
	    GameWrapper.prototype.reset = function (event) {
	        injectProps(event.data);
	        this._gameView.visible = true;
	        this._gameView.reset(false, event.data);
	    };
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	        this._status = 1;
	        this._gameView.start();
	    };
	    GameWrapper.prototype.pause = function () {
	        this._gameView.pause();
	    };
	    GameWrapper.prototype.resume = function () {
	        this._gameView.resume();
	    };
	    GameWrapper.prototype.revive = function () {
	        this._gameView.revive();
	    };
	    GameWrapper.prototype.clear = function () {
	        this._gameView.visible = false;
	    };
	    GameWrapper.prototype.onTap = function (event) {
	        this._gameView.tap(event);
	    };
	    return GameWrapper;
	}(engine.Container));

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map