/**
 * Created by rockyl on 2019-12-16.
 */

const customId = 'lipstick-turntable';

(async function () {
	let customModule = await fetch(`../meta.json`);
	customModule = await customModule.json();
	console.log(customModule);

	await loadAssets(customModule.assets);
	launchWithCustomModule(customModule);
})();

function launchWithCustomModule(customModule) {
	//engine.registerCustomCodeModule(customModule);
	engine.registerCustomModule(customId, window[customId]);

	const {props: propsOption, assets} = customModule;
	let props = engine.computeProps(customModuleProps, propsOption);
	const customModuleIns = {
		id: customId,
		props,
		assets,
	};

	engine.registerCustomModules([customModuleIns]);
	engine.launchWithConfig({
		options: {
			entrySceneView: 'entry',
		},
		assets: [],
		views: [{
			name: 'entry',
			type: 'node',
			properties: {
				x: 375,
				y: 400,
			}
		}],
	}, null, function () {
		setTimeout(() => {
			engine.addCustomModule(customId, engine.gameStage.sceneContainer.getChildAt(0));
		}, 100);

		setTimeout(() => {
			engine.globalEvent.dispatchEvent('lipstick-turntable-reset', {
				turntableAssetName: '橘色转盘',
				countDown: 5,
			});
			engine.globalEvent.dispatchEvent('lipstick-turntable-start');
		}, 500);
	});

	engine.globalEvent.addEventListener('lipstick-turntable-game-success', (e) => {
		console.log(e.type, e.data);
	});
	engine.globalEvent.addEventListener('lipstick-turntable-game-failed', (e) => {
		console.log(e.type, e.data);
	});
	engine.globalEvent.addEventListener('lipstick-turntable-hit', (e) => {
		console.log(e.type, e.data);
	});
	engine.globalEvent.addEventListener('lipstick-turntable-countdown', (e) => {
		console.log(e.type, e.data);
	});

}

function getAssetByUUID(uuid) {
	return engine.resolveCustomAsset(customId, uuid);
}

function getProps() {
	return engine.getProps(customId);
}
