
export default class SoundMgr {
	private static _instance: SoundMgr = null;
	public static get instance(): SoundMgr {
		if (!this._instance) {
			this._instance = new SoundMgr();
		}

		return this._instance;
	}

	public get enabled() {
		return engine.env.soundEnabled;
	}

	public playEffect(name: string, loop: boolean = false) {
		//if (!this.enabled) return;

		engine.playSound(getAssetByUUID(nameToUuid[name]).uuid, {
			loop,
			keep: true
		}, name);
	}
	public stopEffect(name: string){
		engine.stopSound(name);
		engine.destroySound(name);
	}


}

const nameToUuid = {
	bgm: "da826400-c835-4b75-8991-a29b64c5ac0b",
	prize: "6b809f4e-1712-4201-beed-a683294ded02",
	ghost:  "dc4426e3-cfe0-492e-bf74-002e0eb605cf",
	jumpdied: "f3f66910-8af2-4ceb-b7b3-27329a8ca93b",
}