import { getTextureByName } from './utils';
import { props } from '../props';
import { createSvga } from './utils';
interface PlatformProps {
  width: number;
  height: number;
  x: number;
  y: number;
  count: number;
}

export class Platform extends engine.Container {
  private _body: engine.Rect;
  // private _toY;
  flag;
  state;
  moved;
  vx;
  type;
  x = 0;
  y = 0;
  prizeOdds = props.prizeOdds;
  ghostOdds = props.ghostOdds;
  prizeFlag: boolean;
  ghostFlag: boolean;
  isNew: boolean;
  addStatus: boolean;
  prizeIcon: engine.Sprite;
  ghostIcon;
  constructor() {
    super();
    this.width = 224;
    this.height = 56;

    this.flag = 0;
    this.state = 0;
    this.moved = 0;
    this.vx = 1;
    this.type = 1;
    this._body = new engine.Rect();
    this.isNew = true
    this.addStatus = false
    this.addChild(new engine.Sprite(getTextureByName('台阶')));
    this.prizeIcon = new engine.Sprite(getTextureByName('青团'));
    this.prizeIcon.x = this.x + this.width / 2 - this.prizeIcon.width / 2;
    this.prizeIcon.y = this.y - this.height + 10;
    this.ghostIcon = createSvga('大灰狼');
    this.ghostIcon.gotoAndPlay(1);
    setTimeout(() => {
      this.ghostIcon.y = -this.height * 2 - 10;
      this.ghostIcon.x = this.width / 2 - this.ghostIcon.width / 2;
    }, 10);
    this.prizeIcon.visible = false;
    this.ghostIcon.visible = false;
    this.addChild(this.ghostIcon);
    this.addChild(this.prizeIcon);

    this.prizeFlag = Math.random() < this.prizeOdds ? true : false;
    if (this.prizeFlag) {
      this.ghostFlag = false;
      this.prizeIcon.visible = true;
    } else {
      // this.ghostFlag = Math.random() < this.ghostOdds ? true : false;

      // if (this.ghostFlag) this.ghostIcon.visible = true;
    }
    // let platform = new engine.Sprite(getTextureByName('台阶'));
  }
  getStatus() {
    this.prizeIcon.visible = false;
    this.ghostIcon.visible = false;
    this.prizeFlag = Math.random() < this.prizeOdds ? true : false;
    if (this.prizeFlag) {
      this.ghostFlag = false;
      this.prizeIcon.visible = true;
    } else {
      this.ghostFlag = Math.random() < this.ghostOdds ? true : false;
      if (this.ghostFlag) this.ghostIcon.visible = true;
    }
  }
}
