/**
 * Created by rockyl on 2020-01-09.
 */

import GameView from "./GameView";
import {injectProps} from "../props";


export class GameWrapper extends engine.Container {
	private _status;
	private _gameView: GameView;





	constructor() {
		super();
		engine.globalEvent.addEventListener('jump-more-reset', this.reset, this);
		engine.globalEvent.addEventListener('jump-more-start', this.start, this);
		// engine.globalEvent.addEventListener('jump-more-pause', this.pause, this);
		engine.globalEvent.addEventListener('jump-more-resume', this.resume, this);
		engine.globalEvent.addEventListener('jump-more-revive', this.revive, this);
		// engine.globalEvent.addEventListener('jump-more-play-music', this.playMusic, this);
		// engine.globalEvent.addEventListener('food-fell-clear', this.clear, this);
		// engine.globalEvent.addEventListener('jump-more-score', ()=>{
		
		// } , this);
		this.addEventListener(engine.MouseEvent.CLICK, this.onTap, this);

		let gameView = this._gameView = new GameView();
		this.addChild(gameView);
		// gameView.reset()
		// gameView.start()
	}

	reset(event: engine.Event) {		
		injectProps(event.data);
		this._gameView.visible = true;
		this._gameView.reset();
	}

	start(event: engine.Event) {
		injectProps(event.data);
		// this._status = 1;
		this._gameView.start();
	}

	pause() {
		this._gameView.pause();
	}

	resume() {
		this._gameView.resume();
	}

	revive() {
		this._gameView.gameRevive();
	}
	// playMusic(){
	// 	this._gameView.playMusic()
	// }

	// clear() {
	// 	this._gameView.visible = false;
	// }

	private onTap(event) {
	//	this._gameView.tap(event);
	}
}
