(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['jump-more'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	function createSvga(name, anchorName) {
	    var inst = new svga.Svga();
	    inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	    return inst;
	}

	var Platform = (function (_super) {
	    tslib.__extends(Platform, _super);
	    function Platform() {
	        var _this = _super.call(this) || this;
	        _this.x = 0;
	        _this.y = 0;
	        _this.prizeOdds = props.prizeOdds;
	        _this.ghostOdds = props.ghostOdds;
	        _this.width = 224;
	        _this.height = 56;
	        _this.flag = 0;
	        _this.state = 0;
	        _this.moved = 0;
	        _this.vx = 1;
	        _this.type = 1;
	        _this._body = new engine.Rect();
	        _this.isNew = true;
	        _this.addStatus = false;
	        _this.addChild(new engine.Sprite(getTextureByName('台阶')));
	        _this.prizeIcon = new engine.Sprite(getTextureByName('青团'));
	        _this.prizeIcon.x = _this.x + _this.width / 2 - _this.prizeIcon.width / 2;
	        _this.prizeIcon.y = _this.y - _this.height + 10;
	        _this.ghostIcon = createSvga('大灰狼');
	        _this.ghostIcon.gotoAndPlay(1);
	        setTimeout(function () {
	            _this.ghostIcon.y = -_this.height * 2 - 10;
	            _this.ghostIcon.x = _this.width / 2 - _this.ghostIcon.width / 2;
	        }, 10);
	        _this.prizeIcon.visible = false;
	        _this.ghostIcon.visible = false;
	        _this.addChild(_this.ghostIcon);
	        _this.addChild(_this.prizeIcon);
	        _this.prizeFlag = Math.random() < _this.prizeOdds ? true : false;
	        if (_this.prizeFlag) {
	            _this.ghostFlag = false;
	            _this.prizeIcon.visible = true;
	        }
	        return _this;
	    }
	    Platform.prototype.getStatus = function () {
	        this.prizeIcon.visible = false;
	        this.ghostIcon.visible = false;
	        this.prizeFlag = Math.random() < this.prizeOdds ? true : false;
	        if (this.prizeFlag) {
	            this.ghostFlag = false;
	            this.prizeIcon.visible = true;
	        }
	        else {
	            this.ghostFlag = Math.random() < this.ghostOdds ? true : false;
	            if (this.ghostFlag)
	                this.ghostIcon.visible = true;
	        }
	    };
	    return Platform;
	}(engine.Container));

	var Goods = (function (_super) {
	    tslib.__extends(Goods, _super);
	    function Goods() {
	        var _this = _super.call(this) || this;
	        var body;
	        body = _this._body = new engine.Rect();
	        var rain = new engine.Sprite(getTextureByName('雨滴'));
	        rain["npcType"] = "rain";
	        var stone = new engine.Sprite(getTextureByName('石块'));
	        stone["npcType"] = "stone";
	        var boom = new engine.Sprite(getTextureByName('炸弹'));
	        boom["npcType"] = "boom";
	        rain.visible = false;
	        stone.visible = false;
	        boom.visible = false;
	        body.addChild(rain);
	        body.addChild(stone);
	        body.addChild(boom);
	        _this.addChild(body);
	        body.width = .0001;
	        body.height = .0001;
	        body.mouseEnabled = false;
	        return _this;
	    }
	    Goods.prototype.getRandomNumberByRange = function (start, end) {
	        return Math.floor(Math.random() * (end - start) + start);
	    };
	    Goods.prototype.reset = function () {
	        this.visible = true;
	        this.rotation = 0;
	        this.anchorOffsetY = 0;
	        this.y = 0;
	        this.x = (750 - 120) * Math.random() + 30;
	        this.rotation = 0;
	        var random = Math.random();
	        if (random < props.goodsProbability[0]) {
	            this.showNpc("rain");
	        }
	        else if (random >= props.goodsProbability[0] && random <= (props.goodsProbability[0] + props.goodsProbability[1])) {
	            this.showNpc("stone");
	        }
	        else if (random > (props.goodsProbability[0] + props.goodsProbability[1])) {
	            this.showNpc("boom");
	        }
	    };
	    Goods.prototype.showNpc = function (type) {
	        for (var i = 0; i < this._body.children.length; i++) {
	            this._body.children[i].visible = false;
	            this._body.children[i].mouseEnabled = false;
	        }
	        for (var i = 0; i < this._body.children.length; i++) {
	            if (this._body.children[i]["npcType"] == type) {
	                this["npcType"] = type;
	                this._body.children[i].visible = true;
	                this._body.children[i].mouseEnabled = false;
	            }
	        }
	    };
	    Object.defineProperty(Goods.prototype, "anchorOffsetY", {
	        set: function (v) {
	            this._body.y = v;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return Goods;
	}(engine.Container));

	var ObjectPool = engine.ObjectPool;
	var PoolName = 'goods';
	ObjectPool.registerPool(PoolName, function () {
	    return new Goods();
	}, function (item, data) {
	    item.reset();
	});

	var SoundMgr = (function () {
	    function SoundMgr() {
	    }
	    Object.defineProperty(SoundMgr, "instance", {
	        get: function () {
	            if (!this._instance) {
	                this._instance = new SoundMgr();
	            }
	            return this._instance;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SoundMgr.prototype, "enabled", {
	        get: function () {
	            return engine.env.soundEnabled;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    SoundMgr.prototype.playEffect = function (name, loop) {
	        if (loop === void 0) { loop = false; }
	        engine.playSound(getAssetByUUID(nameToUuid[name]).uuid, {
	            loop: loop,
	            keep: true
	        }, name);
	    };
	    SoundMgr.prototype.stopEffect = function (name) {
	        engine.stopSound(name);
	        engine.destroySound(name);
	    };
	    SoundMgr._instance = null;
	    return SoundMgr;
	}());
	var nameToUuid = {
	    bgm: "da826400-c835-4b75-8991-a29b64c5ac0b",
	    prize: "6b809f4e-1712-4201-beed-a683294ded02",
	    ghost: "dc4426e3-cfe0-492e-bf74-002e0eb605cf",
	    jumpdied: "f3f66910-8af2-4ceb-b7b3-27329a8ca93b",
	};

	var ObjectPool$1 = engine.ObjectPool;
	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this.gravity = 0.2;
	        _this.bottomY = 5;
	        _this.jumpCount = 0;
	        _this.flag = 0;
	        _this.iconX = 0;
	        _this.goodsItems = [];
	        _this.platformCount = 12;
	        _this.platformGap = 0;
	        _this.platPosition = 0;
	        _this.platforms = [];
	        _this.newPlatforms = [];
	        _this.cashNum = 0;
	        _this.moveCatchX = 0;
	        _this.playerCatchX = 0;
	        _this.onDownStage = function (e) {
	            if (e.stageX < _this.width / 2) {
	                _this.player.dir = 'left';
	                _this.player.isMovingLeft = true;
	                _this.playerSvga.scaleX = -1;
	                setTimeout(function () {
	                    _this.player.isMovingLeft = false;
	                }, 500);
	            }
	            else {
	                _this.player.dir = 'right';
	                _this.player.isMovingRight = true;
	                _this.playerSvga.scaleX = 1;
	                setTimeout(function () {
	                    _this.player.isMovingRight = false;
	                }, 500);
	            }
	        };
	        _this.onMoveStage = function (e) {
	            if (_this.gameIng) {
	                _this.player.x = _this.playerCatchX + (e.localX - _this.moveCatchX);
	            }
	        };
	        _this.onOutStage = function (e) {
	            if (e.stageX < _this.width / 2) {
	                _this.player.dir = 'left';
	                _this.player.isMovingLeft = false;
	            }
	            else {
	                _this.player.dir = 'right';
	                _this.player.isMovingRight = false;
	            }
	        };
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.setup = function () {
	        var _this = this;
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        this.NpcBg = new engine.Container();
	        this.NpcBg.alpha = 1;
	        this.NpcBg.width = 0;
	        this.NpcBg.height = 0;
	        this.addChild(this.NpcBg);
	        this.player = new engine.Container();
	        this.player.vx = 0;
	        this.player.vy = 11;
	        this.player.isMovingLeft = false;
	        this.player.isMovingRight = false;
	        this.player.isDead = false;
	        this.player.jump = function () {
	            _this.player.vy = -10;
	            _this.playerSvga.play(false, false);
	        };
	        this.playerSvga = createSvga('玩家abc');
	        this.player.addChild(this.playerSvga);
	        this.visible = false;
	        this.addScoreIcon = new engine.Sprite(getTextureByName('加分'));
	        this.addScoreIcon.visible = false;
	        this.player.addChild(this.addScoreIcon);
	        setTimeout(function () {
	            _this.visible = true;
	            _this.playerSvga.anchorY = _this.playerSvga.height / 2;
	            _this.playerSvga.anchorX = _this.playerSvga.width / 2;
	            _this.player.anchorY = _this.player.height / 2;
	            _this.player.anchorX = _this.player.width / 2;
	            _this.player.x = 375 - _this.player.width / 2;
	            _this.iconX = _this.player.width + 20;
	            _this.addScoreIcon.y =
	                _this.player.height / 2 - _this.addScoreIcon.height / 2 + 20;
	        }, 300);
	        this.score = 0;
	        this.rectBg = new engine.Container();
	        this.rectBg.width = 750;
	        this.rectBg.height = 1624;
	        this.rectHeight = this.stage.height - this.rectBg.height;
	        this.rectBg.y = this.rectHeight;
	        this.addChild(this.rectBg);
	        this.player.y = this.rectBg.height;
	        this.baseY = this.rectBg.height - this.bottomY;
	        this.rectBg.addEventListener(engine.MouseEvent.CLICK, this.onDownStage, this);
	    };
	    GameView.prototype.base = function () { };
	    GameView.prototype.createPlatform = function (needGhost) {
	        if (needGhost === void 0) { needGhost = false; }
	        var platform = new Platform();
	        platform.x = Math.random() * (this.width - platform.width);
	        this.platPosition += this.rectBg.height / this.platformCount;
	        var platform2 = new Platform();
	        var left = platform.x;
	        if (left > this.width / 2) {
	            platform2.x =
	                Math.random() * (platform.x - platform.width) - platform.width / 2;
	        }
	        else {
	            platform2.x =
	                platform.x +
	                    platform.width +
	                    Math.random() * (this.width - platform.x - platform.width * 1.5);
	        }
	        platform2.y = platform.y = this.platPosition;
	        if (needGhost && !platform.prizeFlag) {
	            platform.ghostFlag = Math.random() < platform.ghostOdds ? true : false;
	            if (platform.ghostFlag)
	                platform.ghostIcon.visible = true;
	        }
	        return [platform, platform2];
	    };
	    GameView.prototype.changePlatformGap = function (to) {
	        var _this = this;
	        if (this.platformCount == to)
	            return;
	        this.platformCount = to;
	        var min = this.rectBg.height;
	        for (var i = 0; i < this.platforms.length; i++) {
	            if (min > this.platforms[i].y) {
	                min = this.platforms[i].y;
	            }
	        }
	        this.platPosition =
	            min - this.rectBg.height / this.platformCount + this.rectBg.height;
	        var newList = [];
	        for (var i = 0; i < this.platformCount; i++) {
	            newList.push.apply(newList, this.createPlatform(true));
	        }
	        this.newPlatforms = newList;
	        this.newPlatforms.forEach(function (p) {
	            if (p.isNew && !p.addStatus) {
	                _this.rectBg.addChild(p);
	                p.addStatus = true;
	            }
	        });
	        this.platforms.forEach(function (p) {
	            p.isNew = false;
	            _this.rectBg.addChild(p);
	        });
	        this.platforms = this.platforms.concat(this.newPlatforms);
	    };
	    GameView.prototype.platformInit = function () {
	        var _a;
	        var _this = this;
	        for (var i = 0; i < this.platformCount; i++) {
	            (_a = this.platforms).push.apply(_a, this.createPlatform());
	        }
	        this.platforms.forEach(function (p, i) {
	            _this.rectBg.addChild(p);
	        });
	    };
	    GameView.prototype.playerJump = function () {
	        var _this = this;
	        this.player.y += this.player.vy;
	        this.player.vy += this.gravity;
	        if (this.player.vy > 0 &&
	            this.player.x + 15 < 260 &&
	            this.player.x + this.player.width - 15 > 155 &&
	            this.player.y + this.player.height > 475 &&
	            this.player.y + this.player.height < 500) {
	            return this.player.jump();
	        }
	        if (this.player.isMovingLeft === true) {
	            this.player.x += this.player.vx;
	            this.player.vx -= 0.1;
	        }
	        else {
	            this.player.x += this.player.vx;
	            if (this.player.vx < 0)
	                this.player.vx += 0.07;
	        }
	        if (this.player.isMovingRight === true) {
	            this.player.x += this.player.vx;
	            this.player.vx += 0.1;
	        }
	        else {
	            this.player.x += this.player.vx;
	            if (this.player.vx > 0)
	                this.player.vx -= 0.07;
	        }
	        if (this.player.vx > 4)
	            this.player.vx = 4;
	        else if (this.player.vx < -4)
	            this.player.vx = -4;
	        if (this.player.y + this.player.height > this.baseY &&
	            this.baseY < this.rectBg.height) {
	            this.player.jump();
	        }
	        if (this.baseY > this.rectBg.height &&
	            this.player.y + this.player.height > this.rectBg.height &&
	            this.player.isDead != 'lol') {
	            this.player.isDead = true;
	            SoundMgr.instance.playEffect('jumpdied');
	        }
	        if (this.player.x > this.width)
	            this.player.x = 0 - this.player.width;
	        else if (this.player.x < 0 - this.player.width)
	            this.player.x = this.width - this.player.width;
	        if (this.player.y >= this.rectBg.height / 2 - this.player.height / 2) {
	            this.player.y += this.player.vy;
	            this.player.vy += this.gravity;
	        }
	        else {
	            if (this.player.y < this.height / 2) {
	                this.player.y -= this.player.vy;
	            }
	            if (this.newPlatforms.length > 0) {
	                this.platforms.forEach(function (p, i) {
	                    if (_this.player.vy < 0) {
	                        p.y -= _this.player.vy;
	                    }
	                    if (_this.player.y < _this.height / 2) {
	                        p.y -= _this.player.vy;
	                    }
	                    if (p.y > _this.height) {
	                        if (p.isNew == false) {
	                            _this.cashNum++;
	                            if (_this.cashNum ==
	                                _this.platforms.length - _this.newPlatforms.length) {
	                                var list = _this.platforms.splice(0, _this.cashNum);
	                                _this.newPlatforms = [];
	                                for (var i_1 = 0; i_1 < list.length; i_1++) {
	                                    _this.rectBg.removeChild(list[i_1]);
	                                }
	                                _this.cashNum = 0;
	                            }
	                        }
	                        p.y = p.y - _this.rectBg.height * 2;
	                    }
	                });
	            }
	            else {
	                this.platforms.forEach(function (p, i) {
	                    if (_this.player.vy < 0) {
	                        p.y -= _this.player.vy;
	                    }
	                    if (_this.player.y < _this.height / 2) {
	                        p.y -= _this.player.vy;
	                    }
	                    if (p.y > _this.height) {
	                        if (i % 2 == 0) {
	                            _this.platforms[i].x =
	                                Math.random() * (_this.width - _this.platforms[i].width);
	                            if (i != 0) {
	                                p.getStatus();
	                            }
	                        }
	                        else {
	                            var last = _this.platforms[i - 1], left = last.x;
	                            if (left > _this.width / 2) {
	                                p.x = Math.random() * (last.x - p.width) - p.width / 2;
	                            }
	                            else {
	                                p.x =
	                                    last.x +
	                                        p.width +
	                                        Math.random() * (_this.width - last.x - p.width * 1.5);
	                            }
	                        }
	                        p.y = p.y - _this.rectBg.height;
	                    }
	                });
	            }
	            this.baseY -= this.player.vy;
	            this.player.vy += this.gravity;
	            if (this.player.vy >= 0) {
	                this.player.y += this.player.vy;
	                this.player.vy += this.gravity;
	            }
	            if (this.score > 30 && this.score < 60) {
	                this.changePlatformGap(11);
	            }
	            else if (this.score > 60 && this.score < 120) {
	                this.changePlatformGap(10);
	            }
	            else if (this.score > 120) {
	                this.changePlatformGap(8);
	            }
	        }
	        if (this.player.isDead === false)
	            this.collides();
	        if (this.player.isDead == true) {
	            this.gameOver();
	        }
	    };
	    GameView.prototype.playMusic = function () {
	        SoundMgr.instance.playEffect('bgm', true);
	    };
	    GameView.prototype.collides = function () {
	        var _this = this;
	        this.platforms.forEach(function (p, i) {
	            if (_this.player.vy > 0 &&
	                p.state === 0 &&
	                _this.player.x + 55 < p.x + p.width &&
	                _this.player.x + _this.player.width - 30 > p.x &&
	                _this.player.y + _this.player.height + 15 > p.y &&
	                _this.player.y + _this.player.height + 15 < p.y + p.height) {
	                if (p.prizeFlag) {
	                    SoundMgr.instance.playEffect('prize');
	                    _this.score += props.prizeScore;
	                    engine.globalEvent.dispatchEvent('jump-more-score-update', {
	                        score: _this.score
	                    });
	                    p.prizeFlag = false;
	                    p.prizeIcon.visible = false;
	                    if (p.x > _this.rectBg.width - p.width * 1.5) {
	                        _this.addScoreIcon.x = -20 - _this.addScoreIcon.width;
	                    }
	                    else {
	                        _this.addScoreIcon.x = _this.iconX;
	                    }
	                    _this.addScoreIcon.visible = true;
	                    if (_this.addTimer) {
	                        clearTimeout(_this.addTimer);
	                    }
	                    _this.addTimer = setTimeout(function () {
	                        _this.addScoreIcon.visible = false;
	                    }, 1000);
	                }
	                else if (p.ghostFlag) {
	                    SoundMgr.instance.playEffect('ghost');
	                    _this.diedIndex = i;
	                    _this.gameOver();
	                }
	                else {
	                    _this.player.jump();
	                }
	            }
	        });
	    };
	    GameView.prototype.gameOver = function () {
	        this.platforms.forEach(function (p, i) {
	            p.y -= 12;
	        });
	        if (this.player.y > this.rectBg.height / 2 && this.flag === 0) {
	            this.player.y -= 8;
	            this.player.vy = 0;
	        }
	        else if (this.player.y + this.player.height > this.rectBg.height) ;
	        engine.globalEvent.dispatchEvent('jump-more-game-over', {
	            score: this.score
	        });
	        this.player.isDead = 'lol';
	    };
	    GameView.prototype.rectBgCalc = function () {
	    };
	    GameView.prototype.gameRevive = function () {
	        this.player.isDead = false;
	        var random = Math.floor(Math.random() * 3) * 2;
	        this.player.x = this.platforms[random].x;
	        this.player.y = this.platforms[random].y;
	        this.player.vx = 0;
	        this.player.vy = 11;
	        this.platforms.forEach(function (p, i) {
	            p.ghostFlag = false;
	            p.ghostIcon.visible = false;
	        });
	    };
	    GameView.prototype.update_my = function () {
	        this.playerJump();
	        this.rectBg.addChild(this.player);
	    };
	    GameView.prototype.reset = function () {
	        this.removeEventListener(engine.Event.ENTER_FRAME, this.test, this);
	        SoundMgr.instance.stopEffect('bgm');
	        this.recycleGoods();
	        this.player.vx = 0;
	        this.player.vy = 11;
	        this.player.isMovingLeft = false;
	        this.player.isMovingRight = false;
	        this.player.x = 375 - this.player.width / 2;
	        this.player.y = this.rectBg.height - 200;
	        this.rectBg.y = this.rectHeight;
	        this.platPosition = 0;
	        this.score = 0;
	        this.platformCount = 12;
	        this.platformGap = 0;
	        this.baseY = this.rectBg.height - this.bottomY;
	        this.player.isDead = false;
	        this.platformInit();
	        this.playerJump();
	    };
	    GameView.prototype.start = function () {
	        this.aniLoop();
	        this.playMusic();
	    };
	    GameView.prototype.pause = function () {
	        this.gameIng = false;
	    };
	    GameView.prototype.revive = function () {
	        this.gameIng = true;
	    };
	    GameView.prototype.resume = function () {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            return tslib.__generator(this, function (_a) {
	                this.reset();
	                this.start();
	                return [2];
	            });
	        });
	    };
	    GameView.prototype.aniLoop = function () {
	        var _this = this;
	        this.addEventListener(engine.Event.ENTER_FRAME, (this.test = function () {
	            _this.update_my();
	        }), this);
	    };
	    GameView.prototype.died = function () {
	        this.score = 0;
	        this.pause();
	    };
	    GameView.prototype.removeNpc = function (goods) {
	        var _this = this;
	        this.NpcBg.removeChild(goods);
	        ObjectPool$1.recycleObject(PoolName, goods);
	        this.removeEventListener(engine.Event.ENTER_FRAME, function () {
	            _this.update_my();
	        }, this);
	        var index = this.goodsItems.indexOf(goods);
	        if (index > -1) {
	            this.goodsItems.splice(index, 1);
	        }
	    };
	    GameView.prototype.recycleGoods = function () {
	        for (var _i = 0, _a = this.platforms; _i < _a.length; _i++) {
	            var p = _a[_i];
	            this.rectBg.removeChild(p);
	        }
	        this.newPlatforms = [];
	        this.platforms = [];
	    };
	    GameView.prototype.hasHit = function (a, b) {
	        if (Math.abs(a.x + a.width / 2 - (b.x + b.width / 2)) <
	            a.width / 2 + b.width / 2 &&
	            Math.abs(a.y + a.height / 2 - (b.y + b.height / 2)) <
	                a.height / 2 + b.height / 2) {
	            return true;
	        }
	        else {
	            return false;
	        }
	    };
	    return GameView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('jump-more-reset', _this.reset, _this);
	        engine.globalEvent.addEventListener('jump-more-start', _this.start, _this);
	        engine.globalEvent.addEventListener('jump-more-resume', _this.resume, _this);
	        engine.globalEvent.addEventListener('jump-more-revive', _this.revive, _this);
	        _this.addEventListener(engine.MouseEvent.CLICK, _this.onTap, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        return _this;
	    }
	    GameWrapper.prototype.reset = function (event) {
	        injectProps(event.data);
	        this._gameView.visible = true;
	        this._gameView.reset();
	    };
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	        this._gameView.start();
	    };
	    GameWrapper.prototype.pause = function () {
	        this._gameView.pause();
	    };
	    GameWrapper.prototype.resume = function () {
	        this._gameView.resume();
	    };
	    GameWrapper.prototype.revive = function () {
	        this._gameView.gameRevive();
	    };
	    GameWrapper.prototype.onTap = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}

	return index;

})));

//# sourceMappingURL=main.js.map