/**
 * Created by rockyl on 2020-01-21.
 */
import {props} from "../props";

export function getTexture(uuid) {
	return engine.Texture.from(uuid);
}

export function getTextureByName(name) {
	return engine.Texture.from(getAssetByName(name).uuid);
}

export function getBlockAsset(type) {
	return engine.getAssetByName(props.blockAssets[type]);
}

export function createSvga(name, anchorName) {
	let inst = new svga.Svga();
	inst.source = 'asset://' + getAssetByName(name).uuid;
	let anchor = props[anchorName];
	if (anchor) {
		inst.x = -anchor.x;
		inst.y = -anchor.y;

		inst.anchorX = anchor.x;
		inst.anchorY = anchor.y;
	}
	return inst;
}

export function playSound(name) {
	engine.playSound(getAssetByName(name).uuid, {keep: true});
}
