/**
 * Created by rockyl on 2020-01-09.
 */

import GameView from "./GameView";
import {injectProps} from "../props";

export class JumpHigh extends engine.Container {
	private _status;
	private _gameView: GameView;

	constructor() {
		super();

		engine.globalEvent.addEventListener('jump-high-reset', this.reset, this);
		engine.globalEvent.addEventListener('jump-high-start', this.start, this);
		engine.globalEvent.addEventListener('jump-high-pause', this.pause, this);
		engine.globalEvent.addEventListener('jump-high-resume', this.resume, this);
		engine.globalEvent.addEventListener('jump-high-revive', this.revive, this);

		this.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onTap, this);

		let gameView = this._gameView = new GameView();
		this.addChild(gameView);
	}

	reset() {
		this._gameView.reset();
	}

	start(event: engine.Event) {
		if ('jump-high-start') {
			injectProps(event.data);
		}

		this._status = 1;

		this._gameView.start();
	}

	pause() {
		this._gameView.pause();
	}

	resume() {
		this._gameView.resume();
	}

	revive() {
		this._gameView.revive();
	}

	private onTap(event) {
		this._gameView.jump();
	}
}
