/**
 * Created by rockyl on 2020-01-21.
 */
import {getTextureByName} from "./utils";

export class Background extends engine.Container {
	private _bg: engine.Image;
	private _minScale: number;

	constructor() {
		super();

	}

	setup() {
		const {width, height} = this.stage;

		let bg = this._bg = new engine.Image(getTextureByName('背景图'));
		bg.anchorX = bg.width / 2;
		bg.anchorY = bg.height / 2;
		bg.x = -(bg.width - width) / 2;
		bg.y = -(bg.height - height) / 2;
		this.addChild(bg);

		this._minScale = width / bg.width;
	}

	playZoom(type: 'in' | 'out', duration = 700) {
		return new Promise(resolve => {
			let scale = type === 'in' ? 1 : this._minScale;
			engine.Tween.get(this._bg, null, null, true)
				.to({scaleX: scale, scaleY: scale}, duration, engine.Ease.cubicInOut)
				.call(resolve);
		})
	}
}
