(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['jump-high'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}

	function getTextureByName(name) {
	    return engine.Texture.from(getAssetByName(name).uuid);
	}
	function getBlockAsset(type) {
	    return engine.getAssetByName(props.blockAssets[type]);
	}
	function createSvga(name, anchorName) {
	    var inst = new svga.Svga();
	    inst.source = 'asset://' + getAssetByName(name).uuid;
	    var anchor = props[anchorName];
	    if (anchor) {
	        inst.x = -anchor.x;
	        inst.y = -anchor.y;
	        inst.anchorX = anchor.x;
	        inst.anchorY = anchor.y;
	    }
	    return inst;
	}
	function playSound(name) {
	    engine.playSound(getAssetByName(name).uuid, { keep: true });
	}

	var Block = (function (_super) {
	    tslib.__extends(Block, _super);
	    function Block() {
	        var _this = _super.call(this) || this;
	        var body = _this.body = new svga.Svga();
	        body.x = -props.blockWidth / 2;
	        body.y = -props.blockHitHeight - props.blockPaddingTop;
	        _this.addChild(body);
	        return _this;
	    }
	    Block.prototype.reset = function (_a) {
	        var type = _a.type;
	        this.dir = Math.random() > 0.5 ? 1 : -1;
	        if (this.type != type) {
	            this.type = type;
	            var asset = getBlockAsset(type);
	            this.body.source = 'asset://' + asset.uuid;
	        }
	        this.scaleX = this.dir;
	        this.body.gotoAndStop(1);
	    };
	    Block.prototype.playEnter = function (index, animation) {
	        var _this = this;
	        this.visible = true;
	        this.x = this.dir * this.stage.width;
	        var _a = props.blockDurationRange, min = _a[0], max = _a[1];
	        var duration = Math.max(max - index * props.blockDurationStep, min);
	        duration = duration + max * Math.random() * props.blockDurationRandom * (Math.random() > 0.5 ? 1 : -1);
	        return new Promise(function (resolve) {
	            if (animation) {
	                engine.Tween.get(_this, null, null, true)
	                    .to({ x: 0, }, duration)
	                    .call(resolve);
	            }
	            else {
	                _this.x = 0;
	                setTimeout(function () {
	                    console.log(_this.body);
	                }, 200);
	                resolve();
	            }
	        });
	    };
	    Block.prototype.playLeave = function () {
	        this.visible = false;
	    };
	    Block.prototype.playEffect = function () {
	        var body = this.body;
	        body.play(true, false);
	        body.once(engine.Event.END_FRAME, function () {
	            body.gotoAndStop(1);
	        }, this);
	    };
	    Block.prototype.stop = function () {
	        engine.Tween.removeTweens(this);
	    };
	    return Block;
	}(engine.Container));

	var Background = (function (_super) {
	    tslib.__extends(Background, _super);
	    function Background() {
	        return _super.call(this) || this;
	    }
	    Background.prototype.setup = function () {
	        var _a = this.stage, width = _a.width, height = _a.height;
	        var bg = this._bg = new engine.Image(getTextureByName('背景图'));
	        bg.anchorX = bg.width / 2;
	        bg.anchorY = bg.height / 2;
	        bg.x = -(bg.width - width) / 2;
	        bg.y = -(bg.height - height) / 2;
	        this.addChild(bg);
	        this._minScale = width / bg.width;
	    };
	    Background.prototype.playZoom = function (type, duration) {
	        var _this = this;
	        if (duration === void 0) { duration = 700; }
	        return new Promise(function (resolve) {
	            var scale = type === 'in' ? 1 : _this._minScale;
	            engine.Tween.get(_this._bg, null, null, true)
	                .to({ scaleX: scale, scaleY: scale }, duration, engine.Ease.cubicInOut)
	                .call(resolve);
	        });
	    };
	    return Background;
	}(engine.Container));

	var svgaAssets = {
	    aniReady: { name: '准备立正', dir: 1 },
	    aniJump: { name: '跳上升', dir: 1 },
	    aniFall: { name: '跳下落', dir: 1 },
	    aniLandNormal: { name: '普通着地', dir: 1 },
	    aniLandSide: { name: '边缘着地', dir: -1 },
	    aniHit: { name: '被撞开', dir: -1 },
	    aniParachute: { name: '降落', dir: -1 },
	};
	var Player = (function (_super) {
	    tslib.__extends(Player, _super);
	    function Player() {
	        var _this = _super.call(this) || this;
	        _this.g = props.gravity;
	        _this.addEventListener(engine.Event.ENTER_FRAME, _this.onEnterFrame, _this);
	        return _this;
	    }
	    Player.prototype.switchAni = function (name, dir, play, loop) {
	        var _this = this;
	        if (dir === void 0) { dir = 1; }
	        if (play === void 0) { play = true; }
	        if (loop === void 0) { loop = false; }
	        return new Promise(function (resolve) {
	            _this.scaleX = dir;
	            if (_this._aniName !== name) {
	                _this._aniName = name;
	                var oldAni = _this.removeChild(_this.getChildByName('body'));
	                if (oldAni) {
	                    oldAni.stop();
	                }
	                var ani = _this._currentAni = _this['ani' + name];
	                _this.addChild(ani);
	                if (play) {
	                    ani.play(false, loop);
	                    if (loop) {
	                        resolve();
	                    }
	                    else {
	                        ani.once(engine.Event.END_FRAME, resolve);
	                    }
	                }
	                else {
	                    ani.gotoAndStop(1);
	                    resolve();
	                }
	            }
	        });
	    };
	    Player.prototype.setup = function () {
	        this.prefectEffect = createSvga('完美着地特效', 'playerLandPrefectAnchor');
	        this.landEffect = createSvga('着地特效', 'playerLandEffectAnchor');
	        for (var key in svgaAssets) {
	            var _a = svgaAssets[key], name = _a.name, dir = _a.dir;
	            var body = this[key] = createSvga(name, key.replace('ani', 'player') + 'Anchor');
	            body.name = 'body';
	            body.scaleX = dir;
	        }
	    };
	    Player.prototype.reset = function (revive) {
	        this.x = 0;
	        this.rotation = 0;
	        this.scaleX = this.scaleY = 1;
	        this._prefectLandCounting = 0;
	        engine.Tween.removeTweens(this);
	        if (revive) {
	            this.switchAni('Jump', 1, false);
	        }
	    };
	    Player.prototype.playReady = function () {
	        var _this = this;
	        return new Promise(function (resolve) {
	            _this.switchAni('Ready', 1);
	            _this._currentAni.once(engine.Event.END_FRAME, function () {
	                this.switchAni('Jump', 1, false);
	                resolve();
	            }, _this);
	        });
	    };
	    Player.prototype.onEnterFrame = function (event) {
	        if (!this.playing) {
	            return;
	        }
	        this.vy += this.g;
	        this.y += this.vy;
	        if (this.vy > 0 && this._aniName !== 'Fall') {
	            this.dispatchEvent('jump-on-top');
	            this.switchAni('Fall');
	        }
	        if (this.y > this.baseY) {
	            this.y = this.baseY;
	            this.playing = false;
	            this.jumpPromise && this.jumpPromise({
	                aboveBlock: this.aboveBlock,
	            });
	            this.jumpPromise = null;
	        }
	    };
	    Player.prototype.changeBaseY = function (v) {
	        if (this.baseY == v) {
	            return;
	        }
	        this.aboveBlock = true;
	        this.baseY = v;
	    };
	    Player.prototype.jump = function () {
	        var _this = this;
	        playSound('跳起音效');
	        this.switchAni('Jump', 1, false);
	        this._currentAni.play(false, false);
	        this.aboveBlock = false;
	        this.playing = true;
	        this.baseY = this.y;
	        this.vy = -props.jumpSpeed;
	        return new Promise(function (resolve) {
	            _this.jumpPromise = resolve;
	        });
	    };
	    Player.prototype.playLand = function (type, dir) {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var _a, prefectEffect_1, landEffect_1;
	            return tslib.__generator(this, function (_b) {
	                switch (_b.label) {
	                    case 0:
	                        _a = type;
	                        switch (_a) {
	                            case 0: return [3, 1];
	                            case 1: return [3, 3];
	                            case 2: return [3, 3];
	                            case 3: return [3, 4];
	                        }
	                        return [3, 5];
	                    case 1:
	                        this._prefectLandCounting++;
	                        playSound('完美落地音效' + Math.min(4, this._prefectLandCounting));
	                        prefectEffect_1 = this.prefectEffect;
	                        this.addChildAt(prefectEffect_1, 0);
	                        prefectEffect_1.gotoAndPlay(1);
	                        prefectEffect_1.once(engine.Event.END_FRAME, function () {
	                            this.removeChild(prefectEffect_1);
	                        }, this);
	                        landEffect_1 = this.landEffect;
	                        this.addChildAt(landEffect_1, 0);
	                        landEffect_1.gotoAndPlay(1);
	                        landEffect_1.once(engine.Event.END_FRAME, function () {
	                            this.removeChild(landEffect_1);
	                        }, this);
	                        return [4, this.switchAni('LandNormal')];
	                    case 2:
	                        _b.sent();
	                        return [3, 5];
	                    case 3:
	                        this._prefectLandCounting = 0;
	                        playSound('普通落地音效');
	                        this.switchAni('LandNormal');
	                        return [3, 5];
	                    case 4:
	                        this._prefectLandCounting = 0;
	                        playSound('边缘落地音效');
	                        this.switchAni('LandSide', dir);
	                        return [3, 5];
	                    case 5: return [2];
	                }
	            });
	        });
	    };
	    Player.prototype.hitAway = function (dir) {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var _this = this;
	            return tslib.__generator(this, function (_a) {
	                switch (_a.label) {
	                    case 0:
	                        this.jumpPromise && this.jumpPromise();
	                        this.jumpPromise = null;
	                        playSound('被撞开音效');
	                        this.switchAni('Hit', dir);
	                        this.vy = 0;
	                        return [4, new Promise(function (resolve) {
	                                engine.Tween.get(_this)
	                                    .to({
	                                    x: -dir * props.hitAwayDistance.x,
	                                }, props.hitAwayDuration, engine.Ease.quartOut);
	                                engine.Tween.get(_this)
	                                    .to({
	                                    y: _this.y + props.hitAwayDistance.y,
	                                }, props.hitAwayDuration, engine.Ease.cubicOut)
	                                    .call(resolve);
	                            })];
	                    case 1:
	                        _a.sent();
	                        return [2];
	                }
	            });
	        });
	    };
	    Player.prototype.parachute = function (dir) {
	        var _this = this;
	        this.switchAni('Parachute', dir);
	        return new Promise(function (resolve) {
	            engine.Tween.get(_this)
	                .wait(200)
	                .call(function () {
	                playSound('降落伞下落音效');
	            })
	                .wait(300)
	                .to({ y: _this.y + props.parachuteDistance }, props.parachuteDuration)
	                .set({ anchorOffsetY: 0 })
	                .call(resolve);
	        });
	    };
	    return Player;
	}(engine.Container));

	var Base = (function (_super) {
	    tslib.__extends(Base, _super);
	    function Base() {
	        return _super.call(this, getTextureByName('底座')) || this;
	    }
	    Base.prototype.setup = function () {
	        this.x = -(this.width) / 2;
	    };
	    Base.prototype.reset = function () {
	        this.y = -props.baseOffset;
	    };
	    return Base;
	}(engine.Image));

	var GuideLayer = (function (_super) {
	    tslib.__extends(GuideLayer, _super);
	    function GuideLayer() {
	        var _this = _super.call(this) || this;
	        _this.setup();
	        return _this;
	    }
	    GuideLayer.prototype.setup = function () {
	    };
	    GuideLayer.prototype.show = function (id, options) {
	        var _this = this;
	        return new Promise(function (resolve) {
	            _this.visible = true;
	            if (!_this.guideMask) {
	                var _a = _this.stage, width = _a.width, height = _a.height;
	                var guideMask = _this.guideMask = new engine.Container();
	                var guideHole = new engine.Image(getTextureByName('引导遮罩'));
	                guideHole.x = (width - guideHole.width) / 2;
	                guideHole.y = options.y;
	                guideMask.addChild(guideHole);
	                _this.createRect(guideMask, 0, 0, width, guideHole.y);
	                _this.createRect(guideMask, 0, guideHole.y, guideHole.x, guideHole.height);
	                _this.createRect(guideMask, guideHole.x + guideHole.width, guideHole.y, width - guideHole.x - guideHole.width, guideHole.height);
	                _this.createRect(guideMask, 0, guideHole.y + guideHole.height, width, height - guideHole.y - guideHole.height);
	                var label = _this.label = new engine.Label();
	                label.fillColor = 'white';
	                label.size = 25;
	                label.text = props.guideText;
	                label.x = (width - label.width) / 2;
	                label.y = guideHole.y + guideHole.height + 50;
	                guideMask.addChild(label);
	                _this.addChild(guideMask);
	            }
	            _this.once(engine.MouseEvent.CLICK, function () {
	                this.visible = false;
	                resolve();
	            }, _this);
	        });
	    };
	    GuideLayer.prototype.createRect = function (container, x, y, width, height) {
	        var rect = new engine.Rect();
	        rect.x = x;
	        rect.y = y;
	        rect.width = width;
	        rect.height = height;
	        rect.fillColor = 'black';
	        rect.alpha = 0.7;
	        container.addChild(rect);
	    };
	    return GuideLayer;
	}(engine.Container));

	var GoldBag = (function (_super) {
	    tslib.__extends(GoldBag, _super);
	    function GoldBag() {
	        var _this = _super.call(this) || this;
	        _this.setup();
	        return _this;
	    }
	    GoldBag.prototype.setup = function () {
	        var avatar = this.avatar = new engine.Sprite(getTextureByName('钱袋-静态'));
	        avatar.x = -props.goldPackAvatarAnchor.x;
	        avatar.y = -props.goldPackAvatarAnchor.y;
	        this.addChild(avatar);
	        var svga = this.svga = createSvga('钱袋', 'goldPackAnchor');
	        svga.visible = false;
	        this.addChild(svga);
	    };
	    GoldBag.prototype.reset = function (data) {
	        this.y = data.y;
	        this.avatar.visible = true;
	        this.svga.visible = false;
	        this.svga.gotoAndStop(1);
	        this.remain = data.remain;
	    };
	    GoldBag.prototype.playOpen = function () {
	        var _this = this;
	        this.avatar.visible = false;
	        this.svga.visible = true;
	        return new Promise(function (resolve) {
	            _this.svga.play(true, false);
	            _this.svga.once(engine.Event.END_FRAME, function () {
	                this.svga.visible = false;
	                resolve();
	            }, _this);
	        });
	    };
	    return GoldBag;
	}(engine.Container));

	var ObjectPool = engine.ObjectPool;
	var PoolName = 'gold-bag';
	ObjectPool.registerPool(PoolName, function () {
	    return new GoldBag();
	}, function (item, data) {
	    item.reset(data);
	});
	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this.index = -1;
	        _this.goldBags = [];
	        _this.baseOffset = -props.baseOffset + props.playerOffset;
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.setup = function () {
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        var _a = this.stage, width = _a.width, height = _a.height;
	        var background = this.background = new Background();
	        this.addChild(background);
	        background.setup();
	        var frontContainer = this.frontContainer = new engine.Container();
	        frontContainer.x = width / 2;
	        this.addChild(frontContainer);
	        var guideLayer = this.guideLayer = new GuideLayer();
	        this.addChild(guideLayer);
	        var base = this.base = new Base();
	        frontContainer.addChild(base);
	        base.setup();
	        var blockContainer = this.blockContainer = new engine.Container();
	        frontContainer.addChild(blockContainer);
	        var player = this.player = new Player();
	        frontContainer.addChild(player);
	        player.setup();
	        player.addEventListener('jump-on-top', this.onPlayerJumpOnTop, this);
	        ObjectPool.recycleObject(PoolName, ObjectPool.getObject(PoolName, {
	            y: 0,
	            remain: 0,
	        }));
	        this.hitEffect = createSvga('被撞烟雾', 'hitEffectAnchor');
	        this.pos = 0;
	        this.background.setup();
	        this.addEventListener(engine.Event.ENTER_FRAME, this.onEnterFrame, this);
	        this.reset();
	    };
	    GameView.prototype.reset = function (revive) {
	        if (revive === void 0) { revive = false; }
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var blockContainer, i, li, block, i, i, li, goldBag;
	            return tslib.__generator(this, function (_a) {
	                switch (_a.label) {
	                    case 0:
	                        this.base.reset();
	                        this.index = -1;
	                        this._score = 0;
	                        if (revive) ;
	                        else {
	                            this.pos = 0;
	                            blockContainer = this.blockContainer;
	                            for (i = 0, li = blockContainer.children.length; i < li; i++) {
	                                block = blockContainer.getChildAt(i);
	                                block.playLeave();
	                            }
	                        }
	                        for (i = 0; i < props.initBlockCount; i++) {
	                            this.addBlock(false);
	                        }
	                        for (i = 0, li = this.goldBags.length; i < li; i++) {
	                            goldBag = this.goldBags[i];
	                            this.frontContainer.removeChild(goldBag);
	                            ObjectPool.recycleObject(PoolName, goldBag);
	                        }
	                        this.goldBags.splice(0);
	                        this.playZoom('in');
	                        return [4, this.resetPlayer(revive)];
	                    case 1:
	                        _a.sent();
	                        return [2];
	                }
	            });
	        });
	    };
	    GameView.prototype.resetPlayer = function (revive) {
	        if (revive === void 0) { revive = false; }
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            return tslib.__generator(this, function (_a) {
	                this.player.reset(revive);
	                this.player.y = this.baseOffset - (this.index + 1) * props.blockHitHeight;
	                return [2];
	            });
	        });
	    };
	    GameView.prototype.start = function (revive) {
	        if (revive === void 0) { revive = false; }
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var guideFlagKey, guideFlag;
	            var _this = this;
	            return tslib.__generator(this, function (_a) {
	                switch (_a.label) {
	                    case 0:
	                        if (!!revive) return [3, 2];
	                        return [4, this.player.playReady()];
	                    case 1:
	                        _a.sent();
	                        _a.label = 2;
	                    case 2:
	                        guideFlagKey = 'jump-high-guide_' + props.guideFlagKey;
	                        guideFlag = localStorage.getItem(guideFlagKey);
	                        if (!!guideFlag) return [3, 4];
	                        localStorage.setItem(guideFlagKey, '1');
	                        return [4, this.guideLayer.show('', { y: this.stage.height + this.player.y - 280 })];
	                    case 3:
	                        _a.sent();
	                        _a.label = 4;
	                    case 4:
	                        this.lastLandType = 0;
	                        this._remainToShowGoldBag = props.goldBagScoreMultiple - props.goldBagScoreSubtraction;
	                        this._touchEnabled = true;
	                        setTimeout(function () {
	                            _this.addBlock();
	                        }, 100);
	                        engine.globalEvent.dispatchEvent('jump-high-game-start');
	                        return [2];
	                }
	            });
	        });
	    };
	    GameView.prototype.pause = function () {
	        if (this.currentBlock) {
	            engine.Tween.pauseTweens(this.currentBlock);
	        }
	        engine.Tween.pauseTweens(this.player);
	    };
	    GameView.prototype.resume = function () {
	        if (this.currentBlock) {
	            engine.Tween.resumeTweens(this.currentBlock);
	        }
	        engine.Tween.resumeTweens(this.player);
	    };
	    GameView.prototype.revive = function () {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            return tslib.__generator(this, function (_a) {
	                switch (_a.label) {
	                    case 0:
	                        this.blockContainer.getChildAt(this.index).visible = false;
	                        this.index--;
	                        return [4, this.resetPlayer(true)];
	                    case 1:
	                        _a.sent();
	                        return [4, this.playZoom('in')];
	                    case 2:
	                        _a.sent();
	                        this.start(true);
	                        return [2];
	                }
	            });
	        });
	    };
	    GameView.prototype.addBlock = function (animation) {
	        var _this = this;
	        if (animation === void 0) { animation = true; }
	        this.index++;
	        var blockContainer = this.blockContainer;
	        var block;
	        if (blockContainer.children.length > this.index) {
	            block = blockContainer.getChildAt(this.index);
	            block.visible = true;
	        }
	        else {
	            block = new Block();
	            blockContainer.addChild(block);
	        }
	        block.reset({
	            type: Math.floor(Math.random() * props.blockAssets.length),
	        });
	        block.y = this.baseOffset - this.index * props.blockHitHeight;
	        this.blockComplete = false;
	        block.playEnter(this.index, animation).then(function (data) {
	            _this.blockComplete = true;
	        });
	        if (animation) {
	            this.needHitTest = true;
	        }
	        this.currentBlock = block;
	    };
	    GameView.prototype.addGoldBag = function () {
	        var goldBag = ObjectPool.getObject(PoolName, {
	            y: this.baseOffset - (this.blockCount + props.goldBagDistance + props.goldBagJumpSubtraction) * props.blockHitHeight,
	            remain: props.goldBagDistance,
	        });
	        this.frontContainer.addChild(goldBag);
	        this.goldBags.push(goldBag);
	    };
	    GameView.prototype.playOpenGoldBag = function () {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var i, li, goldBag;
	            return tslib.__generator(this, function (_a) {
	                switch (_a.label) {
	                    case 0:
	                        i = 0, li = this.goldBags.length;
	                        _a.label = 1;
	                    case 1:
	                        if (!(i < li)) return [3, 4];
	                        goldBag = this.goldBags[i];
	                        goldBag.remain--;
	                        if (!(goldBag.remain <= 0)) return [3, 3];
	                        this.goldBags.splice(i, 1);
	                        i--;
	                        li--;
	                        this.nextToUpdateScore = true;
	                        return [4, goldBag.playOpen()];
	                    case 2:
	                        _a.sent();
	                        this.frontContainer.removeChild(goldBag);
	                        ObjectPool.recycleObject(PoolName, goldBag);
	                        _a.label = 3;
	                    case 3:
	                        i++;
	                        return [3, 1];
	                    case 4: return [2];
	                }
	            });
	        });
	    };
	    GameView.prototype.onPlayerJumpOnTop = function () {
	        if (this.nextToUpdateScore) {
	            this.nextToUpdateScore = false;
	            this.scoreChange(4);
	            playSound('撞击钱袋音效');
	        }
	    };
	    Object.defineProperty(GameView.prototype, "blockCount", {
	        get: function () {
	            return this.index - props.initBlockCount + 1;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(GameView.prototype, "pos", {
	        get: function () {
	            return this._pos;
	        },
	        set: function (v) {
	            this._pos = v;
	            this.updatePos();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    GameView.prototype.updatePos = function () {
	        this.frontContainer.y = this.stage.height + this._pos;
	    };
	    GameView.prototype.onEnterFrame = function (event) {
	        if (this.needHitTest) {
	            if (this.currentBlock) {
	                var _a = this.currentBlock, bx = _a.x, by = _a.y, dir = _a.dir;
	                var _b = this.player, px = _b.x, py = _b.y;
	                var blockHitWidth = props.blockHitWidth, blockHitHeight = props.blockHitHeight, playerWidth = props.playerWidth;
	                var hitOn = false;
	                if (Math.abs(px - bx) < (blockHitWidth + playerWidth) / 2) {
	                    this.player.changeBaseY(by - blockHitHeight);
	                    if (py > by - blockHitHeight) {
	                        hitOn = true;
	                    }
	                }
	                if (hitOn) {
	                    this.onHitOn(dir);
	                }
	            }
	        }
	    };
	    GameView.prototype.onHitOn = function (dir) {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            return tslib.__generator(this, function (_a) {
	                switch (_a.label) {
	                    case 0:
	                        this._touchEnabled = false;
	                        this.needHitTest = false;
	                        clearInterval(this.timer);
	                        this.currentBlock.stop();
	                        this.playHitEffect(dir);
	                        return [4, this.player.hitAway(dir)];
	                    case 1:
	                        _a.sent();
	                        this.playZoom('out');
	                        return [4, this.player.parachute(dir)];
	                    case 2:
	                        _a.sent();
	                        engine.globalEvent.dispatchEvent('jump-high-game-end');
	                        return [2];
	                }
	            });
	        });
	    };
	    GameView.prototype.jump = function () {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var result, pos, type, lastLandType;
	            var _this = this;
	            return tslib.__generator(this, function (_a) {
	                switch (_a.label) {
	                    case 0:
	                        if (!this._touchEnabled) {
	                            return [2];
	                        }
	                        this._touchEnabled = false;
	                        this.playOpenGoldBag();
	                        return [4, this.player.jump()];
	                    case 1:
	                        result = _a.sent();
	                        if (!result) return [3, 5];
	                        if (!result.aboveBlock) return [3, 4];
	                        pos = Math.abs(this.currentBlock.x);
	                        type = 0;
	                        if (pos > 0) {
	                            type = pos > 0 && pos < props.scoreThreshold ? 2 : 3;
	                        }
	                        lastLandType = this.lastLandType;
	                        this.lastLandType = type;
	                        if (type === 0) {
	                            if (lastLandType !== type) {
	                                type = 1;
	                            }
	                        }
	                        if (type < 3) {
	                            this.currentBlock.playEffect();
	                        }
	                        this.player.playLand(type, this.currentBlock.dir);
	                        this.currentBlock.stop();
	                        this.scoreChange(type);
	                        return [4, this.playShake()];
	                    case 2:
	                        _a.sent();
	                        return [4, new Promise(function (resolve) {
	                                engine.Tween.get(_this, null, null, true)
	                                    .to({ pos: props.blockHitHeight * _this.index }, 300, engine.Ease.cubicOut)
	                                    .call(resolve);
	                            })];
	                    case 3:
	                        _a.sent();
	                        this.addBlock();
	                        _a.label = 4;
	                    case 4:
	                        this._touchEnabled = true;
	                        _a.label = 5;
	                    case 5: return [2];
	                }
	            });
	        });
	    };
	    GameView.prototype.scoreChange = function (type) {
	        var scoreAdd = props.scoreWeights[type];
	        this._score += scoreAdd;
	        this._remainToShowGoldBag -= scoreAdd;
	        var score = this._score;
	        engine.globalEvent.dispatchEvent('jump-high-score', {
	            type: type,
	            score: score,
	            scoreAdd: scoreAdd,
	        });
	        console.log(score, this._remainToShowGoldBag);
	        if (this._remainToShowGoldBag <= 0) {
	            this._remainToShowGoldBag += props.goldBagScoreMultiple;
	            this.addGoldBag();
	            console.log('addGoldBag');
	        }
	    };
	    GameView.prototype.playHitEffect = function (dir) {
	        var hitEffect = this.hitEffect;
	        hitEffect.scaleX = dir;
	        hitEffect.y = this.player.y - props.hitEffectAnchor.y;
	        hitEffect.play(true, false);
	        hitEffect.once(engine.Event.END_FRAME, function () {
	            this.frontContainer.removeChild(hitEffect);
	        }, this);
	        this.frontContainer.addChild(hitEffect);
	    };
	    GameView.prototype.playZoom = function (type, duration) {
	        var _this = this;
	        if (duration === void 0) { duration = 700; }
	        this.background.playZoom(type, duration);
	        var count = this.stage.height / props.blockHitHeight;
	        return new Promise(function (resolve) {
	            _this.frontContainer.anchorY = -props.blockHitHeight * (_this.index + count * 1.3) + props.baseOffset;
	            var scale = type === 'in' ? 1 : Math.min((_this.stage.height / props.blockHitHeight / (_this.index + count)), props.maxScale);
	            console.log(scale);
	            engine.Tween.get(_this.frontContainer, null, null, true)
	                .to({ scaleX: scale, scaleY: scale }, duration, engine.Ease.cubicInOut)
	                .call(resolve);
	        });
	    };
	    GameView.prototype.playShake = function () {
	        var _this = this;
	        var _a = this.frontContainer, x = _a.x, y = _a.y;
	        return new Promise(function (resolve) {
	            var shakeOffset = 7;
	            var duration = 30;
	            engine.Tween.get(_this.frontContainer, null, null, true)
	                .to({ x: x, y: y - shakeOffset }, duration)
	                .to({ x: x, y: y + shakeOffset }, duration)
	                .to({ x: x + shakeOffset, y: y }, duration)
	                .to({ x: x - shakeOffset, y: y }, duration)
	                .to({ x: x, y: y }, duration)
	                .call(resolve);
	        });
	    };
	    return GameView;
	}(engine.Container));

	var JumpHigh = (function (_super) {
	    tslib.__extends(JumpHigh, _super);
	    function JumpHigh() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('jump-high-reset', _this.reset, _this);
	        engine.globalEvent.addEventListener('jump-high-start', _this.start, _this);
	        engine.globalEvent.addEventListener('jump-high-pause', _this.pause, _this);
	        engine.globalEvent.addEventListener('jump-high-resume', _this.resume, _this);
	        engine.globalEvent.addEventListener('jump-high-revive', _this.revive, _this);
	        _this.addEventListener(engine.MouseEvent.MOUSE_DOWN, _this.onTap, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        return _this;
	    }
	    JumpHigh.prototype.reset = function () {
	        this._gameView.reset();
	    };
	    JumpHigh.prototype.start = function (event) {
	        {
	            injectProps(event.data);
	        }
	        this._status = 1;
	        this._gameView.start();
	    };
	    JumpHigh.prototype.pause = function () {
	        this._gameView.pause();
	    };
	    JumpHigh.prototype.resume = function () {
	        this._gameView.resume();
	    };
	    JumpHigh.prototype.revive = function () {
	        this._gameView.revive();
	    };
	    JumpHigh.prototype.onTap = function (event) {
	        this._gameView.jump();
	    };
	    return JumpHigh;
	}(engine.Container));

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new JumpHigh();
	    return instance;
	}

	return index;

})));

//# sourceMappingURL=main.js.map