/**
 * Created by rockyl on 2020-01-21.
 */
import {getTextureByName} from "./utils";
import {props} from "../props";


export class JumpTips extends engine.Container {
	private _bg: engine.Image;
	private _jumpTipsLabel: engine.Label;
	private _minScale: number;

	constructor() {
		super();

	}

	setup() {
	//	const {width, height} = this.stage;
		this.width=124;
		this.height=93;

		let bg = this._bg = new engine.Image(getTextureByName('跳跃提示背景'));
		bg.width=this.width;
		bg.height=this.height;
		bg.anchorX = bg.width / 2;
		bg.anchorY = bg.height / 2;
		this.addChild(bg);

		//this._minScale = width / bg.width;

		let jumpTipsLabel = this._jumpTipsLabel = new engine.Label();
		jumpTipsLabel.width=this.width;
		jumpTipsLabel.height=this.height;
		jumpTipsLabel.anchorX = jumpTipsLabel.width / 2;
		jumpTipsLabel.anchorY = jumpTipsLabel.height / 2;
		jumpTipsLabel.fillColor = "#fc4454";
		jumpTipsLabel.textAlign=engine.TEXT_ALIGN.CENTER;
		jumpTipsLabel.verticalAlign=engine.VERTICAL_ALIGN.MIDDLE;
		jumpTipsLabel.size = 24;
		jumpTipsLabel.rotation=-26;
		jumpTipsLabel.text = "+00";
		jumpTipsLabel.x=0;
		jumpTipsLabel.y=0;
		this.addChild(jumpTipsLabel);
		this.alpha=0;
	}

	show() {
		return new Promise(resolve => {
			this._jumpTipsLabel.text=props.jumpTips[parseInt((Math.random()*props.jumpTips.length)+"")]
			this.alpha=1;
			engine.Tween.get(this, null, null, true)
				.wait(800)
				.to({alpha: 0}, 200, engine.Ease.cubicInOut)
				.call(resolve);
		})
	}
}
