/**
 * Created by rockyl on 2020-01-21.
 */

import {props} from '../props'
import {createSvga, getTextureByName} from "./utils";

export class GoldBag extends engine.Container {
	private svga: svga.Svga;
	private avatar: engine.Sprite;

	remain: number;

	constructor() {
		super();

		this.setup();
	}

	setup() {
		let avatar = this.avatar = new engine.Sprite(getTextureByName('钱袋-静态'));
		avatar.x = -props.goldPackAvatarAnchor.x;
		avatar.y = -props.goldPackAvatarAnchor.y;
		this.addChild(avatar);
		let svga = this.svga = createSvga('钱袋', 'goldPackAnchor');
		svga.visible = false;
		this.addChild(svga);
	}

	reset(data) {
		this.y = data.y;
		this.avatar.visible = true;
		this.svga.visible = false;
		this.svga.gotoAndStop(1);
		this.remain = data.remain;
	}

	playOpen() {
		this.avatar.visible = false;
		this.svga.visible = true;
		return new Promise(resolve => {
			this.svga.play(true, false);
			this.svga.once(engine.Event.END_FRAME, function () {
				this.svga.visible = false;
				resolve();
			}, this);
		})
	}
}
